'DwArr.bas
#Dim All
#Compile Exe
#Include Once "WIN32API.INC"
#Include Once "..\DwArr.inc"

Macro lbxID = 1000
Macro btnID = 1001

CallBack Function BtnCB()
    Local i, Count As Long
    Local d As Double
    Local s As String

    Local arr As Long
    Local clone As Long

    arr = DwArrNew() 'allocate new container

    Randomize
    ListBox Reset CbHndl, lbxID
    Count = 100000

    ListBox Add CbHndl, lbxID, "append 10,000 values to empty array - ReDim automatic"
    d = Timer
    For i = 1 To 10000
        DwArrAdd arr, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(DwArrCount(arr), "#,")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "insert 10,000 values into empty array at index #1 - ReDim automatic"
    DwArrClear arr
    DwArrAdd arr, 0
    d = Timer
    For i = 1 To 10000
        DwArrIns arr, 1, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(DwArrCount(arr), "#,")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "ReDim array to " + Format$(Count, "#,")
    DwArrReDim arr, Count

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "set all "+Format$(Count, "#,")+" values in array"
    d = Timer
    For i = 1 To Count
        DwArrSet arr, i, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "get and test all "+Format$(Count, "#,")+" values in array"
    d = Timer
    For i = 1 To Count
        If DwArrGet(arr, i) <> i Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'reverse array

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "reverse array"
    d = Timer
    DwArrReverse arr
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.00000")
    ListBox Add CbHndl, lbxID, "-- first 2 values ---"
    ListBox Add CbHndl, lbxID, Str$(DwArrGet(arr, 1))
    ListBox Add CbHndl, lbxID, Str$(DwArrGet(arr, 2))
    ListBox Add CbHndl, lbxID, "-- last 2 values ---"
    ListBox Add CbHndl, lbxID, Str$(DwArrGet(arr, DwArrCount(arr) - 1))
    ListBox Add CbHndl, lbxID, Str$(DwArrGet(arr, DwArrCount(arr)))

    'sort array

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "sort array"
    d = Timer
    DwArrSort arr
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.00000")
    ListBox Add CbHndl, lbxID, "-- first 2 values ---"
    ListBox Add CbHndl, lbxID, Str$(DwArrGet(arr, 1))
    ListBox Add CbHndl, lbxID, Str$(DwArrGet(arr, 2))
    ListBox Add CbHndl, lbxID, "-- last 2 values ---"
    ListBox Add CbHndl, lbxID, Str$(DwArrGet(arr, DwArrCount(arr) - 1))
    ListBox Add CbHndl, lbxID, Str$(DwArrGet(arr, DwArrCount(arr)))

    'test sort
    For i = 1 To DwArrCount(arr) - 1
        If DwArrGet(arr, i) > DwArrGet(arr, i + 1) Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i

    'binary search

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "binary search for all "+Format$(DwArrCount(arr), "#,")+" values in array"
    d = Timer
    For i = 1 To Count
        If DwArrBinSearch(arr, i) <> i Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.00000")

    'binary insert - insert value in sort order

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clear array"
    DwArrClear arr
    ListBox Add CbHndl, lbxID, "binary insert 10 random values: Rnd(1, 5)"
    For i = 1 To 10
        DwArrBinInsert arr, Rnd(1, 5)
    Next i
    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To DwArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(DwArrGet(arr, i))
    Next i

    'unique - delete all duplicates

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "unique array"
    DwArrUniqueSort arr
    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To DwArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(DwArrGet(arr, i))
    Next i

    'remove

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "remove all odd numbers"
    For i = DwArrCount(arr) To 1 Step -1
        If DwArrGet(arr, i) Mod 2 Then DwArrDel arr, i
    Next i
    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To DwArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(DwArrGet(arr, i))
    Next i

    'Stack

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Stack"
    ListBox Add CbHndl, lbxID, "Push 1, 2, 3 on Stack"
    DwArrClear arr
    DwArrStkPush arr, 1
    DwArrStkPush arr, 2
    DwArrStkPush arr, 3
    ListBox Add CbHndl, lbxID, "Peek and Pop Stack"
    While DwArrCount(arr)
        ListBox Add CbHndl, lbxID, "Peek() = " + Format$(DwArrStkPeek(arr))
        ListBox Add CbHndl, lbxID, "Pop() = " + Format$(DwArrStkPop(arr))
    Wend

    'Queue

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Queue"
    ListBox Add CbHndl, lbxID, "Add 1, 2, 3 to Queue"
    DwArrClear arr
    DwArrQuePush arr, 1
    DwArrQuePush arr, 2
    DwArrQuePush arr, 3
    ListBox Add CbHndl, lbxID, "Peek and Pop Queue"
    While DwArrCount(arr)
        ListBox Add CbHndl, lbxID, "Peek = " + Format$(DwArrQuePeek(arr))
        ListBox Add CbHndl, lbxID, "Pop = " + Format$(DwArrQuePop(arr))
    Wend

    'Deque - double-ended Queue

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Deque - double-ended Queue"
    ListBox Add CbHndl, lbxID, "Add 1, 2, 3 to Front of Deque"
    DwArrClear arr
    DwArrPushFirst arr, 1
    DwArrPushFirst arr, 2
    DwArrPushFirst arr, 3
    ListBox Add CbHndl, lbxID, "Add 4, 5, 6 to End of Deque"
    DwArrPushLast arr, 4
    DwArrPushLast arr, 5
    DwArrPushLast arr, 6
    ListBox Add CbHndl, lbxID, "Peek and Pop Deque"
    While DwArrCount(arr)
        ListBox Add CbHndl, lbxID, "PeekFirst = " + Format$(DwArrPeekFirst(arr))
        ListBox Add CbHndl, lbxID, "PopFirst = " + Format$(DwArrPopFirst(arr))
        ListBox Add CbHndl, lbxID, "PeekLast = " + Format$(DwArrPeekLast(arr))
        ListBox Add CbHndl, lbxID, "PopLast = " + Format$(DwArrPopLast(arr))
    Wend

    'Clone

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Clone"
    ListBox Add CbHndl, lbxID, "add 1, 2, 3 to array"
    DwArrClear arr
    For i = 1 To 3
        DwArrAdd arr, i
    Next i
    ListBox Add CbHndl, lbxID, "clone array"
    clone = DwArrClone(arr)
    ListBox Add CbHndl, lbxID, "display Clone"
    For i = 1 To DwArrCount(clone)
        ListBox Add CbHndl, lbxID, Format$(DwArrGet(clone, i))
    Next i

    'Store/Restore: store/restore container to/from string

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store array to String"
    s = DwArrStore(arr)

    ListBox Add CbHndl, lbxID, "clear array"
    DwArrClear arr

    ListBox Add CbHndl, lbxID, "restore array from String"
    DwArrRestore arr, s

    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To DwArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(DwArrGet(arr, i))
    Next i

    'FileStore/FileRestore: store/restore container to/from file

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store array to File"
    DwArrFileStore arr, "test.data"

    ListBox Add CbHndl, lbxID, "clear array"
    DwArrClear arr

    ListBox Add CbHndl, lbxID, "restore array from File"
    DwArrFileRestore arr, "test.data"

    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To DwArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(DwArrGet(arr, i))
    Next i

    If IsFile("test.data") Then Kill "test.data"

    'must free handles before they go out of scope
    arr = DwArrFinal(arr)
    clone = DwArrFinal(clone)

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "done..."
End Function

Function PBMain()
    Local hDlg As Long
    Dialog New 0, "DwArr.bas", 67, 61, 341, 241, %WS_Caption Or %WS_ClipSiblings Or %WS_MinimizeBox Or %WS_SysMenu, %WS_Ex_AppWindow To hDlg
    Control Add ListBox, hDlg, lbxID, , 5, 5, 330, 210, %WS_Child Or %WS_HScroll Or %WS_VScroll Or %LBS_Notify Or %LBS_NoIntegralHeight, %WS_Ex_ClientEdge
    Control Add Button,  hDlg, btnID, "Test", 275, 220, 60, 15 Call BtnCB()
    Dialog Show Modal hDlg, Call DlgCB
End Function

CallBack Function DlgCB()
End Function
