'LnArr.bas
#Dim All
#Compile Exe
#Include Once "WIN32API.INC"
#Include Once "..\LnArr.inc"

Macro lbxID = 1000
Macro btnID = 1001

CallBack Function BtnCB()
    Local i, Count As Long
    Local d As Double
    Local s As String

    Local arr As Long
    Local clone As Long

    arr = LnArrNew() 'allocate new container

    Randomize
    ListBox Reset CbHndl, lbxID
    Count = 100000

    ListBox Add CbHndl, lbxID, "append 10,000 values to empty array - ReDim automatic"
    d = Timer
    For i = 1 To 10000
        LnArrAdd arr, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(LnArrCount(arr), "#,")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "insert 10,000 values into empty array at index #1 - ReDim automatic"
    LnArrClear arr
    LnArrAdd arr, 0
    d = Timer
    For i = 1 To 10000
        LnArrIns arr, 1, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(LnArrCount(arr), "#,")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "ReDim array to " + Format$(Count, "#,")
    LnArrReDim arr, Count

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "set all "+Format$(Count, "#,")+" values in array"
    d = Timer
    For i = 1 To Count
        LnArrSet arr, i, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "get and test all "+Format$(Count, "#,")+" values in array"
    d = Timer
    For i = 1 To Count
        If LnArrGet(arr, i) <> i Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'reverse array

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "reverse array"
    d = Timer
    LnArrReverse arr
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.00000")
    ListBox Add CbHndl, lbxID, "-- first 2 values ---"
    ListBox Add CbHndl, lbxID, Str$(LnArrGet(arr, 1))
    ListBox Add CbHndl, lbxID, Str$(LnArrGet(arr, 2))
    ListBox Add CbHndl, lbxID, "-- last 2 values ---"
    ListBox Add CbHndl, lbxID, Str$(LnArrGet(arr, LnArrCount(arr) - 1))
    ListBox Add CbHndl, lbxID, Str$(LnArrGet(arr, LnArrCount(arr)))

    'sort array

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "sort array"
    d = Timer
    LnArrSort arr
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.00000")
    ListBox Add CbHndl, lbxID, "-- first 2 values ---"
    ListBox Add CbHndl, lbxID, Str$(LnArrGet(arr, 1))
    ListBox Add CbHndl, lbxID, Str$(LnArrGet(arr, 2))
    ListBox Add CbHndl, lbxID, "-- last 2 values ---"
    ListBox Add CbHndl, lbxID, Str$(LnArrGet(arr, LnArrCount(arr) - 1))
    ListBox Add CbHndl, lbxID, Str$(LnArrGet(arr, LnArrCount(arr)))

    'test sort
    For i = 1 To LnArrCount(arr) - 1
        If LnArrGet(arr, i) > LnArrGet(arr, i + 1) Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i

    'binary search

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "binary search for all "+Format$(LnArrCount(arr), "#,")+" values in array"
    d = Timer
    For i = 1 To Count
        If LnArrBinSearch(arr, i) <> i Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.00000")

    'binary insert - insert value in sort order

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clear array"
    LnArrClear arr
    ListBox Add CbHndl, lbxID, "binary insert 10 random values: Rnd(1, 5)"
    For i = 1 To 10
        LnArrBinInsert arr, Rnd(1, 5)
    Next i
    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To LnArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(LnArrGet(arr, i))
    Next i

    'unique - delete all duplicates

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "unique array"
    LnArrUniqueSort arr
    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To LnArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(LnArrGet(arr, i))
    Next i

    'remove

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "remove all odd numbers"
    For i = LnArrCount(arr) To 1 Step -1
        If LnArrGet(arr, i) Mod 2 Then LnArrDel arr, i
    Next i
    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To LnArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(LnArrGet(arr, i))
    Next i

    'Stack

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Stack"
    ListBox Add CbHndl, lbxID, "Push 1, 2, 3 on Stack"
    LnArrClear arr
    LnArrStkPush arr, 1
    LnArrStkPush arr, 2
    LnArrStkPush arr, 3
    ListBox Add CbHndl, lbxID, "Peek and Pop Stack"
    While LnArrCount(arr)
        ListBox Add CbHndl, lbxID, "Peek() = " + Format$(LnArrStkPeek(arr))
        ListBox Add CbHndl, lbxID, "Pop() = " + Format$(LnArrStkPop(arr))
    Wend

    'Queue

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Queue"
    ListBox Add CbHndl, lbxID, "Add 1, 2, 3 to Queue"
    LnArrClear arr
    LnArrQuePush arr, 1
    LnArrQuePush arr, 2
    LnArrQuePush arr, 3
    ListBox Add CbHndl, lbxID, "Peek and Pop Queue"
    While LnArrCount(arr)
        ListBox Add CbHndl, lbxID, "Peek = " + Format$(LnArrQuePeek(arr))
        ListBox Add CbHndl, lbxID, "Pop = " + Format$(LnArrQuePop(arr))
    Wend

    'Deque - double-ended Queue

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Deque - double-ended Queue"
    ListBox Add CbHndl, lbxID, "Add 1, 2, 3 to Front of Deque"
    LnArrClear arr
    LnArrPushFirst arr, 1
    LnArrPushFirst arr, 2
    LnArrPushFirst arr, 3
    ListBox Add CbHndl, lbxID, "Add 4, 5, 6 to End of Deque"
    LnArrPushLast arr, 4
    LnArrPushLast arr, 5
    LnArrPushLast arr, 6
    ListBox Add CbHndl, lbxID, "Peek and Pop Deque"
    While LnArrCount(arr)
        ListBox Add CbHndl, lbxID, "PeekFirst = " + Format$(LnArrPeekFirst(arr))
        ListBox Add CbHndl, lbxID, "PopFirst = " + Format$(LnArrPopFirst(arr))
        ListBox Add CbHndl, lbxID, "PeekLast = " + Format$(LnArrPeekLast(arr))
        ListBox Add CbHndl, lbxID, "PopLast = " + Format$(LnArrPopLast(arr))
    Wend

    'Clone

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Clone"
    ListBox Add CbHndl, lbxID, "add 1, 2, 3 to array"
    LnArrClear arr
    For i = 1 To 3
        LnArrAdd arr, i
    Next i
    ListBox Add CbHndl, lbxID, "clone array"
    clone = LnArrClone(arr)
    ListBox Add CbHndl, lbxID, "display Clone"
    For i = 1 To LnArrCount(clone)
        ListBox Add CbHndl, lbxID, Format$(LnArrGet(clone, i))
    Next i

    'Store/Restore: store/restore container to/from string

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store array to String"
    s = LnArrStore(arr)

    ListBox Add CbHndl, lbxID, "clear array"
    LnArrClear arr

    ListBox Add CbHndl, lbxID, "restore array from String"
    LnArrRestore arr, s

    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To LnArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(LnArrGet(arr, i))
    Next i

    'FileStore/FileRestore: store/restore container to/from file

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store array to File"
    LnArrFileStore arr, "test.data"

    ListBox Add CbHndl, lbxID, "clear array"
    LnArrClear arr

    ListBox Add CbHndl, lbxID, "restore array from File"
    LnArrFileRestore arr, "test.data"

    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To LnArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(LnArrGet(arr, i))
    Next i

    If IsFile("test.data") Then Kill "test.data"

    'must free handles before they go out of scope
    arr = LnArrFinal(arr)
    clone = LnArrFinal(clone)

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "done..."
End Function

Function PBMain()
    Local hDlg As Long
    Dialog New 0, "LnArr.bas", 67, 61, 341, 241, %WS_Caption Or %WS_ClipSiblings Or %WS_MinimizeBox Or %WS_SysMenu, %WS_Ex_AppWindow To hDlg
    Control Add ListBox, hDlg, lbxID, , 5, 5, 330, 210, %WS_Child Or %WS_HScroll Or %WS_VScroll Or %LBS_Notify Or %LBS_NoIntegralHeight, %WS_Ex_ClientEdge
    Control Add Button,  hDlg, btnID, "Test", 275, 220, 60, 15 Call BtnCB()
    Dialog Show Modal hDlg, Call DlgCB
End Function

CallBack Function DlgCB()
End Function
