'WsArr.bas
#Dim All
#Compile Exe
#Include Once "WIN32API.INC"
#Include Once "..\WsArr.inc"

Macro lbxID = 1000
Macro btnID = 1001

CallBack Function BtnCB()
    Local i, Count As Long
    Local d As Double
    Local s As String
    Local a() As WString

    Local arr As Long
    Local clone As Long

    arr = WsArrNew() 'allocate new container

    Randomize
    ListBox Reset CbHndl, lbxID
    Count = 100000
    ReDim a(1 To Count)
    For i = 1 To Count
        a(i) = Format$(i, "0000000")
    Next i

    ListBox Add CbHndl, lbxID, "append 10,000 values to empty array - ReDim automatic"
    d = Timer
    For i = 1 To 10000
        WsArrAdd arr, a(i)
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(WsArrCount(arr), "#,")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "insert 10,000 values into empty array at index #1 - ReDim automatic"
    WsArrClear arr
    WsArrAdd arr, ""
    d = Timer
    For i = 1 To 10000
        WsArrIns arr, 1, a(i)
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(WsArrCount(arr), "#,")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "ReDim array to " + Format$(Count, "#,")
    WsArrReDim arr, Count

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "set all "+Format$(Count, "#,")+" values in array"
    d = Timer
    For i = 1 To Count
        WsArrSet arr, i, a(i)
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "get and test all "+Format$(Count, "#,")+" values in array"
    d = Timer
    For i = 1 To Count
        If WsArrGet(arr, i) <> a(i) Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'reverse array

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "reverse array"
    d = Timer
    WsArrReverse arr
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.00000")
    ListBox Add CbHndl, lbxID, "-- first 2 values ---"
    ListBox Add CbHndl, lbxID, WsArrGet(arr, 1)
    ListBox Add CbHndl, lbxID, WsArrGet(arr, 2)
    ListBox Add CbHndl, lbxID, "-- last 2 values ---"
    ListBox Add CbHndl, lbxID, WsArrGet(arr, WsArrCount(arr) - 1)
    ListBox Add CbHndl, lbxID, WsArrGet(arr, WsArrCount(arr))

    'sort array

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "sort array"
    d = Timer
    WsArrSort arr
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.00000")
    ListBox Add CbHndl, lbxID, "-- first 2 values ---"
    ListBox Add CbHndl, lbxID, WsArrGet(arr, 1)
    ListBox Add CbHndl, lbxID, WsArrGet(arr, 2)
    ListBox Add CbHndl, lbxID, "-- last 2 values ---"
    ListBox Add CbHndl, lbxID, WsArrGet(arr, WsArrCount(arr) - 1)
    ListBox Add CbHndl, lbxID, WsArrGet(arr, WsArrCount(arr))

    'test sort
    For i = 1 To WsArrCount(arr) - 1
        If WsArrGet(arr, i) > WsArrGet(arr, i + 1) Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i

    'binary search

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "binary search for all "+Format$(WsArrCount(arr), "#,")+" values in array"
    d = Timer
    For i = 1 To Count
        If WsArrBinSearch(arr, a(i)) <> i Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.00000")

    'binary insert - insert value in sort order

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clear array"
    WsArrClear arr
    ListBox Add CbHndl, lbxID, "binary insert 10 random values: Rnd(1, 5)"
    For i = 1 To 10
        WsArrBinInsert arr, a(Rnd(1, 5))
    Next i
    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To WsArrCount(arr)
        ListBox Add CbHndl, lbxID, WsArrGet(arr, i)
    Next i

    'unique - delete all duplicates

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "unique array"
    WsArrUniqueSort arr
    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To WsArrCount(arr)
        ListBox Add CbHndl, lbxID, WsArrGet(arr, i)
    Next i

    'remove

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "remove all odd numbers"
    For i = WsArrCount(arr) To 1 Step -1
        If Val(WsArrGet(arr, i)) Mod 2 Then WsArrDel arr, i
    Next i
    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To WsArrCount(arr)
        ListBox Add CbHndl, lbxID, WsArrGet(arr, i)
    Next i

    'Stack

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Stack"
    ListBox Add CbHndl, lbxID, "Push 1, 2, 3 on Stack"
    WsArrClear arr
    WsArrStkPush arr, a(1)
    WsArrStkPush arr, a(2)
    WsArrStkPush arr, a(3)
    ListBox Add CbHndl, lbxID, "Peek and Pop Stack"
    While WsArrCount(arr)
        ListBox Add CbHndl, lbxID, "Peek() = " + WsArrStkPeek(arr)
        ListBox Add CbHndl, lbxID, "Pop() = " + WsArrStkPop(arr)
    Wend

    'Queue

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Queue"
    ListBox Add CbHndl, lbxID, "Add 1, 2, 3 to Queue"
    WsArrClear arr
    WsArrQuePush arr, a(1)
    WsArrQuePush arr, a(2)
    WsArrQuePush arr, a(3)
    ListBox Add CbHndl, lbxID, "Peek and Pop Queue"
    While WsArrCount(arr)
        ListBox Add CbHndl, lbxID, "Peek = " + WsArrQuePeek(arr)
        ListBox Add CbHndl, lbxID, "Pop = " + WsArrQuePop(arr)
    Wend

    'Deque - double-ended Queue

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Deque - double-ended Queue"
    ListBox Add CbHndl, lbxID, "Add A, B, C to Front of Deque"
    WsArrClear arr
    WsArrPushFirst arr, "A"
    WsArrPushFirst arr, "B"
    WsArrPushFirst arr, "C"
    ListBox Add CbHndl, lbxID, "Add X, Y, Z to End of Deque"
    WsArrPushLast arr, "X"
    WsArrPushLast arr, "Y"
    WsArrPushLast arr, "Z"
    ListBox Add CbHndl, lbxID, "Peek and Pop Deque"
    While WsArrCount(arr)
        ListBox Add CbHndl, lbxID, "PeekFirst = " + WsArrPeekFirst(arr)
        ListBox Add CbHndl, lbxID, "PopFirst = " + WsArrPopFirst(arr)
        ListBox Add CbHndl, lbxID, "PeekLast = " + WsArrPeekLast(arr)
        ListBox Add CbHndl, lbxID, "PopLast = " + WsArrPopLast(arr)
    Wend

    'Clone

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Clone"
    ListBox Add CbHndl, lbxID, "add 1, 2, 3 to array"
    WsArrClear arr
    For i = 1 To 3
        WsArrAdd arr, a(i)
    Next i
    ListBox Add CbHndl, lbxID, "clone array"
    clone = WsArrClone(arr)
    ListBox Add CbHndl, lbxID, "display Clone"
    For i = 1 To WsArrCount(clone)
        ListBox Add CbHndl, lbxID, WsArrGet(clone, i)
    Next i

    'Store/Restore: store/restore container to/from string

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store array to String"
    s = WsArrStore(arr)

    ListBox Add CbHndl, lbxID, "clear array"
    WsArrClear arr

    ListBox Add CbHndl, lbxID, "restore array from String"
    WsArrRestore arr, s

    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To WsArrCount(arr)
        ListBox Add CbHndl, lbxID, WsArrGet(arr, i)
    Next i

    'FileStore/FileRestore: store/restore container to/from file

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store array to File"
    WsArrFileStore arr, "test.data"

    ListBox Add CbHndl, lbxID, "clear array"
    WsArrClear arr

    ListBox Add CbHndl, lbxID, "restore array from File"
    WsArrFileRestore arr, "test.data"

    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To WsArrCount(arr)
        ListBox Add CbHndl, lbxID, WsArrGet(arr, i)
    Next i

    If IsFile("test.data") Then Kill "test.data"

    'must free handles before they go out of scope
    arr = WsArrFinal(arr)
    clone = WsArrFinal(clone)

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "done..."
End Function

Function PBMain()
    Local hDlg As Long
    Dialog New 0, "WsArr.bas", 67, 61, 341, 241, %WS_Caption Or %WS_ClipSiblings Or %WS_MinimizeBox Or %WS_SysMenu, %WS_Ex_AppWindow To hDlg
    Control Add ListBox, hDlg, lbxID, , 5, 5, 330, 210, %WS_Child Or %WS_HScroll Or %WS_VScroll Or %LBS_Notify Or %LBS_NoIntegralHeight, %WS_Ex_ClientEdge
    Control Add Button,  hDlg, btnID, "Test", 275, 220, 60, 15 Call BtnCB()
    Dialog Show Modal hDlg, Call DlgCB
End Function

CallBack Function DlgCB()
End Function
