#Include This Once
#Include Once "C:\HLib3\HLib.inc"

'++
    '----------------------------------------------------------------------------------------
    '   Dword Queue Container
    '       extremely fast, memory efficient and CPU Cache friendly Queue implementation
    '       - each node has a fixed array of 500 items
    '       - memory allocation and deallocation only takes place every 500'th item
    '       - CPU Cache loves small arrays
    '       - way more efficient for small data types; Byte, Integer, Word, ...
    '
    '       container accessed with handle
    '       handle protected by hash tag
    '       h = DwQueNew() 'get handle for new container
    '       h = DwQueFinal(h) 'free handle before it goes out of scope
    '----------------------------------------------------------------------------------------
'--

Macro DwQueTag = 460830320
Type DwQueNode
    next As DwQueNode Ptr
    first As Long
    last As Long
    arr(1 To %QueMax) As Dword
End Type
Type DwQue
    tag As Long
    count As Long
    first As DwQueNode Ptr
    last As DwQueNode Ptr
End Type

Function DwQueNew() As Long
    'allocate new container - return handle
    Local p As DwQue Ptr
    p = MemAlloc(SizeOf(@p))
    ExitF(p=0, LibErrM)
    @p.tag = DwQueTag
    Function = p
End Function

Function DwQueFinal(ByVal p As DwQue Ptr) As Long
    'free allocated container - return null
    If p Then
        ExitF(@p.tag<>DwQueTag, LibErrH)
        DwQueClear p
        MemFree(p)
    End If
End Function

Function DwQueValidate(ByVal p As DwQue Ptr) As Long
    'True/False if valid handle for this container
    If p And @p.tag = DwQueTag Then Function = @p.tag
End Function

Sub DwQueClear(ByVal p As DwQue Ptr)
    'delete all data
    Local node As DwQueNode Ptr
    ExitS(p=0 Or @p.tag<>DwQueTag, LibErrH)
    While @p.first
        node = @p.first
        @p.first = @node.next
        MemFree(node)
    Wend
    @p.first = 0
    @p.last = 0
    @p.count = 0
End Sub

Function DwQueCount(ByVal p As DwQue Ptr) As Long
    'get item count
    ExitF(p=0 Or @p.tag<>DwQueTag, LibErrH)
    Function = @p.count
End Function

Sub DwQuePush(ByVal p As DwQue Ptr, ByVal value As Dword)
    'add value to end of queue
    Local node As DwQueNode Ptr
    ExitS(p=0 Or @p.tag<>DwQueTag, LibErrH)
    If @p.count = 0 Then
        @p.last = MemAlloc(SizeOf(DwQueNode))
        ExitS(@p.last=0, LibErrM)
        @p.@last.arr(1) = value
        @p.@last.first = 1
        @p.@last.last = 1
        @p.first = @p.last
        @p.count = 1
    Else
        ExitS(@p.last=0, LibErrU)
        If @p.@last.last < %QueMax Then
            Incr @p.@last.last
            @p.@last.arr(@p.@last.last) = value
            Incr @p.count
        Else
            node = MemAlloc(SizeOf(DwQueNode))
            ExitS(node=0, LibErrM)
            @node.arr(1) = value
            @node.first = 1
            @node.last = 1
            @p.@last.next = node
            @p.last = node
            Incr @p.count
        End If
    End If
End Sub


Function DwQuePeek(ByVal p As DwQue Ptr) As Dword
    'get first value in queue
    ExitF(p=0 Or @p.tag<>DwQueTag, LibErrH)
    If @p.count Then
        ExitF(@p.first=0, LibErrU)
        Function = @p.@first.arr(@p.@first.first)
    End If
End Function

Function DwQuePop(ByVal p As DwQue Ptr) As Dword
    'get and remove first value in queue
    Local node As DwQueNode Ptr
    ExitF(p=0 Or @p.tag<>DwQueTag, LibErrH)
    If @p.count Then
        ExitF(@p.first=0, LibErrU)
        Function = @p.@first.arr(@p.@first.first)
        Decr @p.count
        If @p.count = 0 Then
            DwQueClear p
        Else
            Incr @p.@first.first
            If @p.@first.first > @p.@first.last Then
                node = @p.first
                @p.first = @p.@first.next
                MemFree(node)
            End If
        End If
    End If
End Function
