#Include This Once
#Include Once "C:\HLib3\HLib.inc"

'++
    '----------------------------------------------------------------------------------------
    '   Extended Queue Container
    '       extremely fast, memory efficient and CPU Cache friendly Queue implementation
    '       - each node has a fixed array of 500 items
    '       - memory allocation and deallocation only takes place every 500'th item
    '       - CPU Cache loves small arrays
    '       - way more efficient for small data types; Byte, Integer, Word, ...
    '
    '       container accessed with handle
    '       handle protected by hash tag
    '       h = ExQueNew() 'get handle for new container
    '       h = ExQueFinal(h) 'free handle before it goes out of scope
    '----------------------------------------------------------------------------------------
'--

Macro ExQueTag = 1834559302
Type ExQueNode
    next As ExQueNode Ptr
    first As Long
    last As Long
    arr(1 To %QueMax) As Extended
End Type
Type ExQue
    tag As Long
    count As Long
    first As ExQueNode Ptr
    last As ExQueNode Ptr
End Type

Function ExQueNew() As Long
    'allocate new container - return handle
    Local p As ExQue Ptr
    p = MemAlloc(SizeOf(@p))
    ExitF(p=0, LibErrM)
    @p.tag = ExQueTag
    Function = p
End Function

Function ExQueFinal(ByVal p As ExQue Ptr) As Long
    'free allocated container - return null
    If p Then
        ExitF(@p.tag<>ExQueTag, LibErrH)
        ExQueClear p
        MemFree(p)
    End If
End Function

Function ExQueValidate(ByVal p As ExQue Ptr) As Long
    'True/False if valid handle for this container
    If p And @p.tag = ExQueTag Then Function = @p.tag
End Function

Sub ExQueClear(ByVal p As ExQue Ptr)
    'delete all data
    Local node As ExQueNode Ptr
    ExitS(p=0 Or @p.tag<>ExQueTag, LibErrH)
    While @p.first
        node = @p.first
        @p.first = @node.next
        MemFree(node)
    Wend
    @p.first = 0
    @p.last = 0
    @p.count = 0
End Sub

Function ExQueCount(ByVal p As ExQue Ptr) As Long
    'get item count
    ExitF(p=0 Or @p.tag<>ExQueTag, LibErrH)
    Function = @p.count
End Function

Sub ExQuePush(ByVal p As ExQue Ptr, ByVal value As Extended)
    'add value to end of queue
    Local node As ExQueNode Ptr
    ExitS(p=0 Or @p.tag<>ExQueTag, LibErrH)
    If @p.count = 0 Then
        @p.last = MemAlloc(SizeOf(ExQueNode))
        ExitS(@p.last=0, LibErrM)
        @p.@last.arr(1) = value
        @p.@last.first = 1
        @p.@last.last = 1
        @p.first = @p.last
        @p.count = 1
    Else
        ExitS(@p.last=0, LibErrU)
        If @p.@last.last < %QueMax Then
            Incr @p.@last.last
            @p.@last.arr(@p.@last.last) = value
            Incr @p.count
        Else
            node = MemAlloc(SizeOf(ExQueNode))
            ExitS(node=0, LibErrM)
            @node.arr(1) = value
            @node.first = 1
            @node.last = 1
            @p.@last.next = node
            @p.last = node
            Incr @p.count
        End If
    End If
End Sub


Function ExQuePeek(ByVal p As ExQue Ptr) As Extended
    'get first value in queue
    ExitF(p=0 Or @p.tag<>ExQueTag, LibErrH)
    If @p.count Then
        ExitF(@p.first=0, LibErrU)
        Function = @p.@first.arr(@p.@first.first)
    End If
End Function

Function ExQuePop(ByVal p As ExQue Ptr) As Extended
    'get and remove first value in queue
    Local node As ExQueNode Ptr
    ExitF(p=0 Or @p.tag<>ExQueTag, LibErrH)
    If @p.count Then
        ExitF(@p.first=0, LibErrU)
        Function = @p.@first.arr(@p.@first.first)
        Decr @p.count
        If @p.count = 0 Then
            ExQueClear p
        Else
            Incr @p.@first.first
            If @p.@first.first > @p.@first.last Then
                node = @p.first
                @p.first = @p.@first.next
                MemFree(node)
            End If
        End If
    End If
End Function
