#Include This Once
#Include Once "C:\HLib3\List\InLst.inc"

'++
    '----------------------------------------------------------------------------------------
    '   Integer Stack Container
    '       extremely fast, memory efficient and CPU Cache friendly Stack implementation
    '       - each node has a fixed array of 500 items
    '       - memory allocation and deallocation only takes place every 500'th item
    '       - CPU Cache loves small arrays
    '       - way more efficient for small data types; Byte, Integer, Word, ...
    '
    '       container accessed with handle
    '       handle protected by hash tag
    '       h = InStkNew() 'get handle for new container
    '       h = InStkFinal(h) 'free handle before it goes out of scope
    '----------------------------------------------------------------------------------------
'--

Macro InStkTag = -252380731
Type InStkNode
    prev As InStkNode Ptr
    index As Long
    arr(1 To %StkMax) As Integer
End Type
Type InStk
    tag As Long
    count As Long
    top As InStkNode Ptr
End Type

Function InStkNew() As Long
    'allocate new container - return handle
    Local p As InStk Ptr
    p = MemAlloc(SizeOf(@p))
    ExitF(p=0, LibErrM)
    @p.tag = InStkTag
    Function = p
End Function

Function InStkFinal(ByVal p As InStk Ptr) As Long
    'free allocated container - return null - Modifies Container Data
    If p Then
        ExitF(@p.tag<>InStkTag, LibErrH)
        InStkClear p
        MemFree(p)
    End If
End Function

Function InStkValidate(ByVal p As InStk Ptr) As Long
    'True/False if valid handle for this container
    If p And @p.tag = InStkTag Then Function = @p.tag
End Function

Sub InStkClear(ByVal p As InStk Ptr)
    'delete all data - Modifies Container Data
    Local node As InStkNode Ptr
    ExitS(p=0 Or @p.tag<>InStkTag, LibErrH)
    While @p.top
        node = @p.top
        @p.top = @node.prev
        MemFree(node)
    Wend
    @p.top = 0
    @p.count = 0
End Sub

Function InStkCount(ByVal p As InStk Ptr) As Long
    'get item count
    ExitF(p=0 Or @p.tag<>InStkTag, LibErrH)
    Function = @p.count
End Function

Sub InStkPush(ByVal p As InStk Ptr, ByVal value As Integer)
    'push value on top of stack
    Local node As InStkNode Ptr
    ExitS(p=0 Or @p.tag<>InStkTag, LibErrH)
    If @p.count = 0 Then
        @p.top = MemAlloc(SizeOf(InStkNode))
        ExitS(@p.top=0, LibErrM)
        @p.@top.arr(1) = value
        @p.@top.index = 1
        @p.count = 1
    ElseIf @p.@top.index < %StkMax Then
        Incr @p.@top.index
        @p.@top.arr(@p.@top.index) = value
        Incr @p.count
    Else
        node = MemAlloc(SizeOf(InStkNode))
        ExitS(node=0, LibErrM)
        @node.arr(1) = value
        @node.index = 1
        @node.prev = @p.top
        @p.top = node
        Incr @p.count
    End If
End Sub

Function InStkPeek(ByVal p As InStk Ptr) As Integer
    'get top value on stack
    ExitF(p=0 Or @p.tag<>InStkTag, LibErrH)
    If @p.count Then Function = @p.@top.arr(@p.@top.index)
End Function

Function InStkPop(ByVal p As InStk Ptr) As Integer
    'get and remove top value on stack
    Local node As InStkNode Ptr
    ExitF(p=0 Or @p.tag<>InStkTag, LibErrH)
    If @p.count Then
        Function = @p.@top.arr(@p.@top.index)
        Decr @p.@top.index
        Decr @p.count
        If @p.@top.index = 0 Then
            node = @p.top
            @p.top = @p.@top.prev
            MemFree(node)
        End If
    End If
End Function
