#Include This Once
#Include Once "C:\HLib3\List\SnLst.inc"

'++
    '----------------------------------------------------------------------------------------
    '   Single Stack Container
    '       extremely fast, memory efficient and CPU Cache friendly Stack implementation
    '       - each node has a fixed array of 500 items
    '       - memory allocation and deallocation only takes place every 500'th item
    '       - CPU Cache loves small arrays
    '       - way more efficient for small data types; Byte, Integer, Word, ...
    '
    '       container accessed with handle
    '       handle protected by hash tag
    '       h = SnStkNew() 'get handle for new container
    '       h = SnStkFinal(h) 'free handle before it goes out of scope
    '----------------------------------------------------------------------------------------
'--

Macro SnStkTag = -654407882
Type SnStkNode
    prev As SnStkNode Ptr
    index As Long
    arr(1 To %StkMax) As Single
End Type
Type SnStk
    tag As Long
    count As Long
    top As SnStkNode Ptr
End Type

Function SnStkNew() As Long
    'allocate new container - return handle
    Local p As SnStk Ptr
    p = MemAlloc(SizeOf(@p))
    ExitF(p=0, LibErrM)
    @p.tag = SnStkTag
    Function = p
End Function

Function SnStkFinal(ByVal p As SnStk Ptr) As Long
    'free allocated container - return null - Modifies Container Data
    If p Then
        ExitF(@p.tag<>SnStkTag, LibErrH)
        SnStkClear p
        MemFree(p)
    End If
End Function

Function SnStkValidate(ByVal p As SnStk Ptr) As Long
    'True/False if valid handle for this container
    If p And @p.tag = SnStkTag Then Function = @p.tag
End Function

Sub SnStkClear(ByVal p As SnStk Ptr)
    'delete all data - Modifies Container Data
    Local node As SnStkNode Ptr
    ExitS(p=0 Or @p.tag<>SnStkTag, LibErrH)
    While @p.top
        node = @p.top
        @p.top = @node.prev
        MemFree(node)
    Wend
    @p.top = 0
    @p.count = 0
End Sub

Function SnStkCount(ByVal p As SnStk Ptr) As Long
    'get item count
    ExitF(p=0 Or @p.tag<>SnStkTag, LibErrH)
    Function = @p.count
End Function

Sub SnStkPush(ByVal p As SnStk Ptr, ByVal value As Single)
    'push value on top of stack
    Local node As SnStkNode Ptr
    ExitS(p=0 Or @p.tag<>SnStkTag, LibErrH)
    If @p.count = 0 Then
        @p.top = MemAlloc(SizeOf(SnStkNode))
        ExitS(@p.top=0, LibErrM)
        @p.@top.arr(1) = value
        @p.@top.index = 1
        @p.count = 1
    ElseIf @p.@top.index < %StkMax Then
        Incr @p.@top.index
        @p.@top.arr(@p.@top.index) = value
        Incr @p.count
    Else
        node = MemAlloc(SizeOf(SnStkNode))
        ExitS(node=0, LibErrM)
        @node.arr(1) = value
        @node.index = 1
        @node.prev = @p.top
        @p.top = node
        Incr @p.count
    End If
End Sub

Function SnStkPeek(ByVal p As SnStk Ptr) As Single
    'get top value on stack
    ExitF(p=0 Or @p.tag<>SnStkTag, LibErrH)
    If @p.count Then Function = @p.@top.arr(@p.@top.index)
End Function

Function SnStkPop(ByVal p As SnStk Ptr) As Single
    'get and remove top value on stack
    Local node As SnStkNode Ptr
    ExitF(p=0 Or @p.tag<>SnStkTag, LibErrH)
    If @p.count Then
        Function = @p.@top.arr(@p.@top.index)
        Decr @p.@top.index
        Decr @p.count
        If @p.@top.index = 0 Then
            node = @p.top
            @p.top = @p.@top.prev
            MemFree(node)
        End If
    End If
End Function
