'convert Quad Container to other number types
#Dim All
#Compile Exe
#Link "SsLst.sll"

Function IsQd(ByVal s As String) As Long
    s = Right$(s, InStr(-1, s, "\") + 1)
    If InStr(s, "Qd") Then Function = 1
End Function

Function PBMain()
    Local s As String
    Local knd, k As String
    Local inFolder As String
    Local inFile As String
    Local outFile As String
    Local smpFile As String
    Local sampFolder As String

    Local inText As Long
    Local outText As Long
    Local kinds, kind As Long
    Local files, file As Long

    inText = SsLstNew()
    outText = SsLstNew()
    kinds = SsLstNew()
    files = SsLstNew()

    inFolder = "C:\HLib3\Hash\"
    inFile = "LnQdHsh.inc"
    sampFolder = inFolder + "Samples\"

    'SsLstAdd kinds, "Byte"
    'SsLstAdd kinds, "Integer"
    'SsLstAdd kinds, "Word"
    SsLstAdd kinds, "Long"
    SsLstAdd kinds, "Dword"
    'SsLstAdd kinds, "Single"
    SsLstAdd kinds, "Double"
    SsLstAdd kinds, "Currency"
    SsLstAdd kinds, "CurrencyX"
    SsLstAdd kinds, "Extended"

    SsLstTextLoad inText, inFolder + inFile

    'containers
    kind = SsLstFirst(kinds)
    While kind
        knd = SsLstGet(kind)
        Select Case knd
            Case "Byte" : k = "Bt"
            Case "Integer" : k = "In"
            Case "Word" : k = "Wd"
            Case "Long" : k = "Ln"
            Case "Dword" : k = "Dw"
            Case "Single" : k = "Sn"
            Case "Double" : k = "Db"
            Case "Currency" : k = "Cu"
            Case "CurrencyX" : k = "Cx"
            Case "Extended" : k = "Ex"
        End Select
        outFile = inFile
        Replace "Qd" With k In outFile
        s = SsLstTextGet(inText)
        Replace "Qd" With k In s
        Replace "Quad" With knd In s
        SsLstTextSet outText, s
        SsLstTextSave outText,  inFolder + outFile
        '
        kind = SsLstNext(kind)
    Wend

    'samples

    SsLstGetPaths files, sampFolder, "*.bas"
    file = SsLstFirst(files)
    While file
        If SsLstMatch(file, CodePtr(IsQd)) Then
            smpFile = SsLstGet(file)
            SsLstTextLoad inText, smpFile
            kind = SsLstFirst(kinds)
            While kind
                knd = SsLstGet(kind)
                Select Case knd
                    Case "Byte" : k = "Bt"
                    Case "Integer" : k = "In"
                    Case "Word" : k = "Wd"
                    Case "Long" : k = "Ln"
                    Case "Dword" : k = "Dw"
                    Case "Single" : k = "Sn"
                    Case "Double" : k = "Db"
                    Case "Currency" : k = "Cu"
                    Case "CurrencyX" : k = "Cx"
                    Case "Extended" : k = "Ex"
                End Select
                outFile = smpFile
                Replace "Qd" With k In outFile
                s = SsLstTextGet(inText)
                Replace "Qd" With k In s
                Replace "Quad" With knd In s
                SsLstTextSet outText, s
                SsLstTextSave outText,  outFile
                '
                kind = SsLstNext(kind)
            Wend
        End If
        file = SsLstNext(file)
    Wend

    inText = SsLstFinal(inText)
    outText = SsLstFinal(outText)
    kinds = SsLstFinal(kinds)
    files = SsLstFinal(files)

    ? "done..."
End Function
