#Include This Once
#Include Once "C:\HLib3\HLib.inc"
#Include Once "C:\HLib3\List\LnLst.inc"
#Include Once "C:\HLib3\List\DwLst.inc"
#Include Once "C:\HLib3\List\SsLst.inc"

'++
    '----------------------------------------------------------------------------------------
    'Long/Dword ~ Tree Container
    '   - also called: Tree/Map/Dictionary/Associative Array
    '   - AVL Self-Balanced Binary Tree
    '   - one-to-one relationship
    '   - Key/Value data structure
    '   - Values stored/retrieved/removed using unique lookup Key
    '   - Keys must be unique
    '   - Value replaced if Key exist unless DontReplace = True
    '   - Tree always stays in Key order
    '   - Tree may be traversed forward/backward in Key order
    '   - Tree is self-balanced to maintain shortest average path to each Key
    '
    '   - use MultiTree for one-to-many relationship
    '
    '   container accessed with handle
    '   handle protected by hash tag
    '   h = LnDwTreNew() 'get handle for new container
    '   h = LnDwTreFinal(h) 'free handle before it goes out of scope
    '----------------------------------------------------------------------------------------
'--


Macro LnDwTreNodeTag = 1320870834
Macro LnDwTreTag = 1317754472
Type LnDwTreNode
    tag As Long
    P As LnDwTreNode Ptr
    L As LnDwTreNode Ptr
    R As LnDwTreNode Ptr
    HL As Word
    HR As Word
    K As Long
    V As Dword
End Type
Type LnDwTre
    tag As Long
    count As Long
    root As LnDwTreNode Ptr
End Type

Function LnDwTreNew() As Long
    'allocate new container - return handle
    Local p As LnDwTre Ptr
    p = MemAlloc(SizeOf(@p))
    ExitF(p=0, LibErrM)
    @p.tag = LnDwTreTag
    Function = p
End Function

Function LnDwTreFinal(ByVal pTree As LnDwTre Ptr) As Long
    'free allocated container - return null
    If pTree Then
        ExitF(@pTree.tag<>LnDwTreTag, LibErrH)
        LnDwTreClear pTree
        MemFree(pTree)
    End If
End Function

Function LnDwTreValidate(ByVal pTree As LnDwTre Ptr) As Long
    'True/False if valid handle for this container
    If pTree And @pTree.tag = LnDwTreTag Then Function = @pTree.tag
End Function

Sub LnDwTreClear(ByVal pTree As LnDwTre Ptr)
    'delete all data
    Local i As Long
    Local pNode As LnDwTreNode Ptr
    Local nodes() As Long
    ExitS(pTree=0 Or @pTree.tag<>LnDwTreTag, LibErrH)
    If @pTree.count Then
        ReDim nodes(1 To @pTree.count)
        i = 0
        pNode = LnDwTreFirst(pTree)
        While pNode
            Incr i
            nodes(i) = pNode
            pNode = LnDwTreNext(pNode)
        Wend
        For i = 1 To @pTree.count
            LnDwTreFreeNode(pTree, nodes(i))
        Next i
    End If
    @pTree.count = 0
    @pTree.root = 0
End Sub

Function LnDwTreCount(ByVal pTree As LnDwTre Ptr) As Long
    'get item count
    If pTree Then Function = @pTree.count
End Function

Sub LnDwTreSet(ByVal pTree As LnDwTre Ptr, ByVal key As Long, ByVal value As Dword, Opt ByVal DontReplace As Long)
    'add Key/Value to tree - Value replaced if Key exist unless DontReplace = True
    Local n As LnDwTreNode Ptr
    Err = 0
    ExitS(pTree=0 Or @pTree.tag<>LnDwTreTag, LibErrH)
    If @pTree.root Then
        n = @pTree.root
        While 1
            If key > @n.K Then
                If @n.R Then
                    n = @n.R
                Else
                    @n.R = LnDwTreAllocNode(pTree) : If Err Then Exit Sub
                    @n.@R.P = n
                    @n.@R.K = key
                    @n.@R.V = value
                    LnDwTreBalanceBranch pTree, n
                    Exit Loop
                End If
            ElseIf key < @n.K Then
                If @n.L Then
                    n = @n.L
                Else
                    @n.L = LnDwTreAllocNode(pTree) : If Err Then Exit Sub
                    @n.@L.P = n
                    @n.@L.K = key
                    @n.@L.V = value
                    LnDwTreBalanceBranch pTree, n
                    Exit Loop
                End If
            Else
                If IsFalse DontReplace Then @n.V = value
                Exit Loop
            End If
        Wend
    Else
        @pTree.root = LnDwTreAllocNode(pTree) : If Err Then Exit Sub
        @pTree.@root.K = key
        @pTree.@root.V = value
        @pTree.count = 1
    End If
End Sub

Function LnDwTreGet(ByVal pTree As LnDwTre Ptr, ByVal key As Long) As Dword
    'get Key's associated Value
    Register k As Long : k = key
    Local n As LnDwTreNode Ptr
    ExitF(pTree=0 Or @pTree.tag<>LnDwTreTag, LibErrH)
    n = @pTree.root
    While n
        If k < @n.K Then
            n = @n.L
        ElseIf k > @n.K Then
            n = @n.R
        Else
            Function = @n.V
            Exit Loop
        End If
    Wend
End Function

Function LnDwTreGot(ByVal pTree As LnDwTre Ptr, ByVal key As Long) As Long
    'True/False if Key exist
    Register k As Long : k = key
    Local n As LnDwTreNode Ptr
    ExitF(pTree=0 Or @pTree.tag<>LnDwTreTag, LibErrH)
    n = @pTree.root
    While n
        If k < @n.K Then
            n = @n.L
        ElseIf k > @n.K Then
            n = @n.R
        Else
            Function = n
            Exit Loop
        End If
    Wend
End Function

Sub LnDwTreDel(ByVal pTree As LnDwTre Ptr, ByVal key As Long)
    'remove Key and associated Value
    Local pNode As LnDwTreNode Ptr
    ExitS(pTree=0 Or @pTree.tag<>LnDwTreTag, LibErrH)
    pNode = LnDwTreGot(pTree, key)
    If pNode Then
        LnDwTreRemoveNode(pTree, pNode)
    End If
End Sub

Function LnDwTreFirst(ByVal pTree As LnDwTre Ptr) As Long
    'get handle to first node in tree
    Local n As LnDwTreNode Ptr
    ExitF(pTree=0 Or @pTree.tag<>LnDwTreTag, LibErrH)
    n = @pTree.root
    If n Then
        While @n.L
            n = @n.L
        Wend
    End If
    Function = n
End Function

Function LnDwTreLast(ByVal pTree As LnDwTre Ptr) As Long
    'get handle to last node in tree
    Local n As LnDwTreNode Ptr
    ExitF(pTree=0 Or @pTree.tag<>LnDwTreTag, LibErrH)
    n = @pTree.root
    If n Then
        While @n.R
            n = @n.R
        Wend
    End If
    Function = n
End Function

Function LnDwTreNext(ByVal pNode As LnDwTreNode Ptr) As Long
    'get handle to next node in tree
    Local minR As LnDwTreNode Ptr
    If pNode Then
        ExitF(@pNode.tag<>LnDwTreNodeTag, LibErrH)
        minR = LnDwTreMinRight(pNode)
        If pNode <> minR Then
            Function = minR
        Else
            Function = LnDwTreParentGreater(pNode)
        End If
    End If
End Function

Function LnDwTrePrev(ByVal pNode As LnDwTreNode Ptr) As Long
    'get handle to previous node in tree
    Local maxL As LnDwTreNode Ptr
    If pNode Then
        ExitF(@pNode.tag<>LnDwTreNodeTag, LibErrH)
        maxL = LnDwTreMaxLeft(pNode)
        If pNode <> maxL Then
            Function = maxL
        Else
            Function = LnDwTreParentLesser(pNode)
        End If
    End If
End Function

Function LnDwTreGetKey(ByVal pNode As LnDwTreNode Ptr) As Long
    'get node's Key
    ExitF(pNode=0 Or @pNode.tag<>LnDwTreNodeTag, LibErrH)
    Function = @pNode.K
End Function

Function LnDwTreGetVal(ByVal pNode As LnDwTreNode Ptr) As Dword
    'get node's Value
    ExitF(pNode=0 Or @pNode.tag<>LnDwTreNodeTag, LibErrH)
    Function = @pNode.V
End Function

Sub LnDwTreSetVal(ByVal pNode As LnDwTreNode Ptr, ByVal value As Dword)
    'get node's Value
    ExitS(pNode=0 Or @pNode.tag<>LnDwTreNodeTag, LibErrH)
    @pNode.V = value
End Sub

'++
    '----------------------------------------------------------------------------------------
    '   Clone Container
    '----------------------------------------------------------------------------------------
'--

Function LnDwTreClone(ByVal pTree As LnDwTre Ptr) As Long
    'create duplicate container
    Local h, clone As Long
    Err = 0
    ExitF(pTree=0 Or @pTree.tag<>LnDwTreTag, LibErrH)
    clone = LnDwTreNew() : If Err Then Exit Function
    h = LnDwTreFirst(pTree)
    While h
        LnDwTreSet clone, LnDwTreGetKey(h), LnDwTreGetVal(h)
        h = LnDwTreNext(h)
    Wend
    Function = clone
End Function

'++
    '----------------------------------------------------------------------------------------
    '   Store/Restore Container To/From String
    '----------------------------------------------------------------------------------------
'--

Function LnDwTreStore(ByVal pTree As LnDwTre Ptr) As String
    'store container to string
    Local h, keys, vals, stor As Long
    Err = 0
    ExitF(pTree=0 Or @pTree.tag<>LnDwTreTag, LibErrH)
    keys = LnLstNew() : If Err Then Exit Function
    vals = DwLstNew() : If Err Then Exit Function
    stor = SsLstNew() : If Err Then Exit Function
    If @pTree.count Then
        h = LnDwTreFirst(pTree)
        While h
            LnLstAdd keys, LnDwTreGetKey(h)
            DwLstAdd vals, LnDwTreGetVal(h)
            h = LnDwTreNext(h)
        Wend
        SsLstAdd stor, LnLstStore(keys)
        SsLstAdd stor, DwLstStore(vals)
        Function = SsLstStore(stor)
    End If
    keys = LnLstFinal(keys)
    vals = DwLstFinal(vals)
    stor = SsLstFinal(stor)
End Function

Sub LnDwTreRestore(ByVal pTree As LnDwTre Ptr, ByVal s As String)
    'restore container from string
    Local keys, vals, stor As Long
    Err = 0
    ExitS(pTree=0 Or @pTree.tag<>LnDwTreTag, LibErrH)
    LnDwTreClear pTree
    keys = LnLstNew() : If Err Then Exit Sub
    vals = DwLstNew() : If Err Then Exit Sub
    stor = SsLstNew() : If Err Then Exit Sub
    If Len(s) Then
        SsLstRestore stor, s : If Err Then Exit Sub
        ExitS(SsLstCount(stor)<>2, LibErrU)
        LnLstRestore keys, SsLstPopFirst(stor)
        DwLstRestore vals, SsLstPopFirst(stor)
        ExitS(LnLstCount(keys)<>DwLstCount(vals), LibErrU)
        While LnLstCount(keys)
            LnDwTreSet pTree, LnLstPopFirst(keys), DwLstPopFirst(vals)
        Wend
    End If
    keys = LnLstFinal(keys)
    vals = DwLstFinal(vals)
    stor = SsLstFinal(stor)
End Sub


'++
    '----------------------------------------------------------------------------------------
    '   Store/Restore Container To/From File
    '----------------------------------------------------------------------------------------
'--

Sub LnDwTreFileStore(ByVal pTree As LnDwTre Ptr, ByVal file As String)
    'store container to file
    Local s As String
    Local f As Long
    Err = 0
    ExitS(pTree=0 Or @pTree.tag<>LnDwTreTag, LibErrH)
    s = LnDwTreStore(pTree) : If Err Then Exit Sub
    Try
        f = FreeFile
        Open file For Binary As f
        SetEof f
        Put$ f, s
        Close f
    Catch
        ExitLogErr(LibErrF)
    Finally
        If f Then Close f
    End Try
End Sub

Sub LnDwTreFileRestore(ByVal pTree As LnDwTre Ptr, ByVal file As String)
    'restore container from file - Modifies Container Data
    Local f As Long
    Local s As String
    Err = 0
    ExitS(pTree=0 Or @pTree.tag<>LnDwTreTag, LibErrH)
    Try
        f = FreeFile
        Open file For Binary As f
        Get$ f, Lof(f), s
        LnDwTreRestore pTree, s
    Catch
        ExitLogErr(LibErrF)
    Finally
        If f Then Close f
    End Try
End Sub

    '----------------------------------------------------------------------------------------
    '   PRIVATE
    '----------------------------------------------------------------------------------------

Sub LnDwTreRemoveNode(ByVal p As LnDwTre Ptr, ByVal n As LnDwTreNode Ptr) Private
    ExitS(n=0, LibErrP)
    Local nP, swapN As LnDwTreNode Ptr
    While @n.L Or @n.R
        swapN = IIf&(@n.HL >= @n.HR, LnDwTreMaxLeft(n), LnDwTreMinRight(n))
        If @p.root = n Then @p.root = swapN
        Swap @n.K, @swapN.K
        Swap @n.V, @swapN.V
        n = swapN
    Wend
    If n = @p.root Then
        LnDwTreClear p
    Else
        nP = @n.P
        ExitS(nP=0, LibErrP)
        If @nP.L = n Then @nP.L = 0 Else @nP.R = 0
        n = LnDwTreFreeNode(p, n)
        LnDwTreBalanceBranch p, nP
    End If
End Sub

Function LnDwTreAllocNode(ByVal p As LnDwTre Ptr) Private As Long
    Local n As LnDwTreNode Ptr
    n = MemAlloc(SizeOf(LnDwTreNode))
    ExitF(n=0, LIbErrM)
    @n.HL = 1
    @n.HR = 1
    @n.tag = LnDwTreNodeTag
    Incr @p.count
    Function = n
End Function

Function LnDwTreFreeNode(ByVal p As LnDwTre Ptr, ByVal n As LnDwTreNode Ptr) As Long
    If n Then
        MemFree(n)
        ExitF(@p.count=0, LibErrU)
        Decr @p.count
    End If
End Function

Sub LnDwTreBalanceBranch(ByVal p As LnDwTre Ptr, ByVal n As LnDwTreNode Ptr) Private
    While n
        @n.HL = IIf&(@n.L, Max&(@n.@L.HL, @n.@L.HR) + 1, 1)
        @n.HR = IIf&(@n.R, Max&(@n.@R.HL, @n.@R.HR) + 1, 1)
        If @n.HL > @n.HR + 1 Then
            n = LnDwTreRotateRight(p, n)
        ElseIf @n.HR > @n.HL + 1 Then
            n = LnDwTreRotateLeft(p, n)
        Else
            n = @n.P
        End If
    Wend
End Sub

Function LnDwTreMaxLeft(ByVal n As LnDwTreNode Ptr) Private As Long
    If n Then
        If @n.L Then
            n = @n.L
            While @n.R
                n = @n.R
            Wend
        End If
    End If
    Function = n
End Function

Function LnDwTreMinRight(ByVal n As LnDwTreNode Ptr) Private As Long
    If n Then
        If @n.R Then
            n = @n.R
            While @n.L
                n = @n.L
            Wend
        End If
    End If
    Function = n
End Function

Function LnDwTreParentGreater(ByVal n As LnDwTreNode Ptr) Private As Long
    If n Then
        While @n.P
            If @n.@P.L = n Then
                Function = @n.P
                Exit Function
            Else
                n = @n.P
            End If
        Wend
    End If
End Function

Function LnDwTreParentLesser(ByVal n As LnDwTreNode Ptr) Private As Long
    If n Then
        While @n.P
            If @n.@P.R = n Then
                Function = @n.P
                Exit Function
            Else
                n = @n.P
            End If
        Wend
    End If
End Function

Function LnDwTreRotateLeft(ByVal p As LnDwTre Ptr, ByVal n As LnDwTreNode Ptr) Private As Long
    Local nR, nRL As LnDwTreNode Ptr
    nR = @n.R
    If @nR.HL > @nR.HR Then
        nRL = @nR.L
        @n.R = nRL : @nRL.P = n
        @nR.L = @nRL.R : If @nR.L Then @nR.@L.P = nR
        @nRL.R = nR : @nR.P = nRL
        @nR.HL = IIf&(@nR.L, Max&(@nR.@L.HL, @nR.@L.HR) + 1, 1)
        @nR.HR = IIf&(@nR.R, Max&(@nR.@R.HL, @nR.@R.HR) + 1, 1)
        nR = @n.R
    End If
    If @p.root = n Then @p.root = @n.R
    @n.R = @nR.L : If @n.R Then @n.@R.P = n
    @nR.P = @n.P : @n.P = nR : @nR.L = n
    If @nR.P Then
        If @nR.@P.L = n Then @nR.@P.L = nR Else @nR.@P.R = nR
    End If
    Function = n
End Function

Function LnDwTreRotateRight(ByVal p As LnDwTre Ptr, ByVal n As LnDwTreNode Ptr) Private As Long
    Local nL, nLR As LnDwTreNode Ptr
    nL = @n.L
    If @nL.HR > @nL.HL Then
        nLR = @nL.R
        @n.L = nLR : @nLR.P = n
        @nL.R = @nLR.L : If @nL.R Then @nL.@R.P = nL
        @nLR.L = nL : @nL.P = nLR
        @nL.HL = IIf&(@nL.L, Max&(@nL.@L.HL, @nL.@L.HR) + 1, 1)
        @nL.HR = IIf&(@nL.R, Max&(@nL.@R.HL, @nL.@R.HR) + 1, 1)
        nL = @n.L
    End If
    If @p.root = n Then @p.root = @n.L
    @n.L = @nL.R : If @n.L Then @n.@L.P = n
    @nL.P = @n.P : @n.P = nL : @nL.R = n
    If @nL.P Then
        If @nL.@P.L = n Then @nL.@P.L = nL Else @nL.@P.R = nL
    End If
    Function = n
End Function
