'LnDbTre.bas
#Dim All
#Compile Exe
#Include Once "WIN32API.INC"
#Include Once "..\LnDbTre.inc"

Macro lbxID = 1000
Macro btnID = 1001

CallBack Function BtnCB()
    Local i, ok, Count As Long
    Local d As Double
    Local s As String
    Local r() As Long

    Local tree As Long
    Local clone As Long
    Local node As Long

    tree = LnDbTreNew() 'create new tree

    Count = 100000
    Randomize
    ListBox Reset CbHndl, lbxID
    ReDim r(1 To Count)
    For i = 1 To Count
        r(i) = Rnd(1, Count)
    Next i

    'add Key/Value

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "add "+Format$(Count, "#,")+" Key/Values to tree"
    d = Timer
    For i = 1 To Count
        LnDbTreSet tree, i, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(LnDbTreCount(tree), "#,")

    'test to see if Key exist

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "test to see if all  "+Format$(Count, "#,")+" Keys are in tree"
    d = Timer
    For i = 1 To Count
        If IsFalse LnDbTreGot(tree, i) Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'get Key's associated Value

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "get all "+Format$(Count, "#,")+" Values are in tree"
    d = Timer
    For i = 1 To Count
        If LnDbTreGet(tree, i) <> i Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'traverse forward

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "traverse tree forward - get and test all "+Format$(Count, "#,")+" Values"
    i = 0
    d = Timer
    node = LnDbTreFirst(tree)
    While node
        Incr i
        If LnDbTreGetVal(node) <> i Then
            ? "fail at: " + Format$(i) : Exit Loop
        End If
        node = LnDbTreNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "traverse tree backward - get and test all "+Format$(Count, "#,")+" Values"
    i = Count + 1
    d = Timer
    node = LnDbTreLast(tree)
    While node
        Decr i
        If LnDbTreGetVal(node) <> i Then
            ? "fail at: " + Format$(i) : Exit Loop
        End If
        node = LnDbTrePrev(node)
    Wend
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'replace Key's associated Value

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "replace all "+Format$(Count, "#,")+" Values in tree"
    d = Timer
    For i = 1 To Count
        LnDbTreSet tree, i, i + 10
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "test all "+Format$(Count, "#,")+" replaced Values in tree"
    d = Timer
    For i = 1 To Count
        If LnDbTreGet(tree, i) <> i + 10 Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'clone

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Clone tree"
    clone = LnDbTreClone(tree)
    ListBox Add CbHndl, lbxID, "test to see if all "+Format$(Count, "#,")+" Keys are in cloned tree"
    For i = 1 To Count
        If IsFalse LnDbTreGot(clone, i) Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i

    'remove Key/Value

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Count = " + Format$(LnDbTreCount(tree), "#,")
    ListBox Add CbHndl, lbxID, "remove every odd number Key from tree"
    d = Timer
    For i = 1 To Count
        If i Mod 2 Then LnDbTreDel tree, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(LnDbTreCount(tree), "#,")
    ListBox Add CbHndl, lbxID, "make sure odd Keys aren't in tree"
    For i = 1 To Count
        If i Mod 2 And LnDbTreGot(tree, i) Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i
    ListBox Add CbHndl, lbxID, "make sure even Keys are in tree"
    For i = 1 To Count
        If IsFalse i Mod 2 And IsFalse LnDbTreGot(tree, i) Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(LnDbTreCount(tree), "#,")

    'random Key/Value

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "add "+Format$(Count, "#,")+" random Key/Values to tree"
    LnDbTreClear tree
    d = Timer
    For i = 1 To Count
        LnDbTreSet tree, r(i), i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    ListBox Add CbHndl, lbxID, "make sure random keys in tree"
    d = Timer
    For i = 1 To Count
        If IsFalse LnDbTreGot(tree, r(i)) Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'Store/Restore To/From String/File

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clear tree"
    LnDbTreClear tree
    ListBox Add CbHndl, lbxID, "add 3 values"
    For i = 1 To 3
        LnDbTreSet tree, i, i * 100
    Next i

    ListBox Add CbHndl, lbxID, "-- Display Tree --"
    node = LnDbTreFirst(tree)
    While node
        ListBox Add CbHndl, lbxID, Format$(LnDbTreGetKey(node)) +" | "+ Format$(LnDbTreGetVal(node))
        node = LnDbTreNext(node)
    Wend

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store tree in a String"
    s = LnDbTreStore(tree)
    ListBox Add CbHndl, lbxID, "clear tree"
    LnDbTreClear tree
    ListBox Add CbHndl, lbxID, "restore tree from String"
    LnDbTreRestore tree, s
    ListBox Add CbHndl, lbxID, "-- Display Tree --"
    node = LnDbTreFirst(tree)
    While node
        ListBox Add CbHndl, lbxID, Format$(LnDbTreGetKey(node)) +" | "+ Format$(LnDbTreGetVal(node))
        node = LnDbTreNext(node)
    Wend

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store tree in a File"
    LnDbTreFileStore tree, "Test.Data"
    ListBox Add CbHndl, lbxID, "clear tree"
    LnDbTreClear tree
    ListBox Add CbHndl, lbxID, "restore tree from File"
    LnDbTreFileRestore tree, "Test.Data"
    ListBox Add CbHndl, lbxID, "-- Display Tree --"
    node = LnDbTreFirst(tree)
    While node
        ListBox Add CbHndl, lbxID, Format$(LnDbTreGetKey(node)) +" | "+ Format$(LnDbTreGetVal(node))
        node = LnDbTreNext(node)
    Wend

    If IsFile("Test.Data") Then Kill "Test.Data"

    'must free handles before they go out of scope
    tree = LnDbTreFinal(tree)
    clone = LnDbTreFinal(clone)

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "done..."
End Function

Function PBMain()
    Local hDlg As Long
    Dialog New 0, "LnDbTre.bas", 67, 61, 341, 241, %WS_Caption Or %WS_ClipSiblings Or %WS_MinimizeBox Or %WS_SysMenu, %WS_Ex_AppWindow To hDlg
    Control Add ListBox, hDlg, lbxID, , 5, 5, 330, 210, %WS_Child Or %WS_HScroll Or %WS_VScroll Or %LBS_Notify Or %LBS_NoIntegralHeight, %WS_Ex_ClientEdge
    Control Add Button,  hDlg, btnID, "Test", 275, 220, 60, 15 Call BtnCB()
    Dialog Show Modal hDlg, Call DlgCB
End Function

CallBack Function DlgCB()
End Function
