#Include This Once
#Include Once "C:\HLib3\HLib.inc"
#Include Once "C:\HLib3\List\SsLst.inc"
#Include Once "C:\HLib3\List\WsLst.inc"
#Include Once "C:\HLib3\List\CxLst.inc"

'++
    '----------------------------------------------------------------------------------------
    'WString/CurrencyX ~ Tree Container
    '   - also called: Tree/Map/Dictionary/Associative Array
    '   - AVL Self-Balanced Binary Tree
    '   - one-to-one relationship
    '   - Key/Value data structure
    '   - Values stored/retrieved/removed using unique lookup Key
    '   - Keys must be unique
    '   - no limit on Key length
    '   - use WsCxTreComparison() to change how Keys compared
    '   - Value replaced if Key exist unless DontReplace = True
    '   - Tree always stays in Key order
    '   - Tree may be traversed forward/backward in Key order
    '   - Tree is self-balanced to maintain shortest average path to each Key
    '
    '   - use MultiTree for one-to-many relationship
    '
    '   container accessed with handle
    '   handle protected by hash tag
    '   h = WsCxTreNew() 'get handle for new container
    '   h = WsCxTreFinal(h) 'free handle before it goes out of scope
    '----------------------------------------------------------------------------------------
'--


Macro WsCxTreNodeTag = -1272263200
Macro WsCxTreTag = -1501197570
Type WsCxTreNode
    tag As Long
    P As WsCxTreNode Ptr
    L As WsCxTreNode Ptr
    R As WsCxTreNode Ptr
    HL As Word
    HR As Word
    K As Long
    V As CurrencyX
End Type
Type WsCxTre
    tag As Long
    count As Long
    root As WsCxTreNode Ptr
    compareCB As Long
    collation As WsStr Ptr
End Type

Function WsCxTreNew() As Long
    'allocate new container - return handle
    Local p As WsCxTre Ptr
    Err = 0
    p = MemAlloc(SizeOf(@p))
    ExitF(p=0, LibErrM)
    @p.tag = WsCxTreTag
    @p.compareCB = CodePtr(WsCompare)
    @p.collation = WsNew() : If Err Then Exit Function
    Function = p
End Function

Function WsCxTreFinal(ByVal pTree As WsCxTre Ptr) As Long
    'free allocated container - return null
    If pTree Then
        ExitF(@pTree.tag<>WsCxTreTag, LibErrH)
        @pTree.collation = WsFinal(@pTree.collation)
        WsCxTreClear pTree
        MemFree(pTree)
    End If
End Function

Function WsCxTreValidate(ByVal pTree As WsCxTre Ptr) As Long
    'True/False if valid handle for this container
    If pTree And @pTree.tag = WsCxTreTag Then Function = @pTree.tag
End Function

Sub WsCxTreComparison(ByVal pTree As WsCxTre Ptr, ByVal compareUCase As Long, ByVal collationSequence As WString)
    'set how WStrings compared
    'default = case ignored
    'if collationSequence WString provided then
    '   WStrings are compared using the order of the collation sequence WString
    '   collation WString must be 65536 characters
    'else if compareUCase = True then
    '   WStrings compared UCase
    ExitS(pTree=0 Or @pTree.tag<>WsCxTreTag, LibErrH)
    @pTree.compareCB = CodePtr(WsCompare)
    WsClear @pTree.collation
    If Len(collationSequence) Then
        ExitS(Len(collationSequence)<>65536, LibErrS)
        WsSet @pTree.collation, collationSequence : If Err Then Exit Sub
        @pTree.compareCB = CodePtr(WsCompareCollate)
    ElseIf compareUCase Then
        @pTree.compareCB = CodePtr(WsCompareUCase)
    End If
End Sub

Sub WsCxTreClear(ByVal pTree As WsCxTre Ptr)
    'delete all data
    Local i As Long
    Local pNode As WsCxTreNode Ptr
    Local nodes() As Long
    ExitS(pTree=0 Or @pTree.tag<>WsCxTreTag, LibErrH)
    If @pTree.count Then
        ReDim nodes(1 To @pTree.count)
        i = 0
        pNode = WsCxTreFirst(pTree)
        While pNode
            Incr i
            nodes(i) = pNode
            pNode = WsCxTreNext(pNode)
        Wend
        For i = 1 To @pTree.count
            WsCxTreFreeNode(pTree, nodes(i))
        Next i
    End If
    @pTree.count = 0
    @pTree.root = 0
End Sub

Function WsCxTreCount(ByVal pTree As WsCxTre Ptr) As Long
    'get item count
    If pTree Then Function = @pTree.count
End Function

Sub WsCxTreSet(ByVal pTree As WsCxTre Ptr, ByRef key As WString, ByVal value As CurrencyX, Opt ByVal DontReplace As Long)
    'add Key/Value to tree - Value replaced if Key exist unless DontReplace = True
    Local compare, temp As Long
    Local n As WsCxTreNode Ptr
    Err = 0
    ExitS(pTree=0 Or @pTree.tag<>WsCxTreTag, LibErrH)
    temp = WsSetNew(key) : If Err Then Exit Sub
    If @pTree.root Then
        n = @pTree.root
        While 1
            Call Dword @pTree.compareCB Using WsCompareCB(temp, @n.K, @pTree.collation) To compare
            If compare > 0 Then
                If @n.R Then
                    n = @n.R
                Else
                    @n.R = WsCxTreAllocNode(pTree) : If Err Then Exit Sub
                    @n.@R.P = n
                    WsSet @n.@R.K, key
                    @n.@R.V = value
                    WsCxTreBalanceBranch pTree, n
                    Exit Loop
                End If
            ElseIf compare < 0 Then
                If @n.L Then
                    n = @n.L
                Else
                    @n.L = WsCxTreAllocNode(pTree) : If Err Then Exit Sub
                    @n.@L.P = n
                    WsSet @n.@L.K, key
                    @n.@L.V = value
                    WsCxTreBalanceBranch pTree, n
                    Exit Loop
                End If
            Else
                If IsFalse DontReplace Then @n.V = value
                Exit Loop
            End If
        Wend
    Else
        @pTree.root = WsCxTreAllocNode(pTree) : If Err Then Exit Sub
        WsSet @pTree.@root.K, key
        @pTree.@root.V = value
        @pTree.count = 1
    End If
    temp = WsFinal(temp)
End Sub

Function WsCxTreGet(ByVal pTree As WsCxTre Ptr, ByRef key As WString) As CurrencyX
    'get Key's associated Value
    Local compare, temp As Long
    Local n As WsCxTreNode Ptr
    Err = 0
    ExitF(pTree=0 Or @pTree.tag<>WsCxTreTag, LibErrH)
    temp = WsSetNew(key) : If Err Then Exit Function
    n = @pTree.root
    While n
        Call Dword @pTree.compareCB Using WsCompareCB(temp, @n.K, @pTree.collation) To compare
        If compare < 0 Then
            n = @n.L
        ElseIf compare > 0 Then
            n = @n.R
        Else
            Function = @n.V
            Exit Loop
        End If
    Wend
    temp = WsFinal(temp)
End Function

Function WsCxTreGot(ByVal pTree As WsCxTre Ptr, ByRef key As WString) As Long
    'True/False if Key exist
    Local compare, temp As Long
    Local n As WsCxTreNode Ptr
    Err = 0
    ExitF(pTree=0 Or @pTree.tag<>WsCxTreTag, LibErrH)
    temp = WsSetNew(key) : If Err Then Exit Function
    n = @pTree.root
    While n
        Call Dword @pTree.compareCB Using WsCompareCB(temp, @n.K, @pTree.collation) To compare
        If compare < 0 Then
            n = @n.L
        ElseIf compare > 0 Then
            n = @n.R
        Else
            Function = n
            Exit Loop
        End If
    Wend
    temp = WsFinal(temp)
End Function

Sub WsCxTreDel(ByVal pTree As WsCxTre Ptr, ByRef key As WString)
    'remove Key and associated Value
    Local pNode As WsCxTreNode Ptr
    ExitS(pTree=0 Or @pTree.tag<>WsCxTreTag, LibErrH)
    pNode = WsCxTreGot(pTree, key)
    If pNode Then
        WsCxTreRemoveNode(pTree, pNode)
    End If
End Sub

Function WsCxTreFirst(ByVal pTree As WsCxTre Ptr) As Long
    'get handle to first node in tree
    Local n As WsCxTreNode Ptr
    ExitF(pTree=0 Or @pTree.tag<>WsCxTreTag, LibErrH)
    n = @pTree.root
    If n Then
        While @n.L
            n = @n.L
        Wend
    End If
    Function = n
End Function

Function WsCxTreLast(ByVal pTree As WsCxTre Ptr) As Long
    'get handle to last node in tree
    Local n As WsCxTreNode Ptr
    ExitF(pTree=0 Or @pTree.tag<>WsCxTreTag, LibErrH)
    n = @pTree.root
    If n Then
        While @n.R
            n = @n.R
        Wend
    End If
    Function = n
End Function

Function WsCxTreNext(ByVal pNode As WsCxTreNode Ptr) As Long
    'get handle to next node in tree
    Local minR As WsCxTreNode Ptr
    If pNode Then
        ExitF(@pNode.tag<>WsCxTreNodeTag, LibErrH)
        minR = WsCxTreMinRight(pNode)
        If pNode <> minR Then
            Function = minR
        Else
            Function = WsCxTreParentGreater(pNode)
        End If
    End If
End Function

Function WsCxTrePrev(ByVal pNode As WsCxTreNode Ptr) As Long
    'get handle to previous node in tree
    Local maxL As WsCxTreNode Ptr
    If pNode Then
        ExitF(@pNode.tag<>WsCxTreNodeTag, LibErrH)
        maxL = WsCxTreMaxLeft(pNode)
        If pNode <> maxL Then
            Function = maxL
        Else
            Function = WsCxTreParentLesser(pNode)
        End If
    End If
End Function

Function WsCxTreGetKey(ByVal pNode As WsCxTreNode Ptr) As WString
    'get node's Key
    ExitF(pNode=0 Or @pNode.tag<>WsCxTreNodeTag, LibErrH)
    Function = WsGet(@pNode.K)
End Function

Function WsCxTreGetVal(ByVal pNode As WsCxTreNode Ptr) As CurrencyX
    'get node's Value
    ExitF(pNode=0 Or @pNode.tag<>WsCxTreNodeTag, LibErrH)
    Function = @pNode.V
End Function

Sub WsCxTreSetVal(ByVal pNode As WsCxTreNode Ptr, ByVal value As CurrencyX)
    'get node's Value
    ExitS(pNode=0 Or @pNode.tag<>WsCxTreNodeTag, LibErrH)
    @pNode.V = value
End Sub

'++
    '----------------------------------------------------------------------------------------
    '   Clone Container
    '----------------------------------------------------------------------------------------
'--

Function WsCxTreClone(ByVal pTree As WsCxTre Ptr) As Long
    'create duplicate container
    Local h, clone As Long
    Err = 0
    ExitF(pTree=0 Or @pTree.tag<>WsCxTreTag, LibErrH)
    clone = WsCxTreNew() : If Err Then Exit Function
    h = WsCxTreFirst(pTree)
    While h
        WsCxTreSet clone, WsCxTreGetKey(h), WsCxTreGetVal(h)
        h = WsCxTreNext(h)
    Wend
    Function = clone
End Function

'++
    '----------------------------------------------------------------------------------------
    '   Store/Restore Container To/From String
    '----------------------------------------------------------------------------------------
'--

Function WsCxTreStore(ByVal pTree As WsCxTre Ptr) As String
    'store container to string
    Local h, keys, vals, stor As Long
    Err = 0
    ExitF(pTree=0 Or @pTree.tag<>WsCxTreTag, LibErrH)
    keys = WsLstNew() : If Err Then Exit Function
    vals = CxLstNew() : If Err Then Exit Function
    stor = SsLstNew() : If Err Then Exit Function
    If @pTree.count Then
        h = WsCxTreFirst(pTree)
        While h
            WsLstAdd keys, WsCxTreGetKey(h)
            CxLstAdd vals, WsCxTreGetVal(h)
            h = WsCxTreNext(h)
        Wend
        SsLstAdd stor, WsLstStore(keys)
        SsLstAdd stor, CxLstStore(vals)
        Function = SsLstStore(stor)
    End If
    keys = WsLstFinal(keys)
    vals = CxLstFinal(vals)
    stor = SsLstFinal(stor)
End Function

Sub WsCxTreRestore(ByVal pTree As WsCxTre Ptr, ByVal s As String)
    'restore container from string
    Local keys, vals, stor As Long
    Err = 0
    ExitS(pTree=0 Or @pTree.tag<>WsCxTreTag, LibErrH)
    WsCxTreClear pTree
    keys = WsLstNew() : If Err Then Exit Sub
    vals = CxLstNew() : If Err Then Exit Sub
    stor = SsLstNew() : If Err Then Exit Sub
    If Len(s) Then
        SsLstRestore stor, s : If Err Then Exit Sub
        ExitS(SsLstCount(stor)<>2, LibErrU)
        WsLstRestore keys, SsLstPopFirst(stor)
        CxLstRestore vals, SsLstPopFirst(stor)
        ExitS(WsLstCount(keys)<>CxLstCount(vals), LibErrU)
        While WsLstCount(keys)
            WsCxTreSet pTree, WsLstPopFirst(keys), CxLstPopFirst(vals)
        Wend
    End If
    keys = WsLstFinal(keys)
    vals = CxLstFinal(vals)
    stor = SsLstFinal(stor)
End Sub


'++
    '----------------------------------------------------------------------------------------
    '   Store/Restore Container To/From File
    '----------------------------------------------------------------------------------------
'--

Sub WsCxTreFileStore(ByVal pTree As WsCxTre Ptr, ByVal file As String)
    'store container to file
    Local s As String
    Local f As Long
    Err = 0
    ExitS(pTree=0 Or @pTree.tag<>WsCxTreTag, LibErrH)
    s = WsCxTreStore(pTree) : If Err Then Exit Sub
    Try
        f = FreeFile
        Open file For Binary As f
        SetEof f
        Put$ f, s
        Close f
    Catch
        ExitLogErr(LibErrF)
    Finally
        If f Then Close f
    End Try
End Sub

Sub WsCxTreFileRestore(ByVal pTree As WsCxTre Ptr, ByVal file As String)
    'restore container from file - Modifies Container Data
    Local f As Long
    Local s As String
    Err = 0
    ExitS(pTree=0 Or @pTree.tag<>WsCxTreTag, LibErrH)
    Try
        f = FreeFile
        Open file For Binary As f
        Get$ f, Lof(f), s
        WsCxTreRestore pTree, s
    Catch
        ExitLogErr(LibErrF)
    Finally
        If f Then Close f
    End Try
End Sub

    '----------------------------------------------------------------------------------------
    '   PRIVATE
    '----------------------------------------------------------------------------------------

Sub WsCxTreRemoveNode(ByVal p As WsCxTre Ptr, ByVal n As WsCxTreNode Ptr) Private
    ExitS(n=0, LibErrP)
    Local nP, swapN As WsCxTreNode Ptr
    While @n.L Or @n.R
        swapN = IIf&(@n.HL >= @n.HR, WsCxTreMaxLeft(n), WsCxTreMinRight(n))
        If @p.root = n Then @p.root = swapN
        Swap @n.K, @swapN.K
        Swap @n.V, @swapN.V
        n = swapN
    Wend
    If n = @p.root Then
        WsCxTreClear p
    Else
        nP = @n.P
        ExitS(nP=0, LibErrP)
        If @nP.L = n Then @nP.L = 0 Else @nP.R = 0
        n = WsCxTreFreeNode(p, n)
        WsCxTreBalanceBranch p, nP
    End If
End Sub

Function WsCxTreAllocNode(ByVal p As WsCxTre Ptr) Private As Long
    Local n As WsCxTreNode Ptr
    n = MemAlloc(SizeOf(WsCxTreNode))
    ExitF(n=0, LIbErrM)
    @n.HL = 1
    @n.HR = 1
    @n.tag = WsCxTreNodeTag
    @n.K = WsNew() : If Err Then Exit Function
    Incr @p.count
    Function = n
End Function

Function WsCxTreFreeNode(ByVal p As WsCxTre Ptr, ByVal n As WsCxTreNode Ptr) As Long
    If n Then
        @n.K = WsFinal(@n.K)
        MemFree(n)
        ExitF(@p.count=0, LibErrU)
        Decr @p.count
    End If
End Function

Sub WsCxTreBalanceBranch(ByVal p As WsCxTre Ptr, ByVal n As WsCxTreNode Ptr) Private
    While n
        @n.HL = IIf&(@n.L, Max&(@n.@L.HL, @n.@L.HR) + 1, 1)
        @n.HR = IIf&(@n.R, Max&(@n.@R.HL, @n.@R.HR) + 1, 1)
        If @n.HL > @n.HR + 1 Then
            n = WsCxTreRotateRight(p, n)
        ElseIf @n.HR > @n.HL + 1 Then
            n = WsCxTreRotateLeft(p, n)
        Else
            n = @n.P
        End If
    Wend
End Sub

Function WsCxTreMaxLeft(ByVal n As WsCxTreNode Ptr) Private As Long
    If n Then
        If @n.L Then
            n = @n.L
            While @n.R
                n = @n.R
            Wend
        End If
    End If
    Function = n
End Function

Function WsCxTreMinRight(ByVal n As WsCxTreNode Ptr) Private As Long
    If n Then
        If @n.R Then
            n = @n.R
            While @n.L
                n = @n.L
            Wend
        End If
    End If
    Function = n
End Function

Function WsCxTreParentGreater(ByVal n As WsCxTreNode Ptr) Private As Long
    If n Then
        While @n.P
            If @n.@P.L = n Then
                Function = @n.P
                Exit Function
            Else
                n = @n.P
            End If
        Wend
    End If
End Function

Function WsCxTreParentLesser(ByVal n As WsCxTreNode Ptr) Private As Long
    If n Then
        While @n.P
            If @n.@P.R = n Then
                Function = @n.P
                Exit Function
            Else
                n = @n.P
            End If
        Wend
    End If
End Function

Function WsCxTreRotateLeft(ByVal p As WsCxTre Ptr, ByVal n As WsCxTreNode Ptr) Private As Long
    Local nR, nRL As WsCxTreNode Ptr
    nR = @n.R
    If @nR.HL > @nR.HR Then
        nRL = @nR.L
        @n.R = nRL : @nRL.P = n
        @nR.L = @nRL.R : If @nR.L Then @nR.@L.P = nR
        @nRL.R = nR : @nR.P = nRL
        @nR.HL = IIf&(@nR.L, Max&(@nR.@L.HL, @nR.@L.HR) + 1, 1)
        @nR.HR = IIf&(@nR.R, Max&(@nR.@R.HL, @nR.@R.HR) + 1, 1)
        nR = @n.R
    End If
    If @p.root = n Then @p.root = @n.R
    @n.R = @nR.L : If @n.R Then @n.@R.P = n
    @nR.P = @n.P : @n.P = nR : @nR.L = n
    If @nR.P Then
        If @nR.@P.L = n Then @nR.@P.L = nR Else @nR.@P.R = nR
    End If
    Function = n
End Function

Function WsCxTreRotateRight(ByVal p As WsCxTre Ptr, ByVal n As WsCxTreNode Ptr) Private As Long
    Local nL, nLR As WsCxTreNode Ptr
    nL = @n.L
    If @nL.HR > @nL.HL Then
        nLR = @nL.R
        @n.L = nLR : @nLR.P = n
        @nL.R = @nLR.L : If @nL.R Then @nL.@R.P = nL
        @nLR.L = nL : @nL.P = nLR
        @nL.HL = IIf&(@nL.L, Max&(@nL.@L.HL, @nL.@L.HR) + 1, 1)
        @nL.HR = IIf&(@nL.R, Max&(@nL.@R.HL, @nL.@R.HR) + 1, 1)
        nL = @n.L
    End If
    If @p.root = n Then @p.root = @n.L
    @n.L = @nL.R : If @n.L Then @n.@L.P = n
    @nL.P = @n.P : @n.P = nL : @nL.R = n
    If @nL.P Then
        If @nL.@P.L = n Then @nL.@P.L = nL Else @nL.@P.R = nL
    End If
    Function = n
End Function
