#Include This Once
#Include Once "C:\HLib2\Array\LnArr.inc"
#Include Once "C:\HLib2\Array\QdArr.inc"

Macro QdDpxTag = 1868553327
Type QdDpx
    tag As Long
    count As Long
    root As LnArr Ptr
End Type
Type QdDpxNode
    x As Long
    arr As QdArr Ptr
End Type
Macro QdDpxNodeMax = 2000

Function QdDpxNew() As Long
    'allocate new container - return handle
    Local p As QdDpx Ptr
    Err = 0
    p = MemAlloc(SizeOf(@p))
    ExitF(p=0, LibErrM)
    @p.tag = QdDpxTag
    @p.root = LnArrNew() : If Err Then Exit Function
    Function = p
End Function

Function QdDpxFinal(ByVal p As QdDpx Ptr) As Long
    'free allocated container - return null
    If p Then
        ExitF(@p.tag<>QdDpxTag, LibErrH)
        QdDpxClear p
        MemFree(p)
    End If
End Function

Function QdDpxValidate(ByVal p As QdDpx Ptr) ThreadSafe As Long
    'True/False if valid handle for this container
    If p And @p.tag = QdDpxTag Then Function = @p.tag
End Function

Sub QdDpxClear(ByVal p As QdDpx Ptr) ThreadSafe
    'delete all data
    Local i As Long
    ExitS(p=0 Or @p.tag<>QdDpxTag, LibErrH)
    For i = 1 To @p.@root.count
        @p.@root.@arr[i] = QdDpxNodeFree(@p.@root.@arr[i])
    Next i
    LnArrClear @p.root
    @p.count = 0
End Sub

Function QdDpxCount(ByVal p As QdDpx Ptr) ThreadSafe As Long
    'get item count (number of characters)
    ExitF(p=0 Or @p.tag<>QdDpxTag, LibErrH)
    Function = @p.count
End Function

Sub QdDpxAdd(ByVal p As QdDpx Ptr, ByVal value As Quad)
    'append value to end of container
    Local node, node2 As QdDpxNode Ptr
    Err = 0
    ExitS(p=0 Or @p.tag<>QdDpxTag, LibErrH)
    If @p.count = 0 Then
        node = QdDpxNodeAlloc() : If Err Then Exit Sub
        @node.x = 1
        QdArrAdd @node.arr, value
        LnArrAdd @p.root, node
        @p.count = 1
    Else
        node = @p.@root.@arr[@p.@root.count]
        If @node.@arr.count < QdDpxNodeMax Then
            QdArrAdd @node.arr, value
            Incr @p.count
        Else
            node2 = QdDpxNodeAlloc() : If Err Then Exit Sub
            @node2.x = @node.x + @node.@arr.count - 1
            QdArrAdd @node2.arr, value
            LnArrAdd @p.root, node2
            Incr @p.count
        End If
    End If
End Sub

Sub QdDpxIns(ByVal p As QdDpx Ptr, ByVal value As Quad)
    'insert value at front of container
    Local node, node2 As QdDpxNode Ptr
    Err = 0
    ExitS(p=0 Or @p.tag<>QdDpxTag, LibErrH)
    If @p.count = 0 Then
        node = QdDpxNodeAlloc() : If Err Then Exit Sub
        @node.x = 1
        QdArrAdd @node.arr, value
        LnArrAdd @p.root, node
        @p.count = 1
    Else
        node = @p.@root.@arr[1]
        If @node.@arr.count < QdDpxNodeMax Then
            QdArrIns @node.arr, 1, value
            Incr @p.count
        Else
            node2 = QdDpxNodeAlloc() : If Err Then Exit Sub
            ''''''''''@node2.x = @node.x + @node.@arr.count - 1
            QdArrAdd @node2.arr, value
            LnArrIns @p.root, 1, node2
            Incr @p.count
        End If
    End If
End Sub

Function QdDpxNodeAlloc() Private As Long
    Local node As QdDpxNode Ptr
    Err = 0
    node = MemAlloc(SizeOf(QdDpxNode))
    ExitF(node=0, LibErrM)
    @node.arr = QdArrNew() : If Err Then Exit Function
    Function = node
End Function

Function QdDpxNodeFree(ByVal node As QdDpxNode Ptr) Private As Long
    If node Then
        @node.arr = QdArrFinal(@node.arr)
        MemFree(node)
    End If
End Function
