'CxArr.bas
#Dim All
#Compile Exe
#Include Once "WIN32API.INC"
#Include Once "..\CxArr.inc"

Macro lbxID = 1000
Macro btnID = 1001

CallBack Function BtnCB()
    Local i, Count As Long
    Local d As Double
    Local s As String

    Local arr As Long
    Local clone As Long

    arr = CxArrNew() 'allocate new container

    Randomize
    ListBox Reset CbHndl, lbxID
    Count = 100000

    ListBox Add CbHndl, lbxID, "append 10,000 values to empty array - ReDim automatic"
    d = Timer
    For i = 1 To 10000
        CxArrAdd arr, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(CxArrCount(arr), "#,")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "insert 10,000 values into empty array at index #1 - ReDim automatic"
    CxArrClear arr
    CxArrAdd arr, 0
    d = Timer
    For i = 1 To 10000
        CxArrIns arr, 1, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(CxArrCount(arr), "#,")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "ReDim array to " + Format$(Count, "#,")
    CxArrReDim arr, Count

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "set all "+Format$(Count, "#,")+" values in array"
    d = Timer
    For i = 1 To Count
        CxArrSet arr, i, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "get and test all "+Format$(Count, "#,")+" values in array"
    d = Timer
    For i = 1 To Count
        If CxArrGet(arr, i) <> i Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'reverse array

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "reverse array"
    d = Timer
    CxArrReverse arr
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.00000")
    ListBox Add CbHndl, lbxID, "-- first 2 values ---"
    ListBox Add CbHndl, lbxID, Str$(CxArrGet(arr, 1))
    ListBox Add CbHndl, lbxID, Str$(CxArrGet(arr, 2))
    ListBox Add CbHndl, lbxID, "-- last 2 values ---"
    ListBox Add CbHndl, lbxID, Str$(CxArrGet(arr, CxArrCount(arr) - 1))
    ListBox Add CbHndl, lbxID, Str$(CxArrGet(arr, CxArrCount(arr)))

    'sort array

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "sort array"
    d = Timer
    CxArrSort arr
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.00000")
    ListBox Add CbHndl, lbxID, "-- first 2 values ---"
    ListBox Add CbHndl, lbxID, Str$(CxArrGet(arr, 1))
    ListBox Add CbHndl, lbxID, Str$(CxArrGet(arr, 2))
    ListBox Add CbHndl, lbxID, "-- last 2 values ---"
    ListBox Add CbHndl, lbxID, Str$(CxArrGet(arr, CxArrCount(arr) - 1))
    ListBox Add CbHndl, lbxID, Str$(CxArrGet(arr, CxArrCount(arr)))

    'test sort
    For i = 1 To CxArrCount(arr) - 1
        If CxArrGet(arr, i) > CxArrGet(arr, i + 1) Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i

    'binary search

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "binary search for all "+Format$(CxArrCount(arr), "#,")+" values in array"
    d = Timer
    For i = 1 To Count
        If CxArrBinSearch(arr, i) <> i Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.00000")

    'binary insert - insert value in sort order

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clear array"
    CxArrClear arr
    ListBox Add CbHndl, lbxID, "binary insert 10 random values: Rnd(1, 5)"
    For i = 1 To 10
        CxArrBinInsert arr, Rnd(1, 5)
    Next i
    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To CxArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(CxArrGet(arr, i))
    Next i

    'unique - delete all duplicates

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "unique array"
    CxArrUniqueSort arr
    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To CxArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(CxArrGet(arr, i))
    Next i

    'remove

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "remove all odd numbers"
    For i = CxArrCount(arr) To 1 Step -1
        If CxArrGet(arr, i) Mod 2 Then CxArrDel arr, i
    Next i
    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To CxArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(CxArrGet(arr, i))
    Next i

    'Stack

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Stack"
    ListBox Add CbHndl, lbxID, "Push 1, 2, 3 on Stack"
    CxArrClear arr
    CxArrStkPush arr, 1
    CxArrStkPush arr, 2
    CxArrStkPush arr, 3
    ListBox Add CbHndl, lbxID, "Peek and Pop Stack"
    While CxArrCount(arr)
        ListBox Add CbHndl, lbxID, "Peek() = " + Format$(CxArrStkPeek(arr))
        ListBox Add CbHndl, lbxID, "Pop() = " + Format$(CxArrStkPop(arr))
    Wend

    'Queue

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Queue"
    ListBox Add CbHndl, lbxID, "Add 1, 2, 3 to Queue"
    CxArrClear arr
    CxArrQuePush arr, 1
    CxArrQuePush arr, 2
    CxArrQuePush arr, 3
    ListBox Add CbHndl, lbxID, "Peek and Pop Queue"
    While CxArrCount(arr)
        ListBox Add CbHndl, lbxID, "Peek = " + Format$(CxArrQuePeek(arr))
        ListBox Add CbHndl, lbxID, "Pop = " + Format$(CxArrQuePop(arr))
    Wend

    'Deque - double-ended Queue

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Deque - double-ended Queue"
    ListBox Add CbHndl, lbxID, "Add 1, 2, 3 to Front of Deque"
    CxArrClear arr
    CxArrPushFirst arr, 1
    CxArrPushFirst arr, 2
    CxArrPushFirst arr, 3
    ListBox Add CbHndl, lbxID, "Add 4, 5, 6 to End of Deque"
    CxArrPushLast arr, 4
    CxArrPushLast arr, 5
    CxArrPushLast arr, 6
    ListBox Add CbHndl, lbxID, "Peek and Pop Deque"
    While CxArrCount(arr)
        ListBox Add CbHndl, lbxID, "PeekFirst = " + Format$(CxArrPeekFirst(arr))
        ListBox Add CbHndl, lbxID, "PopFirst = " + Format$(CxArrPopFirst(arr))
        ListBox Add CbHndl, lbxID, "PeekLast = " + Format$(CxArrPeekLast(arr))
        ListBox Add CbHndl, lbxID, "PopLast = " + Format$(CxArrPopLast(arr))
    Wend

    'Clone

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Clone"
    ListBox Add CbHndl, lbxID, "add 1, 2, 3 to array"
    CxArrClear arr
    For i = 1 To 3
        CxArrAdd arr, i
    Next i
    ListBox Add CbHndl, lbxID, "clone array"
    clone = CxArrClone(arr)
    ListBox Add CbHndl, lbxID, "display Clone"
    For i = 1 To CxArrCount(clone)
        ListBox Add CbHndl, lbxID, Format$(CxArrGet(clone, i))
    Next i

    'Store/Restore: store/restore container to/from string

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store array to String"
    s = CxArrStore(arr)

    ListBox Add CbHndl, lbxID, "clear array"
    CxArrClear arr

    ListBox Add CbHndl, lbxID, "restore array from String"
    CxArrRestore arr, s

    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To CxArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(CxArrGet(arr, i))
    Next i

    'FileStore/FileRestore: store/restore container to/from file

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store array to File"
    CxArrFileStore arr, "test.data"

    ListBox Add CbHndl, lbxID, "clear array"
    CxArrClear arr

    ListBox Add CbHndl, lbxID, "restore array from File"
    CxArrFileRestore arr, "test.data"

    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To CxArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(CxArrGet(arr, i))
    Next i

    If IsFile("test.data") Then Kill "test.data"

    'must free handles before they go out of scope
    arr = CxArrFinal(arr)
    clone = CxArrFinal(clone)

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "done..."
End Function

Function PBMain()
    Local hDlg As Long
    Dialog New 0, "CxArr.bas", 67, 61, 341, 241, %WS_Caption Or %WS_ClipSiblings Or %WS_MinimizeBox Or %WS_SysMenu, %WS_Ex_AppWindow To hDlg
    Control Add ListBox, hDlg, lbxID, , 5, 5, 330, 210, %WS_Child Or %WS_HScroll Or %WS_VScroll Or %LBS_Notify Or %LBS_NoIntegralHeight, %WS_Ex_ClientEdge
    Control Add Button,  hDlg, btnID, "Test", 275, 220, 60, 15 Call BtnCB()
    Dialog Show Modal hDlg, Call DlgCB
End Function

CallBack Function DlgCB()
End Function
