'ExArr.bas
#Dim All
#Compile Exe
#Include Once "WIN32API.INC"
#Include Once "..\ExArr.inc"

Macro lbxID = 1000
Macro btnID = 1001

CallBack Function BtnCB()
    Local i, Count As Long
    Local d As Double
    Local s As String

    Local arr As Long
    Local clone As Long

    arr = ExArrNew() 'allocate new container

    Randomize
    ListBox Reset CbHndl, lbxID
    Count = 100000

    ListBox Add CbHndl, lbxID, "append 10,000 values to empty array - ReDim automatic"
    d = Timer
    For i = 1 To 10000
        ExArrAdd arr, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(ExArrCount(arr), "#,")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "insert 10,000 values into empty array at index #1 - ReDim automatic"
    ExArrClear arr
    ExArrAdd arr, 0
    d = Timer
    For i = 1 To 10000
        ExArrIns arr, 1, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(ExArrCount(arr), "#,")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "ReDim array to " + Format$(Count, "#,")
    ExArrReDim arr, Count

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "set all "+Format$(Count, "#,")+" values in array"
    d = Timer
    For i = 1 To Count
        ExArrSet arr, i, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "get and test all "+Format$(Count, "#,")+" values in array"
    d = Timer
    For i = 1 To Count
        If ExArrGet(arr, i) <> i Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'reverse array

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "reverse array"
    d = Timer
    ExArrReverse arr
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.00000")
    ListBox Add CbHndl, lbxID, "-- first 2 values ---"
    ListBox Add CbHndl, lbxID, Str$(ExArrGet(arr, 1))
    ListBox Add CbHndl, lbxID, Str$(ExArrGet(arr, 2))
    ListBox Add CbHndl, lbxID, "-- last 2 values ---"
    ListBox Add CbHndl, lbxID, Str$(ExArrGet(arr, ExArrCount(arr) - 1))
    ListBox Add CbHndl, lbxID, Str$(ExArrGet(arr, ExArrCount(arr)))

    'sort array

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "sort array"
    d = Timer
    ExArrSort arr
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.00000")
    ListBox Add CbHndl, lbxID, "-- first 2 values ---"
    ListBox Add CbHndl, lbxID, Str$(ExArrGet(arr, 1))
    ListBox Add CbHndl, lbxID, Str$(ExArrGet(arr, 2))
    ListBox Add CbHndl, lbxID, "-- last 2 values ---"
    ListBox Add CbHndl, lbxID, Str$(ExArrGet(arr, ExArrCount(arr) - 1))
    ListBox Add CbHndl, lbxID, Str$(ExArrGet(arr, ExArrCount(arr)))

    'test sort
    For i = 1 To ExArrCount(arr) - 1
        If ExArrGet(arr, i) > ExArrGet(arr, i + 1) Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i

    'binary search

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "binary search for all "+Format$(ExArrCount(arr), "#,")+" values in array"
    d = Timer
    For i = 1 To Count
        If ExArrBinSearch(arr, i) <> i Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.00000")

    'binary insert - insert value in sort order

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clear array"
    ExArrClear arr
    ListBox Add CbHndl, lbxID, "binary insert 10 random values: Rnd(1, 5)"
    For i = 1 To 10
        ExArrBinInsert arr, Rnd(1, 5)
    Next i
    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To ExArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(ExArrGet(arr, i))
    Next i

    'unique - delete all duplicates

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "unique array"
    ExArrUniqueSort arr
    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To ExArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(ExArrGet(arr, i))
    Next i

    'remove

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "remove all odd numbers"
    For i = ExArrCount(arr) To 1 Step -1
        If ExArrGet(arr, i) Mod 2 Then ExArrDel arr, i
    Next i
    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To ExArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(ExArrGet(arr, i))
    Next i

    'Stack

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Stack"
    ListBox Add CbHndl, lbxID, "Push 1, 2, 3 on Stack"
    ExArrClear arr
    ExArrStkPush arr, 1
    ExArrStkPush arr, 2
    ExArrStkPush arr, 3
    ListBox Add CbHndl, lbxID, "Peek and Pop Stack"
    While ExArrCount(arr)
        ListBox Add CbHndl, lbxID, "Peek() = " + Format$(ExArrStkPeek(arr))
        ListBox Add CbHndl, lbxID, "Pop() = " + Format$(ExArrStkPop(arr))
    Wend

    'Queue

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Queue"
    ListBox Add CbHndl, lbxID, "Add 1, 2, 3 to Queue"
    ExArrClear arr
    ExArrQuePush arr, 1
    ExArrQuePush arr, 2
    ExArrQuePush arr, 3
    ListBox Add CbHndl, lbxID, "Peek and Pop Queue"
    While ExArrCount(arr)
        ListBox Add CbHndl, lbxID, "Peek = " + Format$(ExArrQuePeek(arr))
        ListBox Add CbHndl, lbxID, "Pop = " + Format$(ExArrQuePop(arr))
    Wend

    'Deque - double-ended Queue

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Deque - double-ended Queue"
    ListBox Add CbHndl, lbxID, "Add 1, 2, 3 to Front of Deque"
    ExArrClear arr
    ExArrPushFirst arr, 1
    ExArrPushFirst arr, 2
    ExArrPushFirst arr, 3
    ListBox Add CbHndl, lbxID, "Add 4, 5, 6 to End of Deque"
    ExArrPushLast arr, 4
    ExArrPushLast arr, 5
    ExArrPushLast arr, 6
    ListBox Add CbHndl, lbxID, "Peek and Pop Deque"
    While ExArrCount(arr)
        ListBox Add CbHndl, lbxID, "PeekFirst = " + Format$(ExArrPeekFirst(arr))
        ListBox Add CbHndl, lbxID, "PopFirst = " + Format$(ExArrPopFirst(arr))
        ListBox Add CbHndl, lbxID, "PeekLast = " + Format$(ExArrPeekLast(arr))
        ListBox Add CbHndl, lbxID, "PopLast = " + Format$(ExArrPopLast(arr))
    Wend

    'Clone

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Clone"
    ListBox Add CbHndl, lbxID, "add 1, 2, 3 to array"
    ExArrClear arr
    For i = 1 To 3
        ExArrAdd arr, i
    Next i
    ListBox Add CbHndl, lbxID, "clone array"
    clone = ExArrClone(arr)
    ListBox Add CbHndl, lbxID, "display Clone"
    For i = 1 To ExArrCount(clone)
        ListBox Add CbHndl, lbxID, Format$(ExArrGet(clone, i))
    Next i

    'Store/Restore: store/restore container to/from string

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store array to String"
    s = ExArrStore(arr)

    ListBox Add CbHndl, lbxID, "clear array"
    ExArrClear arr

    ListBox Add CbHndl, lbxID, "restore array from String"
    ExArrRestore arr, s

    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To ExArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(ExArrGet(arr, i))
    Next i

    'FileStore/FileRestore: store/restore container to/from file

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store array to File"
    ExArrFileStore arr, "test.data"

    ListBox Add CbHndl, lbxID, "clear array"
    ExArrClear arr

    ListBox Add CbHndl, lbxID, "restore array from File"
    ExArrFileRestore arr, "test.data"

    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To ExArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(ExArrGet(arr, i))
    Next i

    If IsFile("test.data") Then Kill "test.data"

    'must free handles before they go out of scope
    arr = ExArrFinal(arr)
    clone = ExArrFinal(clone)

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "done..."
End Function

Function PBMain()
    Local hDlg As Long
    Dialog New 0, "ExArr.bas", 67, 61, 341, 241, %WS_Caption Or %WS_ClipSiblings Or %WS_MinimizeBox Or %WS_SysMenu, %WS_Ex_AppWindow To hDlg
    Control Add ListBox, hDlg, lbxID, , 5, 5, 330, 210, %WS_Child Or %WS_HScroll Or %WS_VScroll Or %LBS_Notify Or %LBS_NoIntegralHeight, %WS_Ex_ClientEdge
    Control Add Button,  hDlg, btnID, "Test", 275, 220, 60, 15 Call BtnCB()
    Dialog Show Modal hDlg, Call DlgCB
End Function

CallBack Function DlgCB()
End Function
