'InArr.bas
#Dim All
#Compile Exe
#Include Once "WIN32API.INC"
#Include Once "..\InArr.inc"

Macro lbxID = 1000
Macro btnID = 1001

CallBack Function BtnCB()
    Local i, Count As Long
    Local d As Double
    Local s As String

    Local arr As Long
    Local clone As Long

    arr = InArrNew() 'allocate new container

    Randomize
    ListBox Reset CbHndl, lbxID
    Count = 100000

    ListBox Add CbHndl, lbxID, "append 10,000 values to empty array - ReDim automatic"
    d = Timer
    For i = 1 To 10000
        InArrAdd arr, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(InArrCount(arr), "#,")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "insert 10,000 values into empty array at index #1 - ReDim automatic"
    InArrClear arr
    InArrAdd arr, 0
    d = Timer
    For i = 1 To 10000
        InArrIns arr, 1, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(InArrCount(arr), "#,")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "ReDim array to " + Format$(Count, "#,")
    InArrReDim arr, Count

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "set all "+Format$(Count, "#,")+" values in array"
    d = Timer
    For i = 1 To Count
        InArrSet arr, i, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "get and test all "+Format$(Count, "#,")+" values in array"
    d = Timer
    For i = 1 To Count
        If InArrGet(arr, i) <> i Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'reverse array

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "reverse array"
    d = Timer
    InArrReverse arr
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.00000")
    ListBox Add CbHndl, lbxID, "-- first 2 values ---"
    ListBox Add CbHndl, lbxID, Str$(InArrGet(arr, 1))
    ListBox Add CbHndl, lbxID, Str$(InArrGet(arr, 2))
    ListBox Add CbHndl, lbxID, "-- last 2 values ---"
    ListBox Add CbHndl, lbxID, Str$(InArrGet(arr, InArrCount(arr) - 1))
    ListBox Add CbHndl, lbxID, Str$(InArrGet(arr, InArrCount(arr)))

    'sort array

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "sort array"
    d = Timer
    InArrSort arr
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.00000")
    ListBox Add CbHndl, lbxID, "-- first 2 values ---"
    ListBox Add CbHndl, lbxID, Str$(InArrGet(arr, 1))
    ListBox Add CbHndl, lbxID, Str$(InArrGet(arr, 2))
    ListBox Add CbHndl, lbxID, "-- last 2 values ---"
    ListBox Add CbHndl, lbxID, Str$(InArrGet(arr, InArrCount(arr) - 1))
    ListBox Add CbHndl, lbxID, Str$(InArrGet(arr, InArrCount(arr)))

    'test sort
    For i = 1 To InArrCount(arr) - 1
        If InArrGet(arr, i) > InArrGet(arr, i + 1) Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i

    'binary search

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "binary search for all "+Format$(InArrCount(arr), "#,")+" values in array"
    d = Timer
    For i = 1 To Count
        If InArrBinSearch(arr, i) <> i Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.00000")

    'binary insert - insert value in sort order

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clear array"
    InArrClear arr
    ListBox Add CbHndl, lbxID, "binary insert 10 random values: Rnd(1, 5)"
    For i = 1 To 10
        InArrBinInsert arr, Rnd(1, 5)
    Next i
    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To InArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(InArrGet(arr, i))
    Next i

    'unique - delete all duplicates

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "unique array"
    InArrUniqueSort arr
    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To InArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(InArrGet(arr, i))
    Next i

    'remove

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "remove all odd numbers"
    For i = InArrCount(arr) To 1 Step -1
        If InArrGet(arr, i) Mod 2 Then InArrDel arr, i
    Next i
    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To InArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(InArrGet(arr, i))
    Next i

    'Stack

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Stack"
    ListBox Add CbHndl, lbxID, "Push 1, 2, 3 on Stack"
    InArrClear arr
    InArrStkPush arr, 1
    InArrStkPush arr, 2
    InArrStkPush arr, 3
    ListBox Add CbHndl, lbxID, "Peek and Pop Stack"
    While InArrCount(arr)
        ListBox Add CbHndl, lbxID, "Peek() = " + Format$(InArrStkPeek(arr))
        ListBox Add CbHndl, lbxID, "Pop() = " + Format$(InArrStkPop(arr))
    Wend

    'Queue

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Queue"
    ListBox Add CbHndl, lbxID, "Add 1, 2, 3 to Queue"
    InArrClear arr
    InArrQuePush arr, 1
    InArrQuePush arr, 2
    InArrQuePush arr, 3
    ListBox Add CbHndl, lbxID, "Peek and Pop Queue"
    While InArrCount(arr)
        ListBox Add CbHndl, lbxID, "Peek = " + Format$(InArrQuePeek(arr))
        ListBox Add CbHndl, lbxID, "Pop = " + Format$(InArrQuePop(arr))
    Wend

    'Deque - double-ended Queue

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Deque - double-ended Queue"
    ListBox Add CbHndl, lbxID, "Add 1, 2, 3 to Front of Deque"
    InArrClear arr
    InArrPushFirst arr, 1
    InArrPushFirst arr, 2
    InArrPushFirst arr, 3
    ListBox Add CbHndl, lbxID, "Add 4, 5, 6 to End of Deque"
    InArrPushLast arr, 4
    InArrPushLast arr, 5
    InArrPushLast arr, 6
    ListBox Add CbHndl, lbxID, "Peek and Pop Deque"
    While InArrCount(arr)
        ListBox Add CbHndl, lbxID, "PeekFirst = " + Format$(InArrPeekFirst(arr))
        ListBox Add CbHndl, lbxID, "PopFirst = " + Format$(InArrPopFirst(arr))
        ListBox Add CbHndl, lbxID, "PeekLast = " + Format$(InArrPeekLast(arr))
        ListBox Add CbHndl, lbxID, "PopLast = " + Format$(InArrPopLast(arr))
    Wend

    'Clone

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Clone"
    ListBox Add CbHndl, lbxID, "add 1, 2, 3 to array"
    InArrClear arr
    For i = 1 To 3
        InArrAdd arr, i
    Next i
    ListBox Add CbHndl, lbxID, "clone array"
    clone = InArrClone(arr)
    ListBox Add CbHndl, lbxID, "display Clone"
    For i = 1 To InArrCount(clone)
        ListBox Add CbHndl, lbxID, Format$(InArrGet(clone, i))
    Next i

    'Store/Restore: store/restore container to/from string

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store array to String"
    s = InArrStore(arr)

    ListBox Add CbHndl, lbxID, "clear array"
    InArrClear arr

    ListBox Add CbHndl, lbxID, "restore array from String"
    InArrRestore arr, s

    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To InArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(InArrGet(arr, i))
    Next i

    'FileStore/FileRestore: store/restore container to/from file

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store array to File"
    InArrFileStore arr, "test.data"

    ListBox Add CbHndl, lbxID, "clear array"
    InArrClear arr

    ListBox Add CbHndl, lbxID, "restore array from File"
    InArrFileRestore arr, "test.data"

    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To InArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(InArrGet(arr, i))
    Next i

    If IsFile("test.data") Then Kill "test.data"

    'must free handles before they go out of scope
    arr = InArrFinal(arr)
    clone = InArrFinal(clone)

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "done..."
End Function

Function PBMain()
    Local hDlg As Long
    Dialog New 0, "InArr.bas", 67, 61, 341, 241, %WS_Caption Or %WS_ClipSiblings Or %WS_MinimizeBox Or %WS_SysMenu, %WS_Ex_AppWindow To hDlg
    Control Add ListBox, hDlg, lbxID, , 5, 5, 330, 210, %WS_Child Or %WS_HScroll Or %WS_VScroll Or %LBS_Notify Or %LBS_NoIntegralHeight, %WS_Ex_ClientEdge
    Control Add Button,  hDlg, btnID, "Test", 275, 220, 60, 15 Call BtnCB()
    Dialog Show Modal hDlg, Call DlgCB
End Function

CallBack Function DlgCB()
End Function
