#Include This Once

#If Not %Def(%ExitIfInc)
%ExitIfInc = 1

Macro ExitIf(test, errNo, exitWhat)
    If test Then
        ExitLog FuncName$, errNo
        Exit exitWhat
    End If
End Macro
Macro ExitS(test, errNo) = ExitIf(test, errNo, Sub)
Macro ExitF(test, errNo) = ExitIf(test, errNo, Function)

Macro ExitLogErr(errNo) = ExitLog(FuncName$, errNo)

Macro ExitO(test, errNo, exitWhat)
    If test Then
        ExitLog mClass+":"+FuncName$, errNo
        Exit exitWhat
    End If
End Macro
Macro ExitP(test, errNo) = ExitO(test, errNo, Property)
Macro ExitM(test, errNo) = ExitO(test, errNo, Method)

Macro ExitLogErrO(errNo) = ExitLog mClass+":"+FuncName$, errNo

Sub ExitLog(ByVal msg As String, ByVal errNo As Long)
    Local h As Long
    Error errNo
    msg += ":" + Format$(errNo)
    #If %Def(%HaltOnError)
        ? msg,,"Error!"
        End
    #EndIf
    h = FreeFile
    Try
        Open Exe.Path$+"HLib.log" For Append As h
        If Lof(h) < 16000 Then
            Print# h, Date$ +", "+ Time$ +", "+ Exe.Full$ +", "+ msg
        End If
    Catch
    Finally
        Close h
    End Try
End Sub

#EndIf
