'LnLnHsh.bas
#Dim All
#Compile Exe
#Include Once "WIN32API.INC"
#Include Once "..\LnLnHsh.inc"

Macro lbxID = 1000
Macro btnID = 1001

CallBack Function BtnCB()
    Local i, Count As Long
    Local d As Double
    Local s As String

    ListBox Reset CbHndl, lbxID
    Randomize
    Count = 100000

    Local hash As Long

    'create new Hash Table and specify capacity
    'capacity should be about the number of expected items

    hash = LnLnHshNew(Count)

    'add Key and Value to Hash Table

    ListBox Add CbHndl, lbxID, "add "+Format$(Count, "#,")+" Key/Value items to Hash Table"
    d = Timer
    For i = 1 To Count
        LnLnHshSet hash, i, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(LnLnHshCount(hash), "#,")

    'test to see if Key is in Hash Table

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "test all "+Format$(Count, "#,")+" Key's existence with LnLnHshGot()"
    d = Timer
    For i = 1 To Count
        If IsFalse LnLnHshGot(hash, i) Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'get Key's associated Value

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "get and test all "+Format$(Count, "#,")+" Values using lookup Key"
    d = Timer
    For i = 1 To Count
        If LnLnHshGet(hash, i) <> i Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'change Hash Table's capacity (number of reserved slots)
    'this Hash Table works very well if capacity = number of items
    'note: Hash Table has to rebuild

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "change Capacity to 1/100 number of items"
    ListBox Add CbHndl, lbxID, "Note: capacity should be about the same as number of items for optimal performance"
    LnLnHshCapSet hash, Count/100
    ListBox Add CbHndl, lbxID, "test all "+Format$(Count, "#,")+" Key's existence with LnLnHshGot()"
    d = Timer
    For i = 1 To Count
        If IsFalse LnLnHshGot(hash, i) Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "set Capacity back to number of items"
    LnLnHshCapSet hash, Count

    'remove Key and associated Value from Hash Table

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "remove every odd Key string from Hash Table"
    d = Timer
    For i = 1 To Count
        If i Mod 2 Then LnLnHshDel hash, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(LnLnHshCount(hash), "#,")
    ListBox Add CbHndl, lbxID, "make sure odd Keys aren't in Hash Table"
    For i = 1 To Count
        If i Mod 2 And LnLnHshGot(hash, i) Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i
    ListBox Add CbHndl, lbxID, "make sure even Keys are in Hash Table"
    For i = 1 To Count
        If IsFalse i Mod 2 And IsFalse LnLnHshGot(hash, i) Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i

    'clone

    Local clone As Long

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clear Hash Table"
    LnLnHshClear hash
    LnLnHshCapSet hash, 500
    ListBox Add CbHndl, lbxID, "add 500 items to Hash Table"
    For i = 1 To 500
        LnLnHshSet hash, i, i
    Next i
    ListBox Add CbHndl, lbxID, "clone Hash Table"
    clone = LnLnHshClone(hash)
    ListBox Add CbHndl, lbxID, "make sure all 500 Key/Value items in Clone"
    For i = 1 To 500
        If LnLnHshGet(clone, i) <> i Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i

    clone = LnLnHshFinal(clone)

    'store/restore to/from String

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Store Hash Table to String"
    s = LnLnHshStore(hash)
    ListBox Add CbHndl, lbxID, "Restore Hash Table from String"
    LnLnHshRestore hash, s
    ListBox Add CbHndl, lbxID, "make sure all 500 Key/Value items in Hash Table"
    For i = 1 To 500
        If LnLnHshGet(hash, i) <> i Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i
    s = ""

    'store/restore to/from File

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Store Hash Table to File"
    LnLnHshFileStore hash, "test.data"
    ListBox Add CbHndl, lbxID, "Restore Hash Table from File"
    LnLnHshFileRestore hash, "test.data"
    ListBox Add CbHndl, lbxID, "make sure all 500 Key/Value items in Hash Table"
    For i = 1 To 500
        If LnLnHshGet(hash, i) <> i Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i

    If IsFile("test.data") Then Kill "test.data"

    'must free handle before container goes out of scope
    hash = LnLnHshFinal(hash)

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "done..."
End Function

Function PBMain()
    Local hDlg As Long
    Dialog New 0, "LnLnHsh", 67, 61, 341, 241, %WS_Caption Or %WS_ClipSiblings Or %WS_MinimizeBox Or %WS_SysMenu, %WS_Ex_AppWindow To hDlg
    Control Add ListBox, hDlg, lbxID, , 5, 5, 330, 210, %WS_Child Or %WS_HScroll Or %WS_VScroll Or %LBS_Notify Or %LBS_NoIntegralHeight, %WS_Ex_ClientEdge
    Control Add Button,  hDlg, btnID, "Test", 275, 220, 60, 15 Call BtnCB()
    Dialog Show Modal hDlg, Call DlgCB
End Function

CallBack Function DlgCB()
End Function
