'SsExHsh.bas
#Dim All
#Compile Exe
#Include Once "WIN32API.INC"
#Include Once "..\SsExHsh.inc"

Macro lbxID = 1000
Macro btnID = 1001

CallBack Function BtnCB()
    Local i, Count As Long
    Local a() As String
    Local d As Double
    Local s As String

    ListBox Reset CbHndl, lbxID
    Randomize
    Count = 100000

    ReDim a(1 To Count)
    For i = 1 To Count
        a(i) = Format$(i)
    Next i

    Local hash As Long

    'create new Hash Table and specify capacity
    'capacity should be about the number of expected items

    hash = SsExHshNew(Count)

    'add Key and Value to Hash Table

    ListBox Add CbHndl, lbxID, "add "+Format$(Count, "#,")+" Key/Value items to Hash Table"
    d = Timer
    For i = 1 To Count
        SsExHshSet hash, a(i), i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(SsExHshCount(hash), "#,")

    'test to see if Key is in Hash Table

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "test all "+Format$(Count, "#,")+" Key's existence with SsExHshGot()"
    d = Timer
    For i = 1 To Count
        If IsFalse SsExHshGot(hash, a(i)) Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'get Key's associated Value

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "get and test all "+Format$(Count, "#,")+" Values using lookup Key"
    d = Timer
    For i = 1 To Count
        If SsExHshGet(hash, a(i)) <> i Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'change Hash Table's capacity (number of reserved slots)
    'this Hash Table works very well if capacity = number of items
    'note: Hash Table has to rebuild

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "change Capacity to 1/100 number of items"
    ListBox Add CbHndl, lbxID, "Note: capacity should be about the same as number of items for optimal performance"
    SsExHshCapSet hash, Count/100
    ListBox Add CbHndl, lbxID, "test all "+Format$(Count, "#,")+" Key's existence with SsExHshGot()"
    d = Timer
    For i = 1 To Count
        If IsFalse SsExHshGot(hash, a(i)) Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "set Capacity back to number of items"
    SsExHshCapSet hash, Count

    'remove Key and associated Value from Hash Table

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "remove every odd Key string from Hash Table"
    d = Timer
    For i = 1 To Count
        If i Mod 2 Then SsExHshDel hash, a(i)
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(SsExHshCount(hash), "#,")
    ListBox Add CbHndl, lbxID, "make sure odd Keys aren't in Hash Table"
    For i = 1 To Count
        If i Mod 2 And SsExHshGot(hash, a(i)) Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i
    ListBox Add CbHndl, lbxID, "make sure even Keys are in Hash Table"
    For i = 1 To Count
        If IsFalse i Mod 2 And IsFalse SsExHshGot(hash, a(i)) Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i

    'clone

    Local clone As Long

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clear Hash Table"
    SsExHshClear hash
    SsExHshCapSet hash, 500
    ListBox Add CbHndl, lbxID, "add 500 items to Hash Table"
    For i = 1 To 500
        SsExHshSet hash, a(i), i
    Next i
    ListBox Add CbHndl, lbxID, "clone Hash Table"
    clone = SsExHshClone(hash)
    ListBox Add CbHndl, lbxID, "make sure all 500 Key/Value items in Clone"
    For i = 1 To 500
        If SsExHshGet(clone, a(i)) <> i Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i

    clone = SsExHshFinal(clone)

    'store/restore to/from String

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Store Hash Table to String"
    s = SsExHshStore(hash)
    ListBox Add CbHndl, lbxID, "Restore Hash Table from String"
    SsExHshRestore hash, s
    ListBox Add CbHndl, lbxID, "make sure all 500 Key/Value items in Hash Table"
    For i = 1 To 500
        If SsExHshGet(hash, a(i)) <> i Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i
    s = ""

    'store/restore to/from File

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Store Hash Table to File"
    SsExHshFileStore hash, "test.data"
    ListBox Add CbHndl, lbxID, "Restore Hash Table from File"
    SsExHshFileRestore hash, "test.data"
    ListBox Add CbHndl, lbxID, "make sure all 500 Key/Value items in Hash Table"
    For i = 1 To 500
        If SsExHshGet(hash, a(i)) <> i Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i

    If IsFile("test.data") Then Kill "test.data"

    'must free handle before container goes out of scope
    hash = SsExHshFinal(hash)

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "done..."
End Function

Function PBMain()
    Local hDlg As Long
    Dialog New 0, "SsExHsh", 67, 61, 341, 241, %WS_Caption Or %WS_ClipSiblings Or %WS_MinimizeBox Or %WS_SysMenu, %WS_Ex_AppWindow To hDlg
    Control Add ListBox, hDlg, lbxID, , 5, 5, 330, 210, %WS_Child Or %WS_HScroll Or %WS_VScroll Or %LBS_Notify Or %LBS_NoIntegralHeight, %WS_Ex_ClientEdge
    Control Add Button,  hDlg, btnID, "Test", 275, 220, 60, 15 Call BtnCB()
    Dialog Show Modal hDlg, Call DlgCB
End Function

CallBack Function DlgCB()
End Function
