#INCLUDE THIS ONCE
#INCLUDE ONCE "..\HLib3\Mem.inc"
#INCLUDE ONCE "..\HLib3\Size.inc"

    'Long Stack Container
    'INTERNAL USE

TYPE LStkNode
    prev AS LStkNode PTR
    index AS LONG
    arr(1 TO %StkMax) AS LONG
END TYPE
TYPE LStk
    count AS LONG
    top AS LStkNode PTR
END TYPE


SUB LStkFinal(t AS LStk)
    LStkClear t
END SUB

SUB LStkClear(t AS LStk)
    LOCAL hNode AS LONG
    WHILE t.top
        hNode = t.top
        t.top = t.@top.prev
        MemFree(hNode)
    WEND
    t.count = 0
    t.top = 0
END SUB

FUNCTION LStkCount(t AS LStk) AS LONG
    'get item count
    FUNCTION = t.count
END FUNCTION

SUB LStkPush(t AS LStk, BYVAL value AS LONG)
    'push value on top of stack
    LOCAL node AS LStkNode PTR
    IF t.count = 0 THEN
        t.top = MemAlloc(SIZEOF(LStkNode))
        IF t.top THEN
            t.@top.arr(1) = value
            t.@top.index = 1
            t.count = 1
        END IF
    ELSEIF t.@top.index < %StkMax THEN
        INCR t.@top.index
        t.@top.arr(t.@top.index) = value
        INCR t.count
    ELSE
        node = MemAlloc(SIZEOF(LStkNode))
        IF node THEN
            @node.arr(1) = value
            @node.index = 1
            @node.prev = t.top
            t.top = node
            INCR t.count
        END IF
    END IF
END SUB

FUNCTION LStkPeek(t AS LStk) AS LONG
    'get top value on stack
    IF t.count THEN FUNCTION = t.@top.arr(t.@top.index)
END FUNCTION

FUNCTION LStkPop(t AS LStk) AS LONG
    'get and remove top value on stack
    LOCAL hNode AS LONG
    IF t.count THEN
        FUNCTION = t.@top.arr(t.@top.index)
        DECR t.@top.index
        DECR t.count
        IF t.@top.index = 0 THEN
            hNode = t.top
            t.top = t.@top.prev
            MemFree(hNode)
        END IF
    END IF
END FUNCTION
