#Include This Once
#Include Once "C:\HLib3\HLib.inc"

Macro DwLstNodeTag = 1540788735
Macro DwLstTag = -2145892447
Type DwLstNode
    tag As Long
    next As DwLstNode Ptr
    prev As DwLstNode Ptr
    value As Dword
End Type
Type DwLst
    tag As Long
    count As Long
    first As DwLstNode Ptr
    last As DwLstNode Ptr
End Type

'++
    '----------------------------------------------------------------------------------------
    '   Dword List Container Procedures
    '       container accessed with handle
    '       handle protected by hash tag
    '       h = DwLstNew() 'get handle for new container
    '       h = DwLstFinal(h) 'free handle before it goes out of scope
    '----------------------------------------------------------------------------------------
'--

Function DwLstNew() As Long
    'allocate new container - return handle
    Local pLst As DwLst Ptr
    pLst = MemAlloc(SizeOf(@pLst))
    ExitF(pLst=0, LibErrM)
    @pLst.tag = DwLstTag
    Function = pLst
End Function

Function DwLstFinal(ByVal pLst As DwLst Ptr) As Long
    'free allocated container - return null
    If pLst Then
        ExitF(@pLst.tag<>DwLstTag, LibErrH)
        DwLstClear pLst
        MemFree(pLst)
    End If
End Function

Function DwLstValidate(ByVal pLst As DwLst Ptr) As Long
    'True/False if valid handle for this container
    If pLst And @pLst.tag = DwLstTag Then Function = @pLst.tag
End Function

Sub DwLstClear(ByVal pLst As DwLst Ptr)
    'delete all data
    Local node As DwLstNode Ptr
    ExitS(pLst=0 Or @pLst.tag<>DwLstTag, LibErrH)
    While @pLst.first
        node = @pLst.first
        @pLst.first = @node.next
        MemFree(node)
    Wend
    @pLst.last = 0
    @pLst.count = 0
End Sub

Function DwLstCount(ByVal pLst As DwLst Ptr) As Long
    'get item count (number of characters)
    ExitF(pLst=0 Or @pLst.tag<>DwLstTag, LibErrH)
    Function = @pLst.count
End Function

Sub DwLstAdd(ByVal pLst As DwLst Ptr, ByVal value As Dword)
    'append Value to end of List
    Local node As DwLstNode Ptr
    Err = 0
    ExitS(pLst=0 Or @pLst.tag<>DwLstTag, LibErrH)
    If @pLst.count Then
        node = DwLstNodeAlloc(pLst) : If Err Then Exit Sub
        @node.value = value
        ExitS(@pLst.last=0, LibErrU)
        @pLst.@last.next = node
        @node.prev = @pLst.last
        @pLst.last = node
    Else
        node = DwLstNodeAlloc(pLst) : If Err Then Exit Sub
        @node.value = value
        @pLst.first = node
        @pLst.last = node
        @pLst.count = 1
    End If
End Sub

Sub DwLstIns(ByVal pLst As DwLst Ptr, ByVal value As Dword)
    'insert Value at front of List
    Local node As DwLstNode Ptr
    Err = 0
    ExitS(pLst=0 Or @pLst.tag<>DwLstTag, LibErrH)
    If @pLst.count Then
        node = DwLstNodeAlloc(pLst) : If Err Then Exit Sub
        @node.value = value
        ExitS(@pLst.first=0, LibErrU)
        @pLst.@first.prev = node
        @node.next = @pLst.first
        @pLst.first = node
    Else
        node = DwLstNodeAlloc(pLst) : If Err Then Exit Sub
        @node.value = value
        @pLst.first = node
        @pLst.last = node
        @pLst.count = 1
    End If
End Sub

Function DwLstFirst(ByVal pLst As DwLst Ptr) As Long
    'get handle to first node in List
    ExitF(pLst=0 Or @pLst.tag<>DwLstTag, LibErrH)
    Function = @pLst.first
End Function

Function DwLstLast(ByVal pLst As DwLst Ptr) As Long
    'get handle to last node in List
    ExitF(pLst=0 Or @pLst.tag<>DwLstTag, LibErrH)
    Function = @pLst.last
End Function

Function DwLstNext(ByVal pNode As DwLstNode Ptr) As Long
    'get handle to next node in List
    ExitF(pNode=0 Or @pNode.tag<>DwLstNodeTag, LibErrH)
    Function = @pNode.next
End Function

Function DwLstPrev(ByVal pNode As DwLstNode Ptr) As Long
    'get handle to previous node in List
    ExitF(pNode=0 Or @pNode.tag<>DwLstNodeTag, LibErrH)
    Function = @pNode.prev
End Function

Function DwLstGet(ByVal pNode As DwLstNode Ptr) As Dword
    'get node's Value
    ExitF(pNode=0 Or @pNode.tag<>DwLstNodeTag, LibErrH)
    Function = @pNode.value
End Function

Sub DwLstSet(ByVal pNode As DwLstNode Ptr, ByVal value As Dword)
    'set node's Value
    ExitS(pNode=0 Or @pNode.tag<>DwLstNodeTag, LibErrH)
    @pNode.value = value
End Sub

Sub DwLstInsPrev(ByVal pLst As DwLst Ptr, ByVal pNode As DwLstNode Ptr, ByVal value As Dword)
    'insert Value before node
    Local node As DwLstNode Ptr
    Err = 0
    ExitS(pLst=0 Or pNode=0 Or @pLst.tag<>DwLstTag Or @pNode.tag<>DwLstNodeTag, LibErrH)
    If pNode = @pLst.first Then
        DwLstIns pLst, value
    Else
        ExitS(@pNode.prev=0, LibErrU)
        node = DwLstNodeAlloc(pLst) : If Err Then Exit Sub
        @node.value = value
        @node.next = pNode
        @node.prev = @pNode.prev
        @pNode.@prev.next = node
        @pNode.prev = node
    End If
End Sub

Sub DwLstInsNext(ByVal pLst As DwLst Ptr, ByVal pNode As DwLstNode Ptr, ByVal value As Dword)
    'insert Value after Cursor
    Local node As DwLstNode Ptr
    Err = 0
    ExitS(pLst=0 Or pNode=0 Or @pLst.tag<>DwLstTag Or @pNode.tag<>DwLstNodeTag, LibErrH)
    If pNode = @pLst.last Then
        DwLstAdd pLst, value
    Else
        ExitS(@pNode.next=0, LibErrU)
        node = DwLstNodeAlloc(pLst) : If Err Then Exit Sub
        @node.value = value
        @node.next = @pNode.next
        @node.prev = pNode
        @pNode.@next.prev = node
        @pNode.next = node
    End If
End Sub

Sub DwLstDel(ByVal pLst As DwLst Ptr, ByVal pNode As DwLstNode Ptr) Private
    'remove node from list
    ExitS(pNode=0 Or @pNode.tag<>DwLstNodeTag, LibErrH)
    If pNode Then
        ExitS(@pNode.tag<>DwLstNodeTag, LibErrH)
        If @pLst.first = pNode Then @pLst.first = @pNode.next
        If @pLst.last = pNode Then @pLst.last = @pNode.prev
        If @pNode.prev Then @pNode.@prev.next = @pNode.next
        If @pNode.next Then @pNode.@next.prev = @pNode.prev
        ExitS(@pLst.count=0, LibErrU)
        Decr @pLst.count
        MemFree(pNode)
    End If
End Sub

Sub DwLstDelPrev(ByVal pLst As DwLst Ptr, ByVal pNode As DwLstNode Ptr)
    'remove node before this node
    ExitS(pLst=0 Or pNode=0 Or @pLst.tag<>DwLstTag Or @pNode.tag<>DwLstNodeTag, LibErrH)
    DwLstDel pLst, @pNode.prev
End Sub

Sub DwLstDelNext(ByVal pLst As DwLst Ptr, ByVal pNode As DwLstNode Ptr)
    'remove node after this node
    ExitS(pLst=0 Or pNode=0 Or @pLst.tag<>DwLstTag Or @pNode.tag<>DwLstNodeTag, LibErrH)
    DwLstDel pLst, @pNode.next
End Sub

'++
    '----------------------------------------------------------------------------------------
    '   Stack Procedures
    '----------------------------------------------------------------------------------------
'--

Sub DwLstStkPush(ByVal pLst As DwLst Ptr, ByVal value As Dword)
    'Push Value on Stack
    DwLstAdd pLst, value
End Sub

Function DwLstStkPeek(ByVal pLst As DwLst Ptr) As Dword
    'get top Value on Stack
    ExitF(pLst=0 Or @pLst.tag<>DwLstTag, LibErrH)
    If @pLst.last Then Function = @pLst.@last.value
End Function

Function DwLstStkPop(ByVal pLst As DwLst Ptr) As Dword
    'get and remove top Value on Stack
    ExitF(pLst=0 Or @pLst.tag<>DwLstTag, LibErrH)
    If @pLst.last Then
        Function = @pLst.@last.value
        DwLstDel pLst, @pLst.last
    End If
End Function

'++
    '----------------------------------------------------------------------------------------
    '   Queue Procedures
    '----------------------------------------------------------------------------------------
'--

Sub DwLstQuePush(ByVal pLst As DwLst Ptr, ByVal value As Dword)
    'Add Value to end of Queue
    DwLstAdd pLst, value
End Sub

Function DwLstQuePeek(ByVal pLst As DwLst Ptr) As Dword
    'get first Value in Queue
    ExitF(pLst=0 Or @pLst.tag<>DwLstTag, LibErrH)
    If @pLst.first Then Function = @pLst.@first.value
End Function

Function DwLstQuePop(ByVal pLst As DwLst Ptr) As Dword
    'get and remove first Value in Queue
    ExitF(pLst=0 Or @pLst.tag<>DwLstTag, LibErrH)
    If @pLst.first Then
        Function = @pLst.@first.value
        DwLstDel pLst, @pLst.first
    End If
End Function

'++
    '----------------------------------------------------------------------------------------
    '   Deque Procedures (double-ended Queue)
    '----------------------------------------------------------------------------------------
'--

Sub DwLstPushFirst(ByVal pLst As DwLst Ptr, ByVal value As Dword)
    'Add Value at front of container
    DwLstIns pLst, value
End Sub

Sub DwLstPushLast(ByVal pLst As DwLst Ptr, ByVal value As Dword)
    'Add Value at end of container
    DwLstAdd pLst, value
End Sub

Function DwLstPeekFirst(ByVal pLst As DwLst Ptr) As Dword
    'get first Value in container
    ExitF(pLst=0 Or @pLst.tag<>DwLstTag, LibErrH)
    If @pLst.first Then Function = @pLst.@first.value
End Function

Function DwLstPeekLast(ByVal pLst As DwLst Ptr) As Dword
    'get last Value in container
    ExitF(pLst=0 Or @pLst.tag<>DwLstTag, LibErrH)
    If @pLst.last Then Function = @pLst.@last.value
End Function

Function DwLstPopFirst(ByVal pLst As DwLst Ptr) As Dword
    'get and remove first Value in container
    ExitF(pLst=0 Or @pLst.tag<>DwLstTag, LibErrH)
    If @pLst.first Then
        Function = @pLst.@first.value
        DwLstDel pLst, @pLst.first
    End If
End Function

Function DwLstPopLast(ByVal pLst As DwLst Ptr) As Dword
    'get and remove last Value in container
    ExitF(pLst=0 Or @pLst.tag<>DwLstTag, LibErrH)
    If @pLst.last Then
        Function = @pLst.@last.value
        DwLstDel pLst, @pLst.last
    End If
End Function

'++
    '----------------------------------------------------------------------------------------
    '   Clone Container
    '----------------------------------------------------------------------------------------
'--

Function DwLstClone(ByVal pLst As DwLst Ptr) As Long
    'returns handle to duplicate container
    Local pClone As DwLst Ptr
    Local node As DwLstNode Ptr
    ExitF(pLst=0 Or @pLst.tag<>DwLstTag, LibErrH)
    Err = 0
    pClone = DwLstNew() : If Err Then Exit Function
    node = @pLst.first
    While node
        DwLstAdd pClone, @node.value
        node = @node.next
    Wend
    Function = pClone
End Function

'++
    '----------------------------------------------------------------------------------------
    '   Store/Restore Container To/From String
    '----------------------------------------------------------------------------------------
'--

Function DwLstStore(ByVal pLst As DwLst Ptr) As String
    'store container to String
    Local s As String
    Local node As DwLstNode Ptr
    Local p As Dword Ptr
    ExitF(pLst=0 Or @pLst.tag<>DwLstTag, LibErrH)
    If @pLst.count Then
        s = Nul$(@pLst.count * %SizeDw)
        p = StrPtr(s)
        node = @pLst.first
        While node
            @p = @node.value : Incr p
            node = @node.next
        Wend
    End If
    Function = s
End Function

Sub DwLstRestore(ByVal pLst As DwLst Ptr, ByRef s As String)
    'restore container from string
    Local items As Long
    Local p As Dword Ptr
    ExitS(pLst=0 Or @pLst.tag<>DwLstTag, LibErrH)
    DwLstClear pLst
    If Len(s) Then
        p = StrPtr(s)
        items = Len(s) / %SizeDw
        While items
            DwLstAdd pLst, @p
            Incr p
            Decr items
        Wend
    End If
End Sub

'++
    '----------------------------------------------------------------------------------------
    '   Store/Restore Container To/From File
    '----------------------------------------------------------------------------------------
'--

Sub DwLstFileStore(ByVal pLst As DwLst Ptr, ByVal file As String)
    'store container to file
    Local s As String
    Local f As Long
    Err = 0
    ExitS(pLst=0 Or @pLst.tag<>DwLstTag, LibErrH)
    s = DwLstStore(pLst) : If Err Then Exit Sub
    Try
        f = FreeFile
        Open file For Binary As f
        SetEof f
        Put$ f, s
        Close f
    Catch
        ExitLogErr(LibErrF)
    Finally
        If f Then Close f
    End Try
End Sub

Sub DwLstFileRestore(ByVal pLst As DwLst Ptr, ByVal file As String)
    'restore container from file
    Local f As Long
    Local s As String
    Err = 0
    ExitS(pLst=0 Or @pLst.tag<>DwLstTag, LibErrH)
    Try
        f = FreeFile
        Open file For Binary As f
        Get$ f, Lof(f), s
        DwLstRestore pLst, s
    Catch
        ExitLogErr(LibErrF)
    Finally
        If f Then Close f
    End Try
End Sub


    '----------------------------------------------------------------------------------------
    '   PRIVATE
    '----------------------------------------------------------------------------------------

Function DwLstNodeAlloc(ByVal pLst As DwLst Ptr) Private As Long
    Local node As DwLstNode Ptr
    node = MemAlloc(SizeOf(DwLstNode))
    ExitF(node=0, LibErrM)
    @node.tag = DwLstNodeTag
    Incr @pLst.count
    Function = node
End Function
