'CxLst.bas
#Dim All
#Compile Exe
#Include Once "WIN32API.INC"
%HaltOnError = 1
#Include Once "..\CxLst.inc"

Macro lbxID = 1000
Macro btnID = 1001

CallBack Function BtnCB()
    Local i, Count As Long
    Local d As Double
    Local s As String

    'get handle to new List container
    Local list As Long : list = CxLstNew()
    Local clone As Long
    Local node As Long

    ListBox Reset CbHndl, lbxID
    Randomize
    Count = 100000

    'append value to end of List

    ListBox Add CbHndl, lbxID, "Add "+Format$(Count, "#,")+" values to empty List"
    d = Timer
    For i = 1 To Count
        CxLstAdd list, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(CxLstCount(list), "#,")

    'traverse forward - get value

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "traverse List forward - get and test all "+Format$(Count, "#,")+" values"
    i = 0
    d = Timer
    node = CxLstFirst(list)
    While node
        Incr i
        If CxLstGet(node) <> i Then
            ? "fail at: " + Format$(i) : Exit Loop
        End If
        node = CxLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'insert value at front of empty List

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clear List"
    CxLstClear list
    ListBox Add CbHndl, lbxID, "insert "+Format$(Count, "#,")+" values at front of List"
    d = Timer
    For i = 1 To Count
        CxLstIns list, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'traverse backward - get value

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "traverse List backward - get and test all "+Format$(Count, "#,")+" values"
    i = 0
    d = Timer
    node = CxLstLast(list)
    While node
        Incr i
        If CxLstGet(node) <> i Then
            ? "fail at: " + Format$(i) : Exit Loop
        End If
        node = CxLstPrev(node)
    Wend
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clear List"
    CxLstClear list
    ListBox Add CbHndl, lbxID, "add 2, 4, 6"
    CxLstAdd list, 2
    CxLstAdd list, 4
    CxLstAdd list, 6
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = CxLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(CxLstGet(node))
        node = CxLstNext(node)
    Wend

    'insert before/after

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "move to first node"  : node = CxLstFirst(list)
    ListBox Add CbHndl, lbxID, "    insert 1 before" : CxLstInsPrev list, node, 1
    ListBox Add CbHndl, lbxID, "    insert 3 after"  : CxLstInsNext list, node, 3
    ListBox Add CbHndl, lbxID, "move to last node"   : node = CxLstLast(list)
    ListBox Add CbHndl, lbxID, "    insert 5 before" : CxLstInsPrev list, node, 5
    ListBox Add CbHndl, lbxID, "    insert 7 after"  : CxLstInsNext list, node, 7
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = CxLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(CxLstGet(node))
        node = CxLstNext(node)
    Wend

    'remove before/after

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "move to second node in List"
    node = CxLstFirst(list) : node = CxLstNext(node)
    ListBox Add CbHndl, lbxID, "    remove value before node" : CxLstDelPrev list, node
    ListBox Add CbHndl, lbxID, "    remove value after node"  : CxLstDelNext list, node
    ListBox Add CbHndl, lbxID, "move to second node from end of  List"
    node = CxLstLast(list) : node = CxLstPrev(node)
    ListBox Add CbHndl, lbxID, "    remove value before node" : CxLstDelPrev list, node
    ListBox Add CbHndl, lbxID, "    remove value after node"  : CxLstDelNext list, node
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = CxLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(CxLstGet(node))
        node = CxLstNext(node)
    Wend

    'Clone

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clone List"
    clone = CxLstClone(list)
    ListBox Add CbHndl, lbxID, "-- Display Cloned List --"
    node = CxLstFirst(clone)
    While node
        ListBox Add CbHndl, lbxID, Format$(CxLstGet(node))
        node = CxLstNext(node)
    Wend

    'Store/Restore To/From String

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store List to String"     : s = CxLstStore(list)
    ListBox Add CbHndl, lbxID, "clear List"               : CxLstClear list
    ListBox Add CbHndl, lbxID, "Count = " + Format$(CxLstCount(list), "#,")
    ListBox Add CbHndl, lbxID, "restore List from String" : CxLstRestore list, s
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = CxLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(CxLstGet(node))
        node = CxLstNext(node)
    Wend

    'Store/Restore To/From File

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store List to File"     : CxLstFileStore list, "test.data"
    ListBox Add CbHndl, lbxID, "clear List"             : CxLstClear list
    ListBox Add CbHndl, lbxID, "Count = " + Format$(CxLstCount(list), "#,")
    ListBox Add CbHndl, lbxID, "restore List from File" : CxLstFileRestore list, "test.data"
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = CxLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(CxLstGet(node))
        node = CxLstNext(node)
    Wend

    If IsFile("test.data") Then Kill "test.data"

    'Stack

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Stack:"
    ListBox Add CbHndl, lbxID, "push 1, 2, 3 on Stack"
    CxLstClear list
    CxLstStkPush list, 1
    CxLstStkPush list, 2
    CxLstStkPush list, 3
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = CxLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(CxLstGet(node))
        node = CxLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Peek and Pop Stack"
    While CxLstCount(list)
        ListBox Add CbHndl, lbxID, "Peek = " + Format$(CxLstStkPeek(list))
        ListBox Add CbHndl, lbxID, "Pop = " + Format$(CxLstStkPop(list))
    Wend

    'Queue

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Queue:"
    ListBox Add CbHndl, lbxID, "add 1, 2, 3 to Queue"
    CxLstClear list
    CxLstQuePush list, 1
    CxLstQuePush list, 2
    CxLstQuePush list, 3
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = CxLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(CxLstGet(node))
        node = CxLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Peek and Pop Queue"
    While CxLstCount(list)
        ListBox Add CbHndl, lbxID, "Peek = " + Format$(CxLstQuePeek(list))
        ListBox Add CbHndl, lbxID, "Pop = " + Format$(CxLstQuePop(list))
    Wend

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Deque: (double-ended Queue)"
    ListBox Add CbHndl, lbxID, "add 1, 2, 3 to front of Deque"
    CxLstPushFirst list, 1
    CxLstPushFirst list, 2
    CxLstPushFirst list, 3
    ListBox Add CbHndl, lbxID, "add 4, 5, 6 to end of Deque"
    CxLstPushLast list, 4
    CxLstPushLast list, 5
    CxLstPushLast list, 6
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = CxLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(CxLstGet(node))
        node = CxLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Peek and Pop Deque"
    While CxLstCount(list)
        ListBox Add CbHndl, lbxID, "PeekFirst = " + Format$(CxLstPeekFirst(list))
        ListBox Add CbHndl, lbxID, "PopFirst = " + Format$(CxLstPopFirst(list))
        ListBox Add CbHndl, lbxID, "PeekLast = " + Format$(CxLstPeekLast(list))
        ListBox Add CbHndl, lbxID, "PopLast = " + Format$(CxLstPopLast(list))
    Wend

    'must free handles before they go out of scope
    list = CxLstFinal(list)
    clone = CxLstFinal(clone)


    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "done..."
End Function

Function PBMain()
    Local hDlg As Long
    Dialog New 0, "CxLst", 67, 61, 341, 241, %WS_Caption Or %WS_ClipSiblings Or %WS_MinimizeBox Or %WS_SysMenu, %WS_Ex_AppWindow To hDlg
    Control Add ListBox, hDlg, lbxID, , 5, 5, 330, 210, %WS_Child Or %WS_HScroll Or %WS_VScroll Or %LBS_Notify Or %LBS_NoIntegralHeight, %WS_Ex_ClientEdge
    Control Add Button,  hDlg, btnID, "Test", 275, 220, 60, 15 Call BtnCB()
    Dialog Show Modal hDlg, Call DlgCB
End Function

CallBack Function DlgCB()
End Function
