'DbLst.bas
#Dim All
#Compile Exe
#Include Once "WIN32API.INC"
%HaltOnError = 1
#Include Once "..\DbLst.inc"

Macro lbxID = 1000
Macro btnID = 1001

CallBack Function BtnCB()
    Local i, Count As Long
    Local d As Double
    Local s As String

    'get handle to new List container
    Local list As Long : list = DbLstNew()
    Local clone As Long
    Local node As Long

    ListBox Reset CbHndl, lbxID
    Randomize
    Count = 100000

    'append value to end of List

    ListBox Add CbHndl, lbxID, "Add "+Format$(Count, "#,")+" values to empty List"
    d = Timer
    For i = 1 To Count
        DbLstAdd list, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(DbLstCount(list), "#,")

    'traverse forward - get value

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "traverse List forward - get and test all "+Format$(Count, "#,")+" values"
    i = 0
    d = Timer
    node = DbLstFirst(list)
    While node
        Incr i
        If DbLstGet(node) <> i Then
            ? "fail at: " + Format$(i) : Exit Loop
        End If
        node = DbLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'insert value at front of empty List

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clear List"
    DbLstClear list
    ListBox Add CbHndl, lbxID, "insert "+Format$(Count, "#,")+" values at front of List"
    d = Timer
    For i = 1 To Count
        DbLstIns list, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'traverse backward - get value

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "traverse List backward - get and test all "+Format$(Count, "#,")+" values"
    i = 0
    d = Timer
    node = DbLstLast(list)
    While node
        Incr i
        If DbLstGet(node) <> i Then
            ? "fail at: " + Format$(i) : Exit Loop
        End If
        node = DbLstPrev(node)
    Wend
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clear List"
    DbLstClear list
    ListBox Add CbHndl, lbxID, "add 2, 4, 6"
    DbLstAdd list, 2
    DbLstAdd list, 4
    DbLstAdd list, 6
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = DbLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(DbLstGet(node))
        node = DbLstNext(node)
    Wend

    'insert before/after

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "move to first node"  : node = DbLstFirst(list)
    ListBox Add CbHndl, lbxID, "    insert 1 before" : DbLstInsPrev list, node, 1
    ListBox Add CbHndl, lbxID, "    insert 3 after"  : DbLstInsNext list, node, 3
    ListBox Add CbHndl, lbxID, "move to last node"   : node = DbLstLast(list)
    ListBox Add CbHndl, lbxID, "    insert 5 before" : DbLstInsPrev list, node, 5
    ListBox Add CbHndl, lbxID, "    insert 7 after"  : DbLstInsNext list, node, 7
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = DbLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(DbLstGet(node))
        node = DbLstNext(node)
    Wend

    'remove before/after

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "move to second node in List"
    node = DbLstFirst(list) : node = DbLstNext(node)
    ListBox Add CbHndl, lbxID, "    remove value before node" : DbLstDelPrev list, node
    ListBox Add CbHndl, lbxID, "    remove value after node"  : DbLstDelNext list, node
    ListBox Add CbHndl, lbxID, "move to second node from end of  List"
    node = DbLstLast(list) : node = DbLstPrev(node)
    ListBox Add CbHndl, lbxID, "    remove value before node" : DbLstDelPrev list, node
    ListBox Add CbHndl, lbxID, "    remove value after node"  : DbLstDelNext list, node
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = DbLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(DbLstGet(node))
        node = DbLstNext(node)
    Wend

    'Clone

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clone List"
    clone = DbLstClone(list)
    ListBox Add CbHndl, lbxID, "-- Display Cloned List --"
    node = DbLstFirst(clone)
    While node
        ListBox Add CbHndl, lbxID, Format$(DbLstGet(node))
        node = DbLstNext(node)
    Wend

    'Store/Restore To/From String

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store List to String"     : s = DbLstStore(list)
    ListBox Add CbHndl, lbxID, "clear List"               : DbLstClear list
    ListBox Add CbHndl, lbxID, "Count = " + Format$(DbLstCount(list), "#,")
    ListBox Add CbHndl, lbxID, "restore List from String" : DbLstRestore list, s
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = DbLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(DbLstGet(node))
        node = DbLstNext(node)
    Wend

    'Store/Restore To/From File

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store List to File"     : DbLstFileStore list, "test.data"
    ListBox Add CbHndl, lbxID, "clear List"             : DbLstClear list
    ListBox Add CbHndl, lbxID, "Count = " + Format$(DbLstCount(list), "#,")
    ListBox Add CbHndl, lbxID, "restore List from File" : DbLstFileRestore list, "test.data"
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = DbLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(DbLstGet(node))
        node = DbLstNext(node)
    Wend

    If IsFile("test.data") Then Kill "test.data"

    'Stack

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Stack:"
    ListBox Add CbHndl, lbxID, "push 1, 2, 3 on Stack"
    DbLstClear list
    DbLstStkPush list, 1
    DbLstStkPush list, 2
    DbLstStkPush list, 3
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = DbLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(DbLstGet(node))
        node = DbLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Peek and Pop Stack"
    While DbLstCount(list)
        ListBox Add CbHndl, lbxID, "Peek = " + Format$(DbLstStkPeek(list))
        ListBox Add CbHndl, lbxID, "Pop = " + Format$(DbLstStkPop(list))
    Wend

    'Queue

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Queue:"
    ListBox Add CbHndl, lbxID, "add 1, 2, 3 to Queue"
    DbLstClear list
    DbLstQuePush list, 1
    DbLstQuePush list, 2
    DbLstQuePush list, 3
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = DbLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(DbLstGet(node))
        node = DbLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Peek and Pop Queue"
    While DbLstCount(list)
        ListBox Add CbHndl, lbxID, "Peek = " + Format$(DbLstQuePeek(list))
        ListBox Add CbHndl, lbxID, "Pop = " + Format$(DbLstQuePop(list))
    Wend

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Deque: (double-ended Queue)"
    ListBox Add CbHndl, lbxID, "add 1, 2, 3 to front of Deque"
    DbLstPushFirst list, 1
    DbLstPushFirst list, 2
    DbLstPushFirst list, 3
    ListBox Add CbHndl, lbxID, "add 4, 5, 6 to end of Deque"
    DbLstPushLast list, 4
    DbLstPushLast list, 5
    DbLstPushLast list, 6
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = DbLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(DbLstGet(node))
        node = DbLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Peek and Pop Deque"
    While DbLstCount(list)
        ListBox Add CbHndl, lbxID, "PeekFirst = " + Format$(DbLstPeekFirst(list))
        ListBox Add CbHndl, lbxID, "PopFirst = " + Format$(DbLstPopFirst(list))
        ListBox Add CbHndl, lbxID, "PeekLast = " + Format$(DbLstPeekLast(list))
        ListBox Add CbHndl, lbxID, "PopLast = " + Format$(DbLstPopLast(list))
    Wend

    'must free handles before they go out of scope
    list = DbLstFinal(list)
    clone = DbLstFinal(clone)


    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "done..."
End Function

Function PBMain()
    Local hDlg As Long
    Dialog New 0, "DbLst", 67, 61, 341, 241, %WS_Caption Or %WS_ClipSiblings Or %WS_MinimizeBox Or %WS_SysMenu, %WS_Ex_AppWindow To hDlg
    Control Add ListBox, hDlg, lbxID, , 5, 5, 330, 210, %WS_Child Or %WS_HScroll Or %WS_VScroll Or %LBS_Notify Or %LBS_NoIntegralHeight, %WS_Ex_ClientEdge
    Control Add Button,  hDlg, btnID, "Test", 275, 220, 60, 15 Call BtnCB()
    Dialog Show Modal hDlg, Call DlgCB
End Function

CallBack Function DlgCB()
End Function
