#Include This Once
#Include Once "C:\HLib3\HLib.inc"

'++
    '----------------------------------------------------------------------------------------
    '   Currency Queue Container
    '       extremely fast, memory efficient and CPU Cache friendly Queue implementation
    '       - each node has a fixed array of 500 items
    '       - memory allocation and deallocation only takes place every 500'th item
    '       - CPU Cache loves small arrays
    '       - way more efficient for small data types; Byte, Integer, Word, ...
    '
    '       container accessed with handle
    '       handle protected by hash tag
    '       h = CuQueNew() 'get handle for new container
    '       h = CuQueFinal(h) 'free handle before it goes out of scope
    '----------------------------------------------------------------------------------------
'--

Macro CuQueTag = 1329494309
Type CuQueNode
    next As CuQueNode Ptr
    first As Long
    last As Long
    arr(1 To %QueMax) As Currency
End Type
Type CuQue
    tag As Long
    count As Long
    first As CuQueNode Ptr
    last As CuQueNode Ptr
End Type

Function CuQueNew() As Long
    'allocate new container - return handle
    Local p As CuQue Ptr
    p = MemAlloc(SizeOf(@p))
    ExitF(p=0, LibErrM)
    @p.tag = CuQueTag
    Function = p
End Function

Function CuQueFinal(ByVal p As CuQue Ptr) As Long
    'free allocated container - return null
    If p Then
        ExitF(@p.tag<>CuQueTag, LibErrH)
        CuQueClear p
        MemFree(p)
    End If
End Function

Function CuQueValidate(ByVal p As CuQue Ptr) As Long
    'True/False if valid handle for this container
    If p And @p.tag = CuQueTag Then Function = @p.tag
End Function

Sub CuQueClear(ByVal p As CuQue Ptr)
    'delete all data
    Local node As CuQueNode Ptr
    ExitS(p=0 Or @p.tag<>CuQueTag, LibErrH)
    While @p.first
        node = @p.first
        @p.first = @node.next
        MemFree(node)
    Wend
    @p.first = 0
    @p.last = 0
    @p.count = 0
End Sub

Function CuQueCount(ByVal p As CuQue Ptr) As Long
    'get item count
    ExitF(p=0 Or @p.tag<>CuQueTag, LibErrH)
    Function = @p.count
End Function

Sub CuQuePush(ByVal p As CuQue Ptr, ByVal value As Currency)
    'add value to end of queue
    Local node As CuQueNode Ptr
    ExitS(p=0 Or @p.tag<>CuQueTag, LibErrH)
    If @p.count = 0 Then
        @p.last = MemAlloc(SizeOf(CuQueNode))
        ExitS(@p.last=0, LibErrM)
        @p.@last.arr(1) = value
        @p.@last.first = 1
        @p.@last.last = 1
        @p.first = @p.last
        @p.count = 1
    Else
        ExitS(@p.last=0, LibErrU)
        If @p.@last.last < %QueMax Then
            Incr @p.@last.last
            @p.@last.arr(@p.@last.last) = value
            Incr @p.count
        Else
            node = MemAlloc(SizeOf(CuQueNode))
            ExitS(node=0, LibErrM)
            @node.arr(1) = value
            @node.first = 1
            @node.last = 1
            @p.@last.next = node
            @p.last = node
            Incr @p.count
        End If
    End If
End Sub


Function CuQuePeek(ByVal p As CuQue Ptr) As Currency
    'get first value in queue
    ExitF(p=0 Or @p.tag<>CuQueTag, LibErrH)
    If @p.count Then
        ExitF(@p.first=0, LibErrU)
        Function = @p.@first.arr(@p.@first.first)
    End If
End Function

Function CuQuePop(ByVal p As CuQue Ptr) As Currency
    'get and remove first value in queue
    Local node As CuQueNode Ptr
    ExitF(p=0 Or @p.tag<>CuQueTag, LibErrH)
    If @p.count Then
        ExitF(@p.first=0, LibErrU)
        Function = @p.@first.arr(@p.@first.first)
        Decr @p.count
        If @p.count = 0 Then
            CuQueClear p
        Else
            Incr @p.@first.first
            If @p.@first.first > @p.@first.last Then
                node = @p.first
                @p.first = @p.@first.next
                MemFree(node)
            End If
        End If
    End If
End Function
