#Include This Once
#Include Once "C:\HLib3\HLib.inc"

'++
    '----------------------------------------------------------------------------------------
    '   Double Queue Container
    '       extremely fast, memory efficient and CPU Cache friendly Queue implementation
    '       - each node has a fixed array of 500 items
    '       - memory allocation and deallocation only takes place every 500'th item
    '       - CPU Cache loves small arrays
    '       - way more efficient for small data types; Byte, Integer, Word, ...
    '
    '       container accessed with handle
    '       handle protected by hash tag
    '       h = DbQueNew() 'get handle for new container
    '       h = DbQueFinal(h) 'free handle before it goes out of scope
    '----------------------------------------------------------------------------------------
'--

Macro DbQueTag = -252380731
Type DbQueNode
    next As DbQueNode Ptr
    first As Long
    last As Long
    arr(1 To %QueMax) As Double
End Type
Type DbQue
    tag As Long
    count As Long
    first As DbQueNode Ptr
    last As DbQueNode Ptr
End Type

Function DbQueNew() As Long
    'allocate new container - return handle
    Local p As DbQue Ptr
    p = MemAlloc(SizeOf(@p))
    ExitF(p=0, LibErrM)
    @p.tag = DbQueTag
    Function = p
End Function

Function DbQueFinal(ByVal p As DbQue Ptr) As Long
    'free allocated container - return null
    If p Then
        ExitF(@p.tag<>DbQueTag, LibErrH)
        DbQueClear p
        MemFree(p)
    End If
End Function

Function DbQueValidate(ByVal p As DbQue Ptr) As Long
    'True/False if valid handle for this container
    If p And @p.tag = DbQueTag Then Function = @p.tag
End Function

Sub DbQueClear(ByVal p As DbQue Ptr)
    'delete all data
    Local node As DbQueNode Ptr
    ExitS(p=0 Or @p.tag<>DbQueTag, LibErrH)
    While @p.first
        node = @p.first
        @p.first = @node.next
        MemFree(node)
    Wend
    @p.first = 0
    @p.last = 0
    @p.count = 0
End Sub

Function DbQueCount(ByVal p As DbQue Ptr) As Long
    'get item count
    ExitF(p=0 Or @p.tag<>DbQueTag, LibErrH)
    Function = @p.count
End Function

Sub DbQuePush(ByVal p As DbQue Ptr, ByVal value As Double)
    'add value to end of queue
    Local node As DbQueNode Ptr
    ExitS(p=0 Or @p.tag<>DbQueTag, LibErrH)
    If @p.count = 0 Then
        @p.last = MemAlloc(SizeOf(DbQueNode))
        ExitS(@p.last=0, LibErrM)
        @p.@last.arr(1) = value
        @p.@last.first = 1
        @p.@last.last = 1
        @p.first = @p.last
        @p.count = 1
    Else
        ExitS(@p.last=0, LibErrU)
        If @p.@last.last < %QueMax Then
            Incr @p.@last.last
            @p.@last.arr(@p.@last.last) = value
            Incr @p.count
        Else
            node = MemAlloc(SizeOf(DbQueNode))
            ExitS(node=0, LibErrM)
            @node.arr(1) = value
            @node.first = 1
            @node.last = 1
            @p.@last.next = node
            @p.last = node
            Incr @p.count
        End If
    End If
End Sub


Function DbQuePeek(ByVal p As DbQue Ptr) As Double
    'get first value in queue
    ExitF(p=0 Or @p.tag<>DbQueTag, LibErrH)
    If @p.count Then
        ExitF(@p.first=0, LibErrU)
        Function = @p.@first.arr(@p.@first.first)
    End If
End Function

Function DbQuePop(ByVal p As DbQue Ptr) As Double
    'get and remove first value in queue
    Local node As DbQueNode Ptr
    ExitF(p=0 Or @p.tag<>DbQueTag, LibErrH)
    If @p.count Then
        ExitF(@p.first=0, LibErrU)
        Function = @p.@first.arr(@p.@first.first)
        Decr @p.count
        If @p.count = 0 Then
            DbQueClear p
        Else
            Incr @p.@first.first
            If @p.@first.first > @p.@first.last Then
                node = @p.first
                @p.first = @p.@first.next
                MemFree(node)
            End If
        End If
    End If
End Function
