#Include This Once
#Include Once "C:\HLib3\HLib.inc"

'++
    '----------------------------------------------------------------------------------------
    '   Word Queue Container
    '       extremely fast, memory efficient and CPU Cache friendly Queue implementation
    '       - each node has a fixed array of 500 items
    '       - memory allocation and deallocation only takes place every 500'th item
    '       - CPU Cache loves small arrays
    '       - way more efficient for small data types; Byte, Integer, Word, ...
    '
    '       container accessed with handle
    '       handle protected by hash tag
    '       h = WdQueNew() 'get handle for new container
    '       h = WdQueFinal(h) 'free handle before it goes out of scope
    '----------------------------------------------------------------------------------------
'--

Macro WdQueTag = -1501197570
Type WdQueNode
    next As WdQueNode Ptr
    first As Long
    last As Long
    arr(1 To %QueMax) As Word
End Type
Type WdQue
    tag As Long
    count As Long
    first As WdQueNode Ptr
    last As WdQueNode Ptr
End Type

Function WdQueNew() As Long
    'allocate new container - return handle
    Local p As WdQue Ptr
    p = MemAlloc(SizeOf(@p))
    ExitF(p=0, LibErrM)
    @p.tag = WdQueTag
    Function = p
End Function

Function WdQueFinal(ByVal p As WdQue Ptr) As Long
    'free allocated container - return null
    If p Then
        ExitF(@p.tag<>WdQueTag, LibErrH)
        WdQueClear p
        MemFree(p)
    End If
End Function

Function WdQueValidate(ByVal p As WdQue Ptr) As Long
    'True/False if valid handle for this container
    If p And @p.tag = WdQueTag Then Function = @p.tag
End Function

Sub WdQueClear(ByVal p As WdQue Ptr)
    'delete all data
    Local node As WdQueNode Ptr
    ExitS(p=0 Or @p.tag<>WdQueTag, LibErrH)
    While @p.first
        node = @p.first
        @p.first = @node.next
        MemFree(node)
    Wend
    @p.first = 0
    @p.last = 0
    @p.count = 0
End Sub

Function WdQueCount(ByVal p As WdQue Ptr) As Long
    'get item count
    ExitF(p=0 Or @p.tag<>WdQueTag, LibErrH)
    Function = @p.count
End Function

Sub WdQuePush(ByVal p As WdQue Ptr, ByVal value As Word)
    'add value to end of queue
    Local node As WdQueNode Ptr
    ExitS(p=0 Or @p.tag<>WdQueTag, LibErrH)
    If @p.count = 0 Then
        @p.last = MemAlloc(SizeOf(WdQueNode))
        ExitS(@p.last=0, LibErrM)
        @p.@last.arr(1) = value
        @p.@last.first = 1
        @p.@last.last = 1
        @p.first = @p.last
        @p.count = 1
    Else
        ExitS(@p.last=0, LibErrU)
        If @p.@last.last < %QueMax Then
            Incr @p.@last.last
            @p.@last.arr(@p.@last.last) = value
            Incr @p.count
        Else
            node = MemAlloc(SizeOf(WdQueNode))
            ExitS(node=0, LibErrM)
            @node.arr(1) = value
            @node.first = 1
            @node.last = 1
            @p.@last.next = node
            @p.last = node
            Incr @p.count
        End If
    End If
End Sub


Function WdQuePeek(ByVal p As WdQue Ptr) As Word
    'get first value in queue
    ExitF(p=0 Or @p.tag<>WdQueTag, LibErrH)
    If @p.count Then
        ExitF(@p.first=0, LibErrU)
        Function = @p.@first.arr(@p.@first.first)
    End If
End Function

Function WdQuePop(ByVal p As WdQue Ptr) As Word
    'get and remove first value in queue
    Local node As WdQueNode Ptr
    ExitF(p=0 Or @p.tag<>WdQueTag, LibErrH)
    If @p.count Then
        ExitF(@p.first=0, LibErrU)
        Function = @p.@first.arr(@p.@first.first)
        Decr @p.count
        If @p.count = 0 Then
            WdQueClear p
        Else
            Incr @p.@first.first
            If @p.@first.first > @p.@first.last Then
                node = @p.first
                @p.first = @p.@first.next
                MemFree(node)
            End If
        End If
    End If
End Function
