#Include This Once
#Include Once "C:\HLib3\List\BtLst.inc"

'++
    '----------------------------------------------------------------------------------------
    '   Byte Stack Container
    '       extremely fast, memory efficient and CPU Cache friendly Stack implementation
    '       - each node has a fixed array of 500 items
    '       - memory allocation and deallocation only takes place every 500'th item
    '       - CPU Cache loves small arrays
    '       - way more efficient for small data types; Byte, Integer, Word, ...
    '
    '       container accessed with handle
    '       handle protected by hash tag
    '       h = BtStkNew() 'get handle for new container
    '       h = BtStkFinal(h) 'free handle before it goes out of scope
    '----------------------------------------------------------------------------------------
'--

Macro BtStkTag = -274384610
Type BtStkNode
    prev As BtStkNode Ptr
    index As Long
    arr(1 To %StkMax) As Byte
End Type
Type BtStk
    tag As Long
    count As Long
    top As BtStkNode Ptr
End Type

Function BtStkNew() As Long
    'allocate new container - return handle
    Local p As BtStk Ptr
    p = MemAlloc(SizeOf(@p))
    ExitF(p=0, LibErrM)
    @p.tag = BtStkTag
    Function = p
End Function

Function BtStkFinal(ByVal p As BtStk Ptr) As Long
    'free allocated container - return null - Modifies Container Data
    If p Then
        ExitF(@p.tag<>BtStkTag, LibErrH)
        BtStkClear p
        MemFree(p)
    End If
End Function

Function BtStkValidate(ByVal p As BtStk Ptr) As Long
    'True/False if valid handle for this container
    If p And @p.tag = BtStkTag Then Function = @p.tag
End Function

Sub BtStkClear(ByVal p As BtStk Ptr)
    'delete all data - Modifies Container Data
    Local node As BtStkNode Ptr
    ExitS(p=0 Or @p.tag<>BtStkTag, LibErrH)
    While @p.top
        node = @p.top
        @p.top = @node.prev
        MemFree(node)
    Wend
    @p.top = 0
    @p.count = 0
End Sub

Function BtStkCount(ByVal p As BtStk Ptr) As Long
    'get item count
    ExitF(p=0 Or @p.tag<>BtStkTag, LibErrH)
    Function = @p.count
End Function

Sub BtStkPush(ByVal p As BtStk Ptr, ByVal value As Byte)
    'push value on top of stack
    Local node As BtStkNode Ptr
    ExitS(p=0 Or @p.tag<>BtStkTag, LibErrH)
    If @p.count = 0 Then
        @p.top = MemAlloc(SizeOf(BtStkNode))
        ExitS(@p.top=0, LibErrM)
        @p.@top.arr(1) = value
        @p.@top.index = 1
        @p.count = 1
    ElseIf @p.@top.index < %StkMax Then
        Incr @p.@top.index
        @p.@top.arr(@p.@top.index) = value
        Incr @p.count
    Else
        node = MemAlloc(SizeOf(BtStkNode))
        ExitS(node=0, LibErrM)
        @node.arr(1) = value
        @node.index = 1
        @node.prev = @p.top
        @p.top = node
        Incr @p.count
    End If
End Sub

Function BtStkPeek(ByVal p As BtStk Ptr) As Byte
    'get top value on stack
    ExitF(p=0 Or @p.tag<>BtStkTag, LibErrH)
    If @p.count Then Function = @p.@top.arr(@p.@top.index)
End Function

Function BtStkPop(ByVal p As BtStk Ptr) As Byte
    'get and remove top value on stack
    Local node As BtStkNode Ptr
    ExitF(p=0 Or @p.tag<>BtStkTag, LibErrH)
    If @p.count Then
        Function = @p.@top.arr(@p.@top.index)
        Decr @p.@top.index
        Decr @p.count
        If @p.@top.index = 0 Then
            node = @p.top
            @p.top = @p.@top.prev
            MemFree(node)
        End If
    End If
End Function
