#Include This Once
#Include Once "C:\HLib3\List\CuLst.inc"

'++
    '----------------------------------------------------------------------------------------
    '   Currency Stack Container
    '       extremely fast, memory efficient and CPU Cache friendly Stack implementation
    '       - each node has a fixed array of 500 items
    '       - memory allocation and deallocation only takes place every 500'th item
    '       - CPU Cache loves small arrays
    '       - way more efficient for small data types; Byte, Integer, Word, ...
    '
    '       container accessed with handle
    '       handle protected by hash tag
    '       h = CuStkNew() 'get handle for new container
    '       h = CuStkFinal(h) 'free handle before it goes out of scope
    '----------------------------------------------------------------------------------------
'--

Macro CuStkTag = -417758617
Type CuStkNode
    prev As CuStkNode Ptr
    index As Long
    arr(1 To %StkMax) As Currency
End Type
Type CuStk
    tag As Long
    count As Long
    top As CuStkNode Ptr
End Type

Function CuStkNew() As Long
    'allocate new container - return handle
    Local p As CuStk Ptr
    p = MemAlloc(SizeOf(@p))
    ExitF(p=0, LibErrM)
    @p.tag = CuStkTag
    Function = p
End Function

Function CuStkFinal(ByVal p As CuStk Ptr) As Long
    'free allocated container - return null - Modifies Container Data
    If p Then
        ExitF(@p.tag<>CuStkTag, LibErrH)
        CuStkClear p
        MemFree(p)
    End If
End Function

Function CuStkValidate(ByVal p As CuStk Ptr) As Long
    'True/False if valid handle for this container
    If p And @p.tag = CuStkTag Then Function = @p.tag
End Function

Sub CuStkClear(ByVal p As CuStk Ptr)
    'delete all data - Modifies Container Data
    Local node As CuStkNode Ptr
    ExitS(p=0 Or @p.tag<>CuStkTag, LibErrH)
    While @p.top
        node = @p.top
        @p.top = @node.prev
        MemFree(node)
    Wend
    @p.top = 0
    @p.count = 0
End Sub

Function CuStkCount(ByVal p As CuStk Ptr) As Long
    'get item count
    ExitF(p=0 Or @p.tag<>CuStkTag, LibErrH)
    Function = @p.count
End Function

Sub CuStkPush(ByVal p As CuStk Ptr, ByVal value As Currency)
    'push value on top of stack
    Local node As CuStkNode Ptr
    ExitS(p=0 Or @p.tag<>CuStkTag, LibErrH)
    If @p.count = 0 Then
        @p.top = MemAlloc(SizeOf(CuStkNode))
        ExitS(@p.top=0, LibErrM)
        @p.@top.arr(1) = value
        @p.@top.index = 1
        @p.count = 1
    ElseIf @p.@top.index < %StkMax Then
        Incr @p.@top.index
        @p.@top.arr(@p.@top.index) = value
        Incr @p.count
    Else
        node = MemAlloc(SizeOf(CuStkNode))
        ExitS(node=0, LibErrM)
        @node.arr(1) = value
        @node.index = 1
        @node.prev = @p.top
        @p.top = node
        Incr @p.count
    End If
End Sub

Function CuStkPeek(ByVal p As CuStk Ptr) As Currency
    'get top value on stack
    ExitF(p=0 Or @p.tag<>CuStkTag, LibErrH)
    If @p.count Then Function = @p.@top.arr(@p.@top.index)
End Function

Function CuStkPop(ByVal p As CuStk Ptr) As Currency
    'get and remove top value on stack
    Local node As CuStkNode Ptr
    ExitF(p=0 Or @p.tag<>CuStkTag, LibErrH)
    If @p.count Then
        Function = @p.@top.arr(@p.@top.index)
        Decr @p.@top.index
        Decr @p.count
        If @p.@top.index = 0 Then
            node = @p.top
            @p.top = @p.@top.prev
            MemFree(node)
        End If
    End If
End Function
