#Include This Once
#Include Once "C:\HLib3\List\DwLst.inc"

'++
    '----------------------------------------------------------------------------------------
    '   Dword Stack Container
    '       extremely fast, memory efficient and CPU Cache friendly Stack implementation
    '       - each node has a fixed array of 500 items
    '       - memory allocation and deallocation only takes place every 500'th item
    '       - CPU Cache loves small arrays
    '       - way more efficient for small data types; Byte, Integer, Word, ...
    '
    '       container accessed with handle
    '       handle protected by hash tag
    '       h = DwStkNew() 'get handle for new container
    '       h = DwStkFinal(h) 'free handle before it goes out of scope
    '----------------------------------------------------------------------------------------
'--

Macro DwStkTag = -252380731
Type DwStkNode
    prev As DwStkNode Ptr
    index As Long
    arr(1 To %StkMax) As Dword
End Type
Type DwStk
    tag As Long
    count As Long
    top As DwStkNode Ptr
End Type

Function DwStkNew() As Long
    'allocate new container - return handle
    Local p As DwStk Ptr
    p = MemAlloc(SizeOf(@p))
    ExitF(p=0, LibErrM)
    @p.tag = DwStkTag
    Function = p
End Function

Function DwStkFinal(ByVal p As DwStk Ptr) As Long
    'free allocated container - return null - Modifies Container Data
    If p Then
        ExitF(@p.tag<>DwStkTag, LibErrH)
        DwStkClear p
        MemFree(p)
    End If
End Function

Function DwStkValidate(ByVal p As DwStk Ptr) As Long
    'True/False if valid handle for this container
    If p And @p.tag = DwStkTag Then Function = @p.tag
End Function

Sub DwStkClear(ByVal p As DwStk Ptr)
    'delete all data - Modifies Container Data
    Local node As DwStkNode Ptr
    ExitS(p=0 Or @p.tag<>DwStkTag, LibErrH)
    While @p.top
        node = @p.top
        @p.top = @node.prev
        MemFree(node)
    Wend
    @p.top = 0
    @p.count = 0
End Sub

Function DwStkCount(ByVal p As DwStk Ptr) As Long
    'get item count
    ExitF(p=0 Or @p.tag<>DwStkTag, LibErrH)
    Function = @p.count
End Function

Sub DwStkPush(ByVal p As DwStk Ptr, ByVal value As Dword)
    'push value on top of stack
    Local node As DwStkNode Ptr
    ExitS(p=0 Or @p.tag<>DwStkTag, LibErrH)
    If @p.count = 0 Then
        @p.top = MemAlloc(SizeOf(DwStkNode))
        ExitS(@p.top=0, LibErrM)
        @p.@top.arr(1) = value
        @p.@top.index = 1
        @p.count = 1
    ElseIf @p.@top.index < %StkMax Then
        Incr @p.@top.index
        @p.@top.arr(@p.@top.index) = value
        Incr @p.count
    Else
        node = MemAlloc(SizeOf(DwStkNode))
        ExitS(node=0, LibErrM)
        @node.arr(1) = value
        @node.index = 1
        @node.prev = @p.top
        @p.top = node
        Incr @p.count
    End If
End Sub

Function DwStkPeek(ByVal p As DwStk Ptr) As Dword
    'get top value on stack
    ExitF(p=0 Or @p.tag<>DwStkTag, LibErrH)
    If @p.count Then Function = @p.@top.arr(@p.@top.index)
End Function

Function DwStkPop(ByVal p As DwStk Ptr) As Dword
    'get and remove top value on stack
    Local node As DwStkNode Ptr
    ExitF(p=0 Or @p.tag<>DwStkTag, LibErrH)
    If @p.count Then
        Function = @p.@top.arr(@p.@top.index)
        Decr @p.@top.index
        Decr @p.count
        If @p.@top.index = 0 Then
            node = @p.top
            @p.top = @p.@top.prev
            MemFree(node)
        End If
    End If
End Function
