#Include This Once
#Include Once "C:\HLib3\List\ExLst.inc"

'++
    '----------------------------------------------------------------------------------------
    '   Extended Stack Container
    '       extremely fast, memory efficient and CPU Cache friendly Stack implementation
    '       - each node has a fixed array of 500 items
    '       - memory allocation and deallocation only takes place every 500'th item
    '       - CPU Cache loves small arrays
    '       - way more efficient for small data types; Byte, Integer, Word, ...
    '
    '       container accessed with handle
    '       handle protected by hash tag
    '       h = ExStkNew() 'get handle for new container
    '       h = ExStkFinal(h) 'free handle before it goes out of scope
    '----------------------------------------------------------------------------------------
'--

Macro ExStkTag = -264589208
Type ExStkNode
    prev As ExStkNode Ptr
    index As Long
    arr(1 To %StkMax) As Extended
End Type
Type ExStk
    tag As Long
    count As Long
    top As ExStkNode Ptr
End Type

Function ExStkNew() As Long
    'allocate new container - return handle
    Local p As ExStk Ptr
    p = MemAlloc(SizeOf(@p))
    ExitF(p=0, LibErrM)
    @p.tag = ExStkTag
    Function = p
End Function

Function ExStkFinal(ByVal p As ExStk Ptr) As Long
    'free allocated container - return null - Modifies Container Data
    If p Then
        ExitF(@p.tag<>ExStkTag, LibErrH)
        ExStkClear p
        MemFree(p)
    End If
End Function

Function ExStkValidate(ByVal p As ExStk Ptr) As Long
    'True/False if valid handle for this container
    If p And @p.tag = ExStkTag Then Function = @p.tag
End Function

Sub ExStkClear(ByVal p As ExStk Ptr)
    'delete all data - Modifies Container Data
    Local node As ExStkNode Ptr
    ExitS(p=0 Or @p.tag<>ExStkTag, LibErrH)
    While @p.top
        node = @p.top
        @p.top = @node.prev
        MemFree(node)
    Wend
    @p.top = 0
    @p.count = 0
End Sub

Function ExStkCount(ByVal p As ExStk Ptr) As Long
    'get item count
    ExitF(p=0 Or @p.tag<>ExStkTag, LibErrH)
    Function = @p.count
End Function

Sub ExStkPush(ByVal p As ExStk Ptr, ByVal value As Extended)
    'push value on top of stack
    Local node As ExStkNode Ptr
    ExitS(p=0 Or @p.tag<>ExStkTag, LibErrH)
    If @p.count = 0 Then
        @p.top = MemAlloc(SizeOf(ExStkNode))
        ExitS(@p.top=0, LibErrM)
        @p.@top.arr(1) = value
        @p.@top.index = 1
        @p.count = 1
    ElseIf @p.@top.index < %StkMax Then
        Incr @p.@top.index
        @p.@top.arr(@p.@top.index) = value
        Incr @p.count
    Else
        node = MemAlloc(SizeOf(ExStkNode))
        ExitS(node=0, LibErrM)
        @node.arr(1) = value
        @node.index = 1
        @node.prev = @p.top
        @p.top = node
        Incr @p.count
    End If
End Sub

Function ExStkPeek(ByVal p As ExStk Ptr) As Extended
    'get top value on stack
    ExitF(p=0 Or @p.tag<>ExStkTag, LibErrH)
    If @p.count Then Function = @p.@top.arr(@p.@top.index)
End Function

Function ExStkPop(ByVal p As ExStk Ptr) As Extended
    'get and remove top value on stack
    Local node As ExStkNode Ptr
    ExitF(p=0 Or @p.tag<>ExStkTag, LibErrH)
    If @p.count Then
        Function = @p.@top.arr(@p.@top.index)
        Decr @p.@top.index
        Decr @p.count
        If @p.@top.index = 0 Then
            node = @p.top
            @p.top = @p.@top.prev
            MemFree(node)
        End If
    End If
End Function
