#Include This Once
#Include Once "C:\HLib3\List\LnLst.inc"

'++
    '----------------------------------------------------------------------------------------
    '   Long Stack Container
    '       extremely fast, memory efficient and CPU Cache friendly Stack implementation
    '       - each node has a fixed array of 500 items
    '       - memory allocation and deallocation only takes place every 500'th item
    '       - CPU Cache loves small arrays
    '       - way more efficient for small data types; Byte, Integer, Word, ...
    '
    '       container accessed with handle
    '       handle protected by hash tag
    '       h = LnStkNew() 'get handle for new container
    '       h = LnStkFinal(h) 'free handle before it goes out of scope
    '----------------------------------------------------------------------------------------
'--

Macro LnStkTag = 466671818
Type LnStkNode
    prev As LnStkNode Ptr
    index As Long
    arr(1 To %StkMax) As Long
End Type
Type LnStk
    tag As Long
    count As Long
    top As LnStkNode Ptr
End Type

Function LnStkNew() As Long
    'allocate new container - return handle
    Local p As LnStk Ptr
    p = MemAlloc(SizeOf(@p))
    ExitF(p=0, LibErrM)
    @p.tag = LnStkTag
    Function = p
End Function

Function LnStkFinal(ByVal p As LnStk Ptr) As Long
    'free allocated container - return null - Modifies Container Data
    If p Then
        ExitF(@p.tag<>LnStkTag, LibErrH)
        LnStkClear p
        MemFree(p)
    End If
End Function

Function LnStkValidate(ByVal p As LnStk Ptr) As Long
    'True/False if valid handle for this container
    If p And @p.tag = LnStkTag Then Function = @p.tag
End Function

Sub LnStkClear(ByVal p As LnStk Ptr)
    'delete all data - Modifies Container Data
    Local node As LnStkNode Ptr
    ExitS(p=0 Or @p.tag<>LnStkTag, LibErrH)
    While @p.top
        node = @p.top
        @p.top = @node.prev
        MemFree(node)
    Wend
    @p.top = 0
    @p.count = 0
End Sub

Function LnStkCount(ByVal p As LnStk Ptr) As Long
    'get item count
    ExitF(p=0 Or @p.tag<>LnStkTag, LibErrH)
    Function = @p.count
End Function

Sub LnStkPush(ByVal p As LnStk Ptr, ByVal value As Long)
    'push value on top of stack
    Local node As LnStkNode Ptr
    ExitS(p=0 Or @p.tag<>LnStkTag, LibErrH)
    If @p.count = 0 Then
        @p.top = MemAlloc(SizeOf(LnStkNode))
        ExitS(@p.top=0, LibErrM)
        @p.@top.arr(1) = value
        @p.@top.index = 1
        @p.count = 1
    ElseIf @p.@top.index < %StkMax Then
        Incr @p.@top.index
        @p.@top.arr(@p.@top.index) = value
        Incr @p.count
    Else
        node = MemAlloc(SizeOf(LnStkNode))
        ExitS(node=0, LibErrM)
        @node.arr(1) = value
        @node.index = 1
        @node.prev = @p.top
        @p.top = node
        Incr @p.count
    End If
End Sub

Function LnStkPeek(ByVal p As LnStk Ptr) As Long
    'get top value on stack
    ExitF(p=0 Or @p.tag<>LnStkTag, LibErrH)
    If @p.count Then Function = @p.@top.arr(@p.@top.index)
End Function

Function LnStkPop(ByVal p As LnStk Ptr) As Long
    'get and remove top value on stack
    Local node As LnStkNode Ptr
    ExitF(p=0 Or @p.tag<>LnStkTag, LibErrH)
    If @p.count Then
        Function = @p.@top.arr(@p.@top.index)
        Decr @p.@top.index
        Decr @p.count
        If @p.@top.index = 0 Then
            node = @p.top
            @p.top = @p.@top.prev
            MemFree(node)
        End If
    End If
End Function
