#Include This Once
#Include Once "C:\HLib3\List\QdLst.inc"

'++
    '----------------------------------------------------------------------------------------
    '   Quad Stack Container
    '       extremely fast, memory efficient and CPU Cache friendly Stack implementation
    '       - each node has a fixed array of 500 items
    '       - memory allocation and deallocation only takes place every 500'th item
    '       - CPU Cache loves small arrays
    '       - way more efficient for small data types; Byte, Integer, Word, ...
    '
    '       container accessed with handle
    '       handle protected by hash tag
    '       h = QdStkNew() 'get handle for new container
    '       h = QdStkFinal(h) 'free handle before it goes out of scope
    '----------------------------------------------------------------------------------------
'--

Macro QdStkTag = 1012397857
Type QdStkNode
    prev As QdStkNode Ptr
    index As Long
    arr(1 To %StkMax) As Quad
End Type
Type QdStk
    tag As Long
    count As Long
    top As QdStkNode Ptr
End Type

Function QdStkNew() As Long
    'allocate new container - return handle
    Local p As QdStk Ptr
    p = MemAlloc(SizeOf(@p))
    ExitF(p=0, LibErrM)
    @p.tag = QdStkTag
    Function = p
End Function

Function QdStkFinal(ByVal p As QdStk Ptr) As Long
    'free allocated container - return null - Modifies Container Data
    If p Then
        ExitF(@p.tag<>QdStkTag, LibErrH)
        QdStkClear p
        MemFree(p)
    End If
End Function

Function QdStkValidate(ByVal p As QdStk Ptr) As Long
    'True/False if valid handle for this container
    If p And @p.tag = QdStkTag Then Function = @p.tag
End Function

Sub QdStkClear(ByVal p As QdStk Ptr)
    'delete all data - Modifies Container Data
    Local node As QdStkNode Ptr
    ExitS(p=0 Or @p.tag<>QdStkTag, LibErrH)
    While @p.top
        node = @p.top
        @p.top = @node.prev
        MemFree(node)
    Wend
    @p.top = 0
    @p.count = 0
End Sub

Function QdStkCount(ByVal p As QdStk Ptr) As Long
    'get item count
    ExitF(p=0 Or @p.tag<>QdStkTag, LibErrH)
    Function = @p.count
End Function

Sub QdStkPush(ByVal p As QdStk Ptr, ByVal value As Quad)
    'push value on top of stack
    Local node As QdStkNode Ptr
    ExitS(p=0 Or @p.tag<>QdStkTag, LibErrH)
    If @p.count = 0 Then
        @p.top = MemAlloc(SizeOf(QdStkNode))
        ExitS(@p.top=0, LibErrM)
        @p.@top.arr(1) = value
        @p.@top.index = 1
        @p.count = 1
    ElseIf @p.@top.index < %StkMax Then
        Incr @p.@top.index
        @p.@top.arr(@p.@top.index) = value
        Incr @p.count
    Else
        node = MemAlloc(SizeOf(QdStkNode))
        ExitS(node=0, LibErrM)
        @node.arr(1) = value
        @node.index = 1
        @node.prev = @p.top
        @p.top = node
        Incr @p.count
    End If
End Sub

Function QdStkPeek(ByVal p As QdStk Ptr) As Quad
    'get top value on stack
    ExitF(p=0 Or @p.tag<>QdStkTag, LibErrH)
    If @p.count Then Function = @p.@top.arr(@p.@top.index)
End Function

Function QdStkPop(ByVal p As QdStk Ptr) As Quad
    'get and remove top value on stack
    Local node As QdStkNode Ptr
    ExitF(p=0 Or @p.tag<>QdStkTag, LibErrH)
    If @p.count Then
        Function = @p.@top.arr(@p.@top.index)
        Decr @p.@top.index
        Decr @p.count
        If @p.@top.index = 0 Then
            node = @p.top
            @p.top = @p.@top.prev
            MemFree(node)
        End If
    End If
End Function
