'WStringInUDT.bas
#Dim All
#Compile Exe
#Include Once "WIN32API.INC"
#Include Once "..\WsStr.inc"

Macro lbxID = 1000
Macro btnID = 1001

Type TestT
    s1 As Long
    s2 As Long
End Type

CallBack Function BtnCB()
    Local i As Long
    Threaded t As TestT

    ListBox Reset CbHndl, lbxID

    'must allocate handles before use
    t.s1 = WsNew()
    t.s2 = WsNew()

    'set strings
    WsSet t.s1, "This is String #1"
    WsSet t.s2, "And this is String #2"

    'get strings
    ListBox Add CbHndl, lbxID, $Dq + WsGet(t.s1) + $Dq
    ListBox Add CbHndl, lbxID, $Dq + WsGet(t.s2) + $Dq

    'string length
    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "String Length #1 = " + Format$(WsCount(t.s1))
    ListBox Add CbHndl, lbxID, "String Length #2 = " + Format$(WsCount(t.s2))

    'must free handles before they go out of scope
    t.s1 = WsFinal(t.s1)
    t.s2 = WsFinal(t.s2)

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "done..."
End Function

Function PBMain()
    Local hDlg As Long
    Dialog New 0, "WStringInUDT", 67, 61, 341, 241, %WS_Caption Or %WS_ClipSiblings Or %WS_MinimizeBox Or %WS_SysMenu, %WS_Ex_AppWindow To hDlg
    Control Add ListBox, hDlg, lbxID, , 5, 5, 330, 210, %WS_Child Or %WS_HScroll Or %WS_VScroll Or %LBS_Notify Or %LBS_NoIntegralHeight, %WS_Ex_ClientEdge
    Control Add Button,  hDlg, btnID, "Test", 275, 220, 60, 15 Call BtnCB()
    Dialog Show Modal hDlg, Call DlgCB
End Function

CallBack Function DlgCB()
End Function
