#INCLUDE THIS ONCE
#INCLUDE ONCE "..\HLib3\HLib.inc"

'++
    '----------------------------------------------------------------------------------------
    '   String Buffer Container
    '
    '   container accessed with handle
    '   handle protected by hash tag
    '   h = SsNew() 'get handle for new container
    '   h = SsFinal(h) 'free handle before it goes out of scope
    '----------------------------------------------------------------------------------------
'--

MACRO SsTag = -445588383
TYPE SsStr
    tag AS LONG
    count AS LONG
    mem AS BYTE PTR
END TYPE

DECLARE FUNCTION SsCompareCB(BYVAL pa AS SsStr PTR, BYVAL pb AS SsStr PTR, BYVAL pCollation AS SsStr PTR) AS LONG

FUNCTION SsNew() AS LONG
    'allocate new container - return handle
    LOCAL p AS SsStr PTR
    p = MemAlloc(SIZEOF(@p))
    ExitF(p=0, LibErrM)
    @p.tag = SsTag
    FUNCTION = p
END FUNCTION

FUNCTION SsFinal(BYVAL p AS SsStr PTR) AS LONG
    'free allocated container - return null - container can't be Read Locked
    IF p THEN
        ExitF(@p.tag<>SsTag, LibErrH)
        SsClear p
        MemFree(p)
    END IF
END FUNCTION

FUNCTION SsValidate(BYVAL p AS SsStr PTR) AS LONG
    'True/False if valid handle for this container
    IF p AND @p.tag = SsTag THEN FUNCTION = @p.tag
END FUNCTION

SUB SsClear(BYVAL p AS SsStr PTR)
    'delete all data - container can't be Read Locked
    ExitS(p=0 OR @p.tag<>SsTag, LibErrH)
    @p.count = 0
    @p.mem = MemFree(@p.mem)
END SUB

FUNCTION SsCount(BYVAL p AS SsStr PTR) AS LONG
    'get item count (number of characters)
    ExitF(p=0 OR @p.tag<>SsTag, LibErrH)
    FUNCTION = @p.count
END FUNCTION

FUNCTION SsGet(BYVAL p AS SsStr PTR) AS STRING
    'get String
    ExitF(p=0 OR @p.tag<>SsTag, LibErrH)
    IF @p.count THEN FUNCTION = PEEK$(@p.mem, @p.count)
END FUNCTION

SUB SsSet(BYVAL p AS SsStr PTR, BYREF value AS STRING)
    'set String - container can't be Read Locked
    LOCAL strLen AS LONG : strLen = LEN(value)
    ExitS(p=0 OR @p.tag<>SsTag, LibErrH)
    @p.count = 0
    IF @p.mem THEN @p.mem = MemFree(@p.mem)
    IF strLen THEN
        @p.mem = MemAlloc(strLen + 1)
        ExitS(@p.mem=0, LibErrM)
        @p.count = strLen
        POKE$ @p.mem, value
    END IF
END SUB

FUNCTION SsSetNew(BYREF value AS STRING) AS LONG
    'allocate and set new string buffer container - return handle
    LOCAL h AS LONG
    h = SsNew()
    IF h THEN SsSet h, value
    FUNCTION = h
END FUNCTION

FUNCTION SsCompare(BYVAL pa AS SsStr PTR, BYVAL pb AS SsStr PTR, BYVAL pCollation AS SsStr PTR) PRIVATE AS LONG
    LOCAL i, compare, TOP AS LONG
    IF pa AND pb AND @pa.tag=SsTag AND @pb.tag=SsTag THEN
        IF @pa.count < @pb.count THEN TOP = @pa.count ELSE TOP = @pb.count
        FOR i = 0 TO TOP - 1
            compare = @pa.@mem[i] - @pb.@mem[i]
            IF compare THEN
                FUNCTION = compare : EXIT FUNCTION
            END IF
        NEXT i
        FUNCTION = @pa.count - @pb.count
    ELSE
        ExitLogErr(LibErrH)
    END IF
END FUNCTION

FUNCTION SsCompareUCase(BYVAL pa AS SsStr PTR, BYVAL pb AS SsStr PTR, BYVAL pCollation AS SsStr PTR) PRIVATE AS LONG
    LOCAL ca, cb, i, compare, TOP AS LONG
    IF pa AND pb AND @pa.tag=SsTag AND @pb.tag=SsTag THEN
        IF @pa.count < @pb.count THEN TOP = @pa.count ELSE TOP = @pb.count
        FOR i = 0 TO TOP - 1
            ca = @pa.@mem[i]
            cb = @pb.@mem[i]
            IF cA > 96 AND cA < 123 THEN cA -= 32
            IF cB > 96 AND cB < 123 THEN cB -= 32
            compare = ca - cb
            IF compare THEN
                FUNCTION = compare : EXIT FUNCTION
            END IF
        NEXT i
        FUNCTION = @pa.count - @pb.count
    ELSE
        ExitLogErr(LibErrH)
    END IF
END FUNCTION

FUNCTION SsCompareCollate(BYVAL pa AS SsStr PTR, BYVAL pb AS SsStr PTR, BYVAL pCollation AS SsStr PTR) PRIVATE AS LONG
    LOCAL i, compare, TOP AS LONG
    IF pa AND pb AND pCollation AND @pa.tag=SsTag AND @pb.tag=SsTag AND @pCollation.tag=SsTag THEN
        IF @pa.count < @pb.count THEN TOP = @pa.count ELSE TOP = @pb.count
        FOR i = 0 TO TOP - 1
            compare = @pCollation.@mem[@pa.@mem[i]] - @pCollation.@mem[@pb.@mem[i]]
            IF compare THEN
                FUNCTION = compare : EXIT FUNCTION
            END IF
        NEXT i
        FUNCTION = @pa.count - @pb.count
    ELSE
        ExitLogErr(LibErrH)
    END IF
END FUNCTION

MACRO FUNCTION SsEqual(ssmem, strMem)
    MACROTEMP result, pa, pb
    LOCAL result AS LONG
    LOCAL pa, pb AS BYTE PTR
    result = 0
    pa = ssmem : pb = strMem
    IF pa AND pb THEN
        WHILE @pa AND @pb AND @pa = @pb
            INCR pa
            INCR pb
        WEND
        IF @pa = 0 AND @pb = 0 THEN result = 1
    ELSEIF pa OR pb THEN
    ELSE
        result = 1
    END IF
END MACRO = result

MACRO FUNCTION SsEqualUCase(ssmem, strMem)
    MACROTEMP result, pa, pb, ca, cb
    REGISTER ca AS LONG
    REGISTER cb AS LONG
    LOCAL result AS LONG
    LOCAL pa, pb AS BYTE PTR
    result = 0
    pa = ssmem : pb = strMem
    IF pa AND pb THEN
        ca = @pa
        cb = @pb
        IF cA > 96 AND cA < 123 THEN cA -= 32
        IF cB > 96 AND cB < 123 THEN cB -= 32
        WHILE ca AND cb AND ca = cb
            INCR pa
            INCR pb
        WEND
        IF @pa = 0 AND @pb = 0 THEN result = 1
    ELSEIF pa OR pb THEN
    ELSE
        result = 1
    END IF
END MACRO = result
