#INCLUDE THIS ONCE
#INCLUDE ONCE "..\HLib3\HLib.inc"

'++
    '----------------------------------------------------------------------------------------
    '   WString Buffer Container
    '
    '   container accessed with handle
    '   handle protected by hash tag
    '   h = WsNew() 'get handle for new container
    '   h = WsFinal(h) 'free handle before it goes out of scope
    '----------------------------------------------------------------------------------------
'--

MACRO WsTag = -1119369189
TYPE WsStr
    tag AS LONG
    count AS LONG
    mem AS WORD PTR
END TYPE

DECLARE FUNCTION WsCompareCB(BYVAL pa AS WsStr PTR, BYVAL pb AS WsStr PTR, BYVAL pCollation AS WsStr PTR) AS LONG

FUNCTION WsNew() AS LONG
    'allocate new container - return handle
    LOCAL p AS WsStr PTR
    p = MemAlloc(SIZEOF(@p))
    ExitF(p=0, LibErrM)
    @p.tag = WsTag
    FUNCTION = p
END FUNCTION

FUNCTION WsFinal(BYVAL p AS WsStr PTR) AS LONG
    'free allocated container - return null - container can't be Read Locked
    IF p THEN
        ExitF(@p.tag<>WsTag, LibErrH)
        WsClear p
        MemFree(p)
    END IF
END FUNCTION

FUNCTION WsValidate(BYVAL p AS WsStr PTR) AS LONG
    'True/False if valid handle for this container
    IF p AND @p.tag = WsTag THEN FUNCTION = @p.tag
END FUNCTION

SUB WsClear(BYVAL p AS WsStr PTR)
    'delete all data - container can't be Read Locked
    ExitS(p=0 OR @p.tag<>WsTag, LibErrH)
    @p.count = 0
    @p.mem = MemFree(@p.mem)
END SUB

FUNCTION WsCount(BYVAL p AS WsStr PTR) AS LONG
    'get item count (number of characters)
    ExitF(p=0 OR @p.tag<>WsTag, LibErrH)
    FUNCTION = @p.count
END FUNCTION

FUNCTION WsGet(BYVAL p AS WsStr PTR) AS WSTRING
    'get WString
    ExitF(p=0 OR @p.tag<>WsTag, LibErrH)
    IF @p.count THEN FUNCTION = PEEK$$(@p.mem, @p.count)
END FUNCTION

SUB WsSet(BYVAL p AS WsStr PTR, BYREF value AS WSTRING)
    'set WString - container can't be Read Locked
    LOCAL strLen AS LONG : strLen = LEN(value)
    ExitS(p=0 OR @p.tag<>WsTag, LibErrH)
    @p.count = 0
    IF @p.mem THEN @p.mem = MemFree(@p.mem)
    IF strLen THEN
        @p.mem = MemAlloc((strLen * 2) + 2)
        ExitS(@p.mem=0, LibErrM)
        @p.count = strLen
        POKE$$ @p.mem, value
    END IF
END SUB

FUNCTION WsSetNew(BYREF value AS WSTRING) AS LONG
    'allocate and set new string buffer container - return handle
    LOCAL h AS LONG
    h = WsNew()
    IF h THEN WsSet h, value
    FUNCTION = h
END FUNCTION

FUNCTION WsCompare(BYVAL pa AS WsStr PTR, BYVAL pb AS WsStr PTR, BYVAL pCollation AS WsStr PTR) PRIVATE AS LONG
    LOCAL i, compare, TOP AS LONG
    IF pa AND pb AND @pa.tag=WsTag AND @pb.tag=WsTag THEN
        IF @pa.count < @pb.count THEN TOP = @pa.count ELSE TOP = @pb.count
        FOR i = 0 TO TOP - 1
            compare = @pa.@mem[i] - @pb.@mem[i]
            IF compare THEN
                FUNCTION = compare : EXIT FUNCTION
            END IF
        NEXT i
        FUNCTION = @pa.count - @pb.count
    ELSE
        ExitLogErr(LibErrH)
    END IF
END FUNCTION

FUNCTION WsCompareUCase(BYVAL pa AS WsStr PTR, BYVAL pb AS WsStr PTR, BYVAL pCollation AS WsStr PTR) PRIVATE AS LONG
    LOCAL ca, cb, i, compare, TOP AS LONG
    IF pa AND pb AND @pa.tag=WsTag AND @pb.tag=WsTag THEN
        IF @pa.count < @pb.count THEN TOP = @pa.count ELSE TOP = @pb.count
        FOR i = 0 TO TOP - 1
            ca = @pa.@mem[i]
            cb = @pb.@mem[i]
            IF cA > 96 AND cA < 123 THEN cA -= 32
            IF cB > 96 AND cB < 123 THEN cB -= 32
            compare = ca - cb
            IF compare THEN
                FUNCTION = compare : EXIT FUNCTION
            END IF
        NEXT i
        FUNCTION = @pa.count - @pb.count
    ELSE
        ExitLogErr(LibErrH)
    END IF
END FUNCTION

FUNCTION WsCompareCollate(BYVAL pa AS WsStr PTR, BYVAL pb AS WsStr PTR, BYVAL pCollation AS WsStr PTR) PRIVATE AS LONG
    LOCAL i, compare, TOP AS LONG
    IF pa AND pb AND pCollation AND @pa.tag=WsTag AND @pb.tag=WsTag AND @pCollation.tag=WsTag THEN
        IF @pa.count < @pb.count THEN TOP = @pa.count ELSE TOP = @pb.count
        FOR i = 0 TO TOP - 1
            compare = @pCollation.@mem[@pa.@mem[i]] - @pCollation.@mem[@pb.@mem[i]]
            IF compare THEN
                FUNCTION = compare : EXIT FUNCTION
            END IF
        NEXT i
        FUNCTION = @pa.count - @pb.count
    ELSE
        ExitLogErr(LibErrH)
    END IF
END FUNCTION

MACRO FUNCTION WsEqual(wsmem, wstrMem)
    MACROTEMP result, pa, pb
    LOCAL result AS LONG
    LOCAL pa, pb AS WORD PTR
    result = 0
    pa = wsmem : pb = wstrMem
    IF pa AND pb THEN
        WHILE @pa AND @pb AND @pa = @pb
            INCR pa
            INCR pb
        WEND
        IF @pa = 0 AND @pb = 0 THEN result = 1
    ELSEIF pa OR pb THEN
    ELSE
        result = 1
    END IF
END MACRO = result
