'don't need to include this file unless it contains a required UDT
'08-26-2012
'public domain - use at own risk


    '----------------------------------------------------------------------------------------
    '   String List Container Procedures
    '       container accessed with handle
    '       handle protected by hash tag
    '       h = SsLstNew() 'get handle for new container
    '       h = SsLstFinal(h) 'free handle before it goes out of scope
    '----------------------------------------------------------------------------------------

Declare Function SsLstNew() As Long
    'allocate new container - return handle

Declare Function SsLstFinal(ByVal pLst As SsLst Ptr) As Long
    'free allocated container - return null - Modifies Container Data

Declare Function SsLstValidate(ByVal pLst As SsLst Ptr) As Long
    'True/False if valid handle for this container

Declare Sub SsLstClear(ByVal pLst As SsLst Ptr)
    'delete all data - Modifies Container Data

Declare Function SsLstCount(ByVal pLst As SsLst Ptr) As Long
    'get item count (number of characters)

Declare Sub SsLstAdd(ByVal pLst As SsLst Ptr, ByRef value As String)
    'append Value to end of List - Modifies Container Data

Declare Sub SsLstIns(ByVal pLst As SsLst Ptr, ByRef value As String)
    'insert Value at front of List - Modifies Container Data

Declare Function SsLstFirst(ByVal pLst As SsLst Ptr) As Long
    'get handle to first node in List

Declare Function SsLstLast(ByVal pLst As SsLst Ptr) As Long
    'get handle to last node in List

Declare Function SsLstNext(ByVal pNode As LnLstNode Ptr) As Long
    'get handle to next node in List

Declare Function SsLstPrev(ByVal pNode As LnLstNode Ptr) As Long
    'get handle to previous node in List

Declare Function SsLstGet(ByVal pNode As LnLstNode Ptr) As String
    'get node's Value

Declare Sub SsLstSet(ByVal pNode As LnLstNode Ptr, ByRef value As String)
    'set node's Value - Modifies Container Data

Declare Sub SsLstInsPrev(ByVal pLst As SsLst Ptr, ByVal pNode As LnLstNode Ptr, ByRef value As String)
    'insert Value before node - Modifies Container Data

Declare Sub SsLstInsNext(ByVal pLst As SsLst Ptr, ByVal pNode As LnLstNode Ptr, ByRef value As String)
    'insert Value after Cursor - Modifies Container Data

Declare Sub SsLstDelPrev(ByVal pLst As SsLst Ptr, ByVal pNode As LnLstNode Ptr)
    'remove node before this node - Modifies Container Data

Declare Sub SsLstDelNext(ByVal pLst As SsLst Ptr, ByVal pNode As LnLstNode Ptr)
    'remove node after this node - Modifies Container Data

Declare Function SsLstMatch(ByVal pNode As LnLstNode Ptr, ByVal matchCB As Long) As Long
    'node's value passed to callback function
    'callback function must determine if passed value is considered a match
    'the function returns the results of the callback function
    'Function MatchCB(byref value As String) ThreadSafe As Long

    '----------------------------------------------------------------------------------------
    '   Stack Procedures
    '----------------------------------------------------------------------------------------

Declare Sub SsLstStkPush(ByVal pLst As SsLst Ptr, ByRef value As String)
    'Push Value on Stack - Modifies Container Data

Declare Function SsLstStkPeek(ByVal pLst As SsLst Ptr) As String
    'get top Value on Stack

Declare Function SsLstStkPop(ByVal pLst As SsLst Ptr) As String
    'get and remove top Value on Stack - Modifies Container Data

    '----------------------------------------------------------------------------------------
    '   Queue Procedures
    '----------------------------------------------------------------------------------------

Declare Sub SsLstQuePush(ByVal pLst As SsLst Ptr, ByRef value As String)
    'Add Value to end of Queue - Modifies Container Data

Declare Function SsLstQuePeek(ByVal pLst As SsLst Ptr) As String
    'get first Value in Queue

Declare Function SsLstQuePop(ByVal pLst As SsLst Ptr) As String
    'get and remove first Value in Queue - Modifies Container Data

    '----------------------------------------------------------------------------------------
    '   Deque Procedures (double-ended Queue)
    '----------------------------------------------------------------------------------------

Declare Sub SsLstPushFirst(ByVal pLst As SsLst Ptr, ByRef value As String)
    'Add Value at front of container - Modifies Container Data

Declare Sub SsLstPushLast(ByVal pLst As SsLst Ptr, ByRef value As String)
    'Add Value at end of container - Modifies Container Data

Declare Function SsLstPeekFirst(ByVal pLst As SsLst Ptr) As String
    'get first Value in container

Declare Function SsLstPeekLast(ByVal pLst As SsLst Ptr) As String
    'get last Value in container

Declare Function SsLstPopFirst(ByVal pLst As SsLst Ptr) As String
    'get and remove first Value in container - Modifies Container Data

Declare Function SsLstPopLast(ByVal pLst As SsLst Ptr) As String
    'get and remove last Value in container - Modifies Container Data

    '----------------------------------------------------------------------------------------
    '   Clone Container
    '----------------------------------------------------------------------------------------

Declare Function SsLstClone(ByVal pLst As SsLst Ptr) As Long
    'returns handle to duplicate container

    '----------------------------------------------------------------------------------------
    '   Store/Restore Container To/From String
    '----------------------------------------------------------------------------------------

Declare Function SsLstStore(ByVal pLst As SsLst Ptr) As String
    'store container to String

Declare Sub SsLstRestore(ByVal pLst As SsLst Ptr, ByRef s As String)
    'restore container from string - Modifies Container Data

    '----------------------------------------------------------------------------------------
    '   Store/Restore Container To/From File
    '----------------------------------------------------------------------------------------

Declare Sub SsLstFileStore(ByVal pLst As SsLst Ptr, ByVal file As String)
    'store container to file

Declare Sub SsLstFileRestore(ByVal pLst As SsLst Ptr, ByVal file As String)
    'restore container from file - Modifies Container Data

    '----------------------------------------------------------------------------------------
    '   String Builder Procedures
    '       use container's other procedures to Add/Insert/Modify/Remove string segments
    '----------------------------------------------------------------------------------------

Declare Function SsLstBuildStr(ByVal pLst As SsLst Ptr) As String
    'get complete string containing all string segments in container

    '----------------------------------------------------------------------------------------
    '   Text Document Procedures
    '----------------------------------------------------------------------------------------

Declare Sub SsLstTextLoad(ByVal pLst As SsLst Ptr, ByVal file As String)
    'load text file into container clearing current contents - Modifies Container Data

Declare Sub SsLstTextSave(ByVal pLst As SsLst Ptr, ByVal file As String)
    'save container to text file overwriting file's current contents

Declare Function SsLstTextGet(ByVal pLst As SsLst Ptr) As String
    'get container's contents as a Text Document, appending CrLf to each item

Declare Sub SsLstTextSet(ByVal pLst As SsLst Ptr, ByVal s As String)
    'replace container's contents with a Text Document - each line = item in container (removing CrLf) - Modifies Container Data

    '----------------------------------------------------------------------------------------
    '   File List Procedures
    '----------------------------------------------------------------------------------------

Declare Sub SsLstGetFiles(ByVal pLst As SsLst Ptr, ByVal folder As String, ByVal mask As String)
    'load container with all files in folder matching the mask - Modifies Container Data
    'loads file names without path

Declare Sub SsLstGetPaths(ByVal pLst As SsLst Ptr, ByVal folder As String, ByVal mask As String)
    'load container with all files in folder matching the mask - Modifies Container Data
    'loads full path
