'SsSsTri.bas
#Dim All
#Compile Exe
#Include Once "WIN32API.INC"
#Include Once "..\SsSsTri.inc"

Macro lbxID = 1000
Macro btnID = 1001

CallBack Function BtnCB()
    Local i, ok, Count As Long
    Local d As Double
    Local s As String
    Local a() As String

    Local tree As Long
    Local clone As Long

    tree = SsSsTriNew() 'create new tree

    Count = 100000
    Randomize
    ListBox Reset CbHndl, lbxID
    ReDim a(1 To Count)
    For i = 1 To Count
        a(i) = Format$(i, "00000000")
    Next i

    'add Key/Value

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "add "+Format$(Count, "#,")+" Key/Values to tree"
    d = Timer
    For i = 1 To Count
        SsSsTriSet tree, a(i), a(i)
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(SsSsTriCount(tree), "#,")

    'test to see if Key exist

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "test to see if all "+Format$(Count, "#,")+" Keys are in tree"
    d = Timer
    For i = 1 To Count
        If IsFalse SsSsTriGot(tree, a(i)) Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'get Key's associated Value

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "get all "+Format$(Count, "#,")+" Values in tree"
    d = Timer
    For i = 1 To Count
        If SsSsTriGet(tree, a(i)) <> a(i) Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'traverse tree in Key order

    'get value at cursor

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "traverse tree in Key order - get and test all "+Format$(Count, "#,")+" Values"
    i = 0
    d = Timer
    ok = SsSsTriFirstKey(tree)
    While ok
        Incr i
        If SsSsTriGetVal(tree) <> a(i) Then
            ? "fail at: " + Format$(i) : Exit Loop
        End If
        ok = SsSsTriNextKey(tree)
    Wend
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'get key at cursor

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "traverse tree in Key order - get and test all "+Format$(Count, "#,")+" Keys"
    i = 0
    d = Timer
    ok = SsSsTriFirstKey(tree)
    While ok
        Incr i
        If SsSsTriGetKey(tree) <> a(i) Then
            ? "fail at: " + Format$(i) : Exit Loop
        End If
        ok = SsSsTriNextKey(tree)
    Wend
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'remove Key/Value

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "delete all Keys that represent an odd number"
    ListBox Add CbHndl, lbxID, "Count = " + Format$(SsSsTriCount(tree), "#,")
    d = Timer
    For i = 1 To Count
        If i Mod 2 Then
            SsSsTriDel tree, a(i)
        End If
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(SsSsTriCount(tree), "#,")

    ListBox Add CbHndl, lbxID, "make sure even number Keys still in tree"
    For i = 1 To Count
        If IsFalse i Mod 2 And IsFalse SsSsTriGot(tree, a(i)) Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i

    ListBox Add CbHndl, lbxID, "make sure odd number Keys not in tree"
    For i = 1 To Count
        If i Mod 2 And SsSsTriGot(tree, a(i)) Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i

    'Prefix Search
    '   a Trie Tree supports extremely fast IntelliSense like prefix search

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Prefix Search"
    ListBox Add CbHndl, lbxID, "clear tree"
    SsSsTriClear tree
    ListBox Add CbHndl, lbxID, "add some Key strings to the tree"
    SsSsTriSet tree, "a", "#1"
    SsSsTriSet tree, "aabcd", "#2"
    SsSsTriSet tree, "abcd", "#3"
    SsSsTriSet tree, "aaaxxx", "#4"
    SsSsTriSet tree, "bcde", "#5"
    SsSsTriSet tree, "bbcde", "#6"
    SsSsTriSet tree, "bbbcde", "#7"
    SsSsTriSet tree, "az", "#8"
    SsSsTriSet tree, "azzz", "#9"
    SsSsTriSet tree, "aza", "#10"
    ListBox Add CbHndl, lbxID, "--- Display Tree's Keys ---"
    ok = SsSsTriFirstKey(tree)
    While ok
        ListBox Add CbHndl, lbxID, SsSsTriGetKey(tree)
        ok = SsSsTriNextKey(tree)
    Wend
    ListBox Add CbHndl, lbxID, "--- display Keys beginning with ""a"""
    ok = SsSsTriFirstPrefix(tree, "a")
    While ok
        ListBox Add CbHndl, lbxID, SsSsTriGetKey(tree)
        ok = SsSsTriNextPrefix(tree)
    Wend
    ListBox Add CbHndl, lbxID, "--- display Keys beginning with ""aa"""
    ok = SsSsTriFirstPrefix(tree, "aa")
    While ok
        ListBox Add CbHndl, lbxID, SsSsTriGetKey(tree)
        ok = SsSsTriNextPrefix(tree)
    Wend
    ListBox Add CbHndl, lbxID, "--- display Keys beginning with ""aaa"""
    ok = SsSsTriFirstPrefix(tree, "aaa")
    While ok
        ListBox Add CbHndl, lbxID, SsSsTriGetKey(tree)
        ok = SsSsTriNextPrefix(tree)
    Wend
    ListBox Add CbHndl, lbxID, "--- display Keys beginning with ""az"""
    ok = SsSsTriFirstPrefix(tree, "az")
    While ok
        ListBox Add CbHndl, lbxID, SsSsTriGetKey(tree)
        ok = SsSsTriNextPrefix(tree)
    Wend
    ListBox Add CbHndl, lbxID, "--- display Keys beginning with ""b"""
    ok = SsSsTriFirstPrefix(tree, "b")
    While ok
        ListBox Add CbHndl, lbxID, SsSsTriGetKey(tree)
        ok = SsSsTriNextPrefix(tree)
    Wend
    ListBox Add CbHndl, lbxID, "--- display Keys beginning with ""bb"""
    ok = SsSsTriFirstPrefix(tree, "bb")
    While ok
        ListBox Add CbHndl, lbxID, SsSsTriGetKey(tree)
        ok = SsSsTriNextPrefix(tree)
    Wend
    ListBox Add CbHndl, lbxID, "--- display Keys beginning with ""bbb"""
    ok = SsSsTriFirstPrefix(tree, "bbb")
    While ok
        ListBox Add CbHndl, lbxID, SsSsTriGetKey(tree)
        ok = SsSsTriNextPrefix(tree)
    Wend

    'Clone

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Clone"
    ListBox Add CbHndl, lbxID, "clear tree"
    SsSsTriClear tree
    ListBox Add CbHndl, lbxID, "add 5 Key/Values"
    For i = 1 To 5
        SsSsTriSet tree, a(i) + "Key", a(i) + "Value"
    Next i
    ListBox Add CbHndl, lbxID, "clone container"
    clone = SsSsTriClone(tree)
    ListBox Add CbHndl, lbxID, "--- Display Clone ---"
    ok = SsSsTriFirstKey(clone)
    While ok
        ListBox Add CbHndl, lbxID, $Dq + SsSsTriGetKey(clone) + $Dq +" = "+ $Dq + SsSsTriGetVal(clone) + $Dq
        ok = SsSsTriNextKey(clone)
    Wend

    clone = SsSsTriFinal(clone) 'must free handles

    'Store/Restore container To/From String

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Store container to String"
    s = SsSsTriStore(tree)
    ListBox Add CbHndl, lbxID, "Restore container from String"
    SsSsTriRestore tree, s
    ListBox Add CbHndl, lbxID, "--- Display Tree ---"
    ok = SsSsTriFirstKey(tree)
    While ok
        ListBox Add CbHndl, lbxID, $Dq + SsSsTriGetKey(tree) + $Dq +" = "+ $Dq + SsSsTriGetVal(tree) + $Dq
        ok = SsSsTriNextKey(tree)
    Wend

    'Store/Restore container To/From File

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Store container to File"
    SsSsTriFileStore tree, "test.data"
    ListBox Add CbHndl, lbxID, "Restore container from File"
    SsSsTriFileRestore tree, "test.data"
    ListBox Add CbHndl, lbxID, "--- Display Tree ---"
    ok = SsSsTriFirstKey(tree)
    While ok
        ListBox Add CbHndl, lbxID, $Dq + SsSsTriGetKey(tree) + $Dq +" = "+ $Dq + SsSsTriGetVal(tree) + $Dq
        ok = SsSsTriNextKey(tree)
    Wend

    If IsFile("test.data") Then Kill "test.data"

    'must free handles before they go out of scope
    tree = SsSsTriFinal(tree)

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "done..."
End Function

Function PBMain()
    Local hDlg As Long
    Dialog New 0, "SsSsTri.bas", 67, 61, 341, 241, %WS_Caption Or %WS_ClipSiblings Or %WS_MinimizeBox Or %WS_SysMenu, %WS_Ex_AppWindow To hDlg
    Control Add ListBox, hDlg, lbxID, , 5, 5, 330, 210, %WS_Child Or %WS_HScroll Or %WS_VScroll Or %LBS_Notify Or %LBS_NoIntegralHeight, %WS_Ex_ClientEdge
    Control Add Button,  hDlg, btnID, "Test", 275, 220, 60, 15 Call BtnCB()
    Dialog Show Modal hDlg, Call DlgCB
End Function

CallBack Function DlgCB()
End Function
