'Locker.inc
#Include This Once

'++
    'Data Structure Read/Write Locking Flag
    '   doesn't lock anything
    '   it's a locking Flag - locking traffic light
    '   Rules:
    '       no process can modify data until it gets a Write Lock
    '       any number of process can read data after they get a Read Lock
    '       all processes must free their lock on completion
'--

Type LockerT
    rl As Long
    wl As Long
End Type
Union LockerU
    L As LockerT
    Q As Quad
End Union

Function LockIt(ByVal lockVar As Quad, ByVal operation As Long) ThreadSafe As Byte
    'Lock/Unlock Flag
    'operation = 0 : free previous lock - return null
    'operation = 1 : Read Lock for shared read-only access - True/False success
    'operation = 2 : Write Lock for exclusive access - True/False success
    Local u As LockerU : u.Q = lockVar
    If operation = 1 Then
        If u.L.wl = 0 Then
            Incr u.L.rl : Function = 1
        End If
    ElseIf operation = 2 Then
        If u.L.rl = 0 And u.L.wl = 0 Then
            u.L.wl = 1 : Function = 1
        End If
    Else
        If u.L.rl Then
            Decr u.L.rl
        ElseIf u.L.wl Then
            u.L.wl = 0
        End If
    End If
End Function
