'StrThreadLock.bas
#Dim All
#Compile Exe
#Include Once "WIN32API.INC"
#Include Once "..\..\String\SsStr.inc"
#Include Once "..\Locker.inc"

'10 threads do 10 loops
'each thread;
'   gets write lock
'       changes String
'   frees write lock
'   gets read lock
'       displays String
'   frees read lock
'
'   any number of threads can read at the same time
'   only one thread at a time can make changes

Macro lbxID = 1000
Macro btnID = 1001

Global gLock As Quad

Type ThreadInfo
    no As Long
    hThread As Long
    hDlg As Long
    hStr As Long
End Type

Thread Function TestThread(ByVal hInfo As Long) As Long
    Local i As Long
    Local p As ThreadInfo Ptr

    p = hInfo

    For i = 1 To 10

        Sleep 1

        'get write lock
        While LockIt(gLock, 2) = 0 : Wend

        'set string
        SsSet @p.hStr, "modified by Thread: " + Format$(@p.no, "0000") + " on Loop: " + Format$(i, "0000")
        ListBox Add @p.hDlg, lbxID, "Write Lock: Thread = " + Format$(@p.no) +" Loop = "+ Format$(i)

        'free write lock
        LockIt(gLock, 0)

        Sleep 1

        'get read lock
        While LockIt(gLock, 1) = 0 : Wend

        'display string
        ListBox Add @p.hDlg, lbxID, "read by Thread: " + Format$(@p.no, "0000") + " on Loop: " + Format$(i, "0000") +" = "+ $Dq + SsGet(@p.hStr) + $Dq

        'free read lock
        LockIt(gLock, 0)

    Next i

    @p.hThread = 0
End Function

CallBack Function BtnCB()
    Local i, threads As Long
    Local a() As ThreadInfo
    Local hStr As Long

    ListBox Reset CbHndl, lbxID
    Dialog DoEvents

    threads = 10
    hStr = SsNew() 'allocate new String container

    ReDim a(1 To threads)

    For i = 1 To threads
        a(i).no = i
        a(i).hDlg = Cb.Hndl
        a(i).hStr = hStr
        Thread Create TestThread( VarPtr(a(i)) ), 65536 To a(i).hThread
    Next i

    HERE:
    Dialog DoEvents
    For i = 1 To threads
        If a(i).hThread Then GoTo HERE
    Next i

    hStr = SsFinal(hStr) 'free handle before it goes out of scope

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "done..."
End Function

Function PBMain()
    Local hDlg As Long
    Dialog New 0, "StrThreadLock", 67, 61, 341, 241, %WS_Caption Or %WS_ClipSiblings Or %WS_MinimizeBox Or %WS_SysMenu, %WS_Ex_AppWindow To hDlg
    Control Add ListBox, hDlg, lbxID, , 5, 5, 330, 210, %WS_Child Or %WS_HScroll Or %WS_VScroll Or %LBS_Notify Or %LBS_NoIntegralHeight, %WS_Ex_ClientEdge
    Control Add Button,  hDlg, btnID, "Test", 275, 220, 60, 15 Call BtnCB()
    Dialog Show Modal hDlg, Call DlgCB
End Function

CallBack Function DlgCB()
End Function
