'ObjMac.inc
#Include This Once
#If Not %Def(%ObjMacInc)
%ObjMacInc = 1

    'Macros to work with objects stored in handles
    'handle can be Long or DWord
    '
    'public domain - use at own risk
    '
    'update: 3/16/2013 - ObjMacSet(H, O) frees any previous object before storing new object
    'update: 3/16/2013 - ObjMacGet(H, O) gets the stored object as IUnknown and then casts it to the passed interface


    'free object stored in handle
    'H = Long handle
Macro ObjMacFree(H)
    MacroTemp o
    Local o As IUnknown
    If H Then
        Poke Long, VarPtr(o), H
        o = Nothing
        H = 0
    End If
End Macro

    'store object in handle
    'H = Long handle
    'O = object
Macro ObjMacSet(H, O)
    ObjMacFree(H)
    O.AddRef()
    H = Peek(Long, VarPtr(O))
End Macro

    'store new instance in handle
    'H = Long handle
    'I = object's Interface
    'C = object's Class
Macro ObjMacSetNew(H, I, C)
    MacroTemp o
    Local o As I : o = Class C
    ObjMacSet(H, o)
End Macro

    'get object from handle
    'H = Long handle
    'O = object
Macro ObjMacGet(H, O)
    MacroTemp u
    Local u As IUnknown
    O = Nothing
    If H Then
        Poke Long, VarPtr(u), H
        u.AddRef()
        O = u
    End If
End Macro


#EndIf
