'
' Test program for custom control Progressbar include file, PGBAR3D.INC
''
#COMPILE EXE
#INCLUDE "WIN32API.INC"
#INCLUDE "PGBAR3D.INC"  '<- Progressbar include file
'------------------------------------------------------------------------------
DECLARE CALLBACK FUNCTION DlgMainProc
'------------------------------------------------------------------------------
%ID_BUTNSTART   = 101
%ID_BUTNREVERSE = 102
%ID_CHKTXT      = 110
%ID_OPTFAST     = 120
%ID_OPTSLOW     = 121
%ID_BARLEFT     = 201
%ID_BARTOP      = 202
%ID_BARRIGHT    = 203
%ID_BARBOTTOM   = 204
%ID_BARMID      = 205

'
' Main entrance - build dialog, controls and set some initial data
'
FUNCTION PBMAIN () AS LONG
  LOCAL hDlg AS DWORD
  DIALOG NEW 0, "PGBAR3D v2 demo", ,, 200, 138, %WS_CAPTION OR %WS_SYSMENU TO hDlg

  CONTROL ADD BUTTON,   hDlg, %ID_BUTNSTART,   "Start",      100, 52, 75, 14
  CONTROL ADD BUTTON,   hDlg, %ID_BUTNREVERSE, "Reverse",     25, 52, 75, 14
  CONTROL ADD OPTION,   hDlg, %ID_OPTFAST,     "Fast",        30, 28, 40, 10
  CONTROL ADD OPTION,   hDlg, %ID_OPTSLOW,     "Slow",        30, 38, 40, 10
  CONTROL ADD CHECKBOX, hDlg, %ID_CHKTXT,      "Text on/off", 97, 28, 50, 10
  CONTROL SET CHECK     hDlg, %ID_OPTFAST, 1
  CONTROL DISABLE hDlg, %ID_BUTNREVERSE

  CreatePGBar3D hDlg, %ID_BARLEFT, "", 5, 20, 14, 98, _
                %WS_CHILD OR %WS_VISIBLE, %WS_EX_CLIENTEDGE, 1                 'LEFT BAR, VERTICAL
        CONTROL SEND hDlg, %ID_BARLEFT, %PGB_SETMAX, 100, 0                      'max number of steps
        CONTROL SEND hDlg, %ID_BARLEFT, %PGB_SETBARDIR, 2, 0                     'bar direction, bottom - top
        CONTROL SEND hDlg, %ID_BARLEFT, %PGB_SETGRADIENTDIR, 1, 0                'vertical gradient
        CONTROL SEND hDlg, %ID_BARLEFT, %PGB_SETBARCOL, %PGB_GOLD, 0             'bar color scheme
        CONTROL SEND hDlg, %ID_BARLEFT, %PGB_SETTXTCOLBKG, RGB(255, 255, 0), 0   'backgound text color
        CONTROL SEND hDlg, %ID_BARLEFT, %PGB_SETTXTCOLBAR, RGB(0, 0, 255), 0     'bar text color
        CONTROL SEND hDlg, %ID_BARLEFT, %PGB_SETTXTANGLE, 90, 0                  'text angle, vertical up

  CreatePGBar3D hDlg, %ID_BARTOP, "", 5, 4, 190, 14, _
                %WS_CHILD OR %WS_VISIBLE, %WS_EX_CLIENTEDGE, 1                  'TOP BAR, HORIZONTAL
        CONTROL SEND hDlg, %ID_BARTOP, %PGB_SETMAX, 100, 0                       'max number of steps
        CONTROL SEND hDlg, %ID_BARTOP, %PGB_SETBARDIR, 0, 0                      'bar direction, left - right
        CONTROL SEND hDlg, %ID_BARTOP, %PGB_SETGRADIENTDIR, 0, 0                 'horizontal gradient
        CONTROL SEND hDlg, %ID_BARTOP, %PGB_SETBARCOL, %PGB_CYAN, 0              'bar color scheme
        CONTROL SEND hDlg, %ID_BARTOP, %PGB_SETTXTCOLBKG, RGB(0,255,255), 0      'backgound text color
        CONTROL SEND hDlg, %ID_BARTOP, %PGB_SETTXTCOLBAR, RGB(0,0,0), 0          'bar text color

  CreatePGBar3D hDlg, %ID_BARRIGHT, "", 181, 20, 14, 98, _
                %WS_CHILD OR %WS_VISIBLE, %WS_EX_CLIENTEDGE, 1                  'RIGHT BAR, VERTICAL
        CONTROL SEND hDlg, %ID_BARRIGHT, %PGB_SETMAX, 100, 0                     'max number of steps
        CONTROL SEND hDlg, %ID_BARRIGHT, %PGB_SETBARDIR, 3, 0                    'bar direction, top - bottom
        CONTROL SEND hDlg, %ID_BARRIGHT, %PGB_SETGRADIENTDIR, 1, 0               'vertical gradient
        CONTROL SEND hDlg, %ID_BARRIGHT, %PGB_SETBARCOL, %PGB_RED, 0             'bar edge color
        CONTROL SEND hDlg, %ID_BARRIGHT, %PGB_SETCOLBKG, RGB(191,191,191), 0     'background color
        CONTROL SEND hDlg, %ID_BARRIGHT, %PGB_SETTXTCOLBKG, RGB(255,0,0), 0      'backgound text color
        CONTROL SEND hDlg, %ID_BARRIGHT, %PGB_SETTXTCOLBAR, RGB(255,255,0), 0    'bar text color
        CONTROL SEND hDlg, %ID_BARRIGHT, %PGB_SETTXTANGLE, 270, 0                'text angle, vertical down

  CreatePGBar3D hDlg, %ID_BARBOTTOM, "", 5, 120, 190, 14, _
                %WS_CHILD OR %WS_VISIBLE, %WS_EX_CLIENTEDGE, 1                  'BOTTOM BAR, HORIZONTAL
        CONTROL SEND hDlg, %ID_BARBOTTOM, %PGB_SETMAX, 100, 0                    'max number of steps
        CONTROL SEND hDlg, %ID_BARBOTTOM, %PGB_SETBARDIR, 1, 0                   'bar direction, right - left
        CONTROL SEND hDlg, %ID_BARBOTTOM, %PGB_SETGRADIENTDIR, 0, 0              'horizontal gradient
        CONTROL SEND hDlg, %ID_BARBOTTOM, %PGB_SETCOLBKG, RGB(191,191,191), 0    'background color
        CONTROL SEND hDlg, %ID_BARBOTTOM, %PGB_SETBARCOL, %PGB_BLUE, 0           'bar mid color
        CONTROL SEND hDlg, %ID_BARBOTTOM, %PGB_SETTXTCOLBKG, RGB(0,0,196), 0     'backgound text color
        CONTROL SEND hDlg, %ID_BARBOTTOM, %PGB_SETTXTCOLBAR, RGB(255,255,255), 0 'bar text color
        CONTROL SEND hDlg, %ID_BARBOTTOM, %PGB_SETTXTANGLE, 180, 0               'text angle, upside down

  CreatePGBar3D hDlg, %ID_BARMID, "", 22, 70, 157, 48, _
                %WS_CHILD OR %WS_VISIBLE, %WS_EX_CLIENTEDGE, 1               'MID BAR, HORIZONTAL
     CONTROL SEND hDlg, %ID_BARMID, %PGB_SETMAX, 100, 0                       'max number of steps
     CONTROL SEND hDlg, %ID_BARMID, %PGB_SETBARDIR, 2, 0                      'bar direction, bottom - top
     CONTROL SEND hDlg, %ID_BARMID, %PGB_SETGRADIENTDIR, 0, 0                 'horizontal gradient
     CONTROL SEND hDlg, %ID_BARMID, %PGB_SETCOLBKG, RGB(0,0,0), 0             'background color
     CONTROL SEND hDlg, %ID_BARMID, %PGB_SETBARCOL, %PGB_SILVER, 0            'bar edge color
     CONTROL SEND hDlg, %ID_BARMID, %PGB_SETTXTCOLBKG, RGB(0,255,255), 0      'backgound text color

     LOCAL txt AS STRING
     txt = "Click Start to see action"                    'set background text in middle progressbar
     CONTROL SEND hDlg, %ID_BARMID, %PGB_SETTXTBKG, STRPTR(txt), 0
     txt = "Hope you'll find it useful!"                  'set bar text in middle progressbar
     CONTROL SEND hDlg, %ID_BARMID, %PGB_SETTXTBAR, STRPTR(txt), 0
     CONTROL SEND hDlg, %ID_BARMID, %PGB_SETTXTON, 0, 2   'tell control to use custom text

  CONTROL SEND hDlg, %ID_BARLEFT,   %PGB_BUILDBARS, 0, 0  'finally, build the bars - IMPORTANT!
  CONTROL SEND hDlg, %ID_BARTOP,    %PGB_BUILDBARS, 0, 0
  CONTROL SEND hDlg, %ID_BARRIGHT,  %PGB_BUILDBARS, 0, 0
  CONTROL SEND hDlg, %ID_BARBOTTOM, %PGB_BUILDBARS, 0, 0
  CONTROL SEND hDlg, %ID_BARMID,    %PGB_BUILDBARS, 0, 0

  DIALOG SHOW MODAL hDlg, CALL DlgMainProc
END FUNCTION

'
' Main dialog callback procedure
'
CALLBACK FUNCTION DlgMainProc
  LOCAL I AS LONG, J AS LONG, K AS LONG, txt AS STRING
  STATIC slow AS LONG, allSteps AS LONG

  SELECT CASE CBMSG
     CASE %WM_COMMAND
        IF CBCTLMSG = %BN_CLICKED OR CBCTLMSG = 1 THEN
           SELECT CASE CBCTL
              CASE %ID_BUTNSTART
                 CONTROL GET CHECK CBHNDL, %ID_OPTSLOW TO slow   '<- check settings for slow/fast
                 CONTROL SEND CBHNDL, %ID_BARTOP, %PGB_GETMAX, 0, 0 TO allSteps 'get number of steps, usually 100
                 CONTROL DISABLE CBHNDL, %ID_BUTNSTART      '<- disable start button
                 txt = "Please wait.."                      '<- set new text in middle progressbar
                 CONTROL SEND CBHNDL, %ID_BARMID, %PGB_SETTXTBKG, STRPTR(txt), 1
                 FOR K = 0 TO 4                             '<- run one control at the time
                    FOR I = 1 TO allSteps
                       CONTROL SEND CBHNDL, %ID_BARLEFT + K, %PGB_STEPUP, 0, 0
                       IF I MOD 2 = 0 THEN DIALOG DOEVENTS  '<- to avoid dialog "freeze" in loop..
                       IF slow THEN SLEEP 40                '<- if "slow" has been selected
                    NEXT
                 NEXT
                 CONTROL ENABLE CBHNDL, %ID_BUTNREVERSE     '<- enable reverse button

              CASE %ID_BUTNREVERSE
                 CONTROL DISABLE CBHNDL, %ID_BUTNREVERSE
                 FOR K = 0 TO 4
                    FOR I = 1 TO allSteps
                       CONTROL SEND CBHNDL, %ID_BARMID - K, %PGB_STEPDN, 0, 0
                       IF I MOD 2 = 0 THEN DIALOG DOEVENTS
                       IF slow THEN SLEEP 40   'if "slow" has been selected
                    NEXT
                 NEXT
                 txt = "Click Start to see action"     'set new text in middle progressbar
                 CONTROL SEND CBHNDL, %ID_BARMID, %PGB_SETTXTBKG, STRPTR(txt), 1
                 CONTROL ENABLE CBHNDL, %ID_BUTNSTART

              CASE %ID_OPTSLOW, %ID_OPTFAST
                 CONTROL GET CHECK CBHNDL, %ID_OPTSLOW TO slow  '<- set slow/fast mode

              CASE %ID_CHKTXT 'text on/off
                 CONTROL GET CHECK CBHNDL, %ID_CHKTXT TO J      '<- set auto text (%) on/off
                 FOR K = 0 TO 3
                    CONTROL SEND CBHNDL, %ID_BARLEFT + K, %PGB_SETTXTON, 0, J
                    CONTROL SEND CBHNDL, %ID_BARLEFT + K, %PGB_REFRESH, 0, 0
                 NEXT

           END SELECT
        END IF

     CASE %WM_PALETTECHANGED
        'if in 256 color mode, switching between app's with different palettes
        'can cause weird results. Trapping %WM_PALETTECHANGED and redrawing
        'entire dialog helps some. Maybe not the best solution, but..
        IF CBWPARAM <> CBHNDL THEN
           RedrawWindow CBHNDL, BYVAL 0, BYVAL 0, %RDW_INVALIDATE OR %RDW_UPDATENOW
        END IF

  END SELECT
END FUNCTION
