'
' Test program for custom control Progressbar include file, PGBAR3D.INC
''
#COMPILE EXE
#INCLUDE "WIN32API.INC"
#INCLUDE "PGBAR3D.INC"  '<- Progressbar include file
'------------------------------------------------------------------------------
DECLARE CALLBACK FUNCTION DlgMainProc
'------------------------------------------------------------------------------
%ID_BUTNSTART   = 101
%ID_BUTNREVERSE = 102
%ID_OPTFAST     = 120
%ID_OPTSLOW     = 121
%ID_BAR1        = 202
%ID_BAR2        = 203
%ID_BAR3        = 204

'
' Main entrance - build dialog, controls and set some initial data
'
FUNCTION PBMAIN () AS LONG
  LOCAL hDlg AS DWORD
  DIALOG NEW 0, "PGBAR3D trippel-bar demo", ,, 190, 70, %WS_CAPTION OR %WS_SYSMENU TO hDlg
 
  CONTROL ADD BUTTON,   hDlg, %ID_BUTNSTART,   "Start",      100, 52, 75, 14
  CONTROL ADD BUTTON,   hDlg, %ID_BUTNREVERSE, "Reverse",     25, 52, 75, 14
  CONTROL ADD OPTION,   hDlg, %ID_OPTFAST,     "Fast",        30, 28, 40, 10
  CONTROL ADD OPTION,   hDlg, %ID_OPTSLOW,     "Slow",        30, 38, 40, 10
  CONTROL SET CHECK     hDlg, %ID_OPTFAST, 1
  CONTROL DISABLE hDlg, %ID_BUTNREVERSE
 
  CONTROL ADD LABEL, hDlg, -1, "", 5, 5, 180, 14, 0, %WS_EX_CLIENTEDGE
 
  CreatePGBar3D hDlg, %ID_BAR1, "", 6, 6, 59, 12, _
                %WS_CHILD OR %WS_VISIBLE, 0, 1                                  'BAR1
        CONTROL SEND hDlg, %ID_BAR1, %PGB_SETMAX, 33, 0                         'max number of steps
        CONTROL SEND hDlg, %ID_BAR1, %PGB_SETBARCOL, %PGB_RED, 0                'bar color scheme
 
  CreatePGBar3D hDlg, %ID_BAR2, "", 65, 6, 59, 12, _
                %WS_CHILD OR %WS_VISIBLE, 0, 1                                  'BAR2
        CONTROL SEND hDlg, %ID_BAR2, %PGB_SETMAX, 33, 0                         'max number of steps
        CONTROL SEND hDlg, %ID_BAR2, %PGB_SETBARCOL, %PGB_GOLD, 0               'bar color scheme
        CONTROL SEND hDlg, %ID_BAR2, %PGB_SETTXTON, 0, 2                        'show own text
        CONTROL SEND hDlg, %ID_BAR2, %PGB_SETTXTCOLBKG, RGB(255,255,0), 0       'backgound text color
        CONTROL SEND hDlg, %ID_BAR2, %PGB_SETTXTCOLBAR, RGB(0,0,0), 0           'bar text color
 
  CreatePGBar3D hDlg, %ID_BAR3, "", 124, 6, 60, 12, _
                %WS_CHILD OR %WS_VISIBLE, 0, 1                                   'BAR3
        CONTROL SEND hDlg, %ID_BAR3, %PGB_SETMAX, 33, 0                          'max number of steps
        CONTROL SEND hDlg, %ID_BAR3, %PGB_SETBARCOL, %PGB_GREEN, 0               'bar color scheme
 
  CONTROL SEND hDlg, %ID_BAR1, %PGB_BUILDBARS, 0, 0   'finally, build the bars - IMPORTANT!
  CONTROL SEND hDlg, %ID_BAR2, %PGB_BUILDBARS, 0, 0
  CONTROL SEND hDlg, %ID_BAR3, %PGB_BUILDBARS, 0, 0
 
  DIALOG SHOW MODAL hDlg, CALL DlgMainProc
END FUNCTION
 
'
' Main dialog callback procedure
'
CALLBACK FUNCTION DlgMainProc
  LOCAL I AS LONG, txt AS STRING
  STATIC slow AS LONG
 
  SELECT CASE CBMSG
     CASE %WM_COMMAND
        IF CBCTLMSG = %BN_CLICKED OR CBCTLMSG = 1 THEN
           SELECT CASE CBCTL
              CASE %ID_BUTNSTART
                 CONTROL GET CHECK CBHNDL, %ID_OPTSLOW TO slow   '<- check settings for slow/fast
                 CONTROL DISABLE CBHNDL, %ID_BUTNSTART      '<- disable start button
                 FOR I = 1 TO 100
                    IF I < 34 THEN
                       CONTROL SEND CBHNDL, %ID_BAR1, %PGB_STEPUP, 0, 0
                    ELSEIF I < 67 THEN
                       CONTROL SEND CBHNDL, %ID_BAR2, %PGB_STEPUP, 0, 0
                    ELSE
                       CONTROL SEND CBHNDL, %ID_BAR3, %PGB_STEPUP, 0, 0
                    END IF
                    txt = FORMAT$(I) + "%"
                    CONTROL SEND CBHNDL, %ID_BAR2, %PGB_SETTXTBKG, STRPTR(txt), 1
                    CONTROL SEND CBHNDL, %ID_BAR2, %PGB_SETTXTBAR, STRPTR(txt), 1
                    IF I MOD 2 = 0 THEN DIALOG DOEVENTS
                    IF slow THEN SLEEP 40                '<- if "slow" has been selected
                 NEXT
                 CONTROL ENABLE CBHNDL, %ID_BUTNREVERSE     '<- enable reverse button
    
              CASE %ID_BUTNREVERSE
                 CONTROL DISABLE CBHNDL, %ID_BUTNREVERSE
                 FOR I = 99 TO 0 STEP - 1
                    IF I > 66 THEN
                       CONTROL SEND CBHNDL, %ID_BAR3, %PGB_STEPDN, 0, 0
                    ELSEIF I > 33 THEN
                       CONTROL SEND CBHNDL, %ID_BAR2, %PGB_STEPDN, 0, 0
                    ELSE
                       CONTROL SEND CBHNDL, %ID_BAR1, %PGB_STEPDN, 0, 0
                    END IF
                    txt = FORMAT$(I) + "%"
                    CONTROL SEND CBHNDL, %ID_BAR2, %PGB_SETTXTBKG, STRPTR(txt), 1
                    CONTROL SEND CBHNDL, %ID_BAR2, %PGB_SETTXTBAR, STRPTR(txt), 1
                    IF I MOD 2 = 0 THEN DIALOG DOEVENTS
                    IF slow THEN SLEEP 40   'if "slow" has been selected
                 NEXT
                 CONTROL ENABLE CBHNDL, %ID_BUTNSTART
    
              CASE %ID_OPTSLOW, %ID_OPTFAST
                 CONTROL GET CHECK CBHNDL, %ID_OPTSLOW TO slow  '<- set slow/fast mode
    
           END SELECT
        END IF
 
     CASE %WM_PALETTECHANGED
        'if in 256 color mode, switching between app's with different palettes
        'can cause weird results. Trapping %WM_PALETTECHANGED and redrawing
        'entire dialog helps some. Maybe not the best solution, but..
        IF CBWPARAM <> CBHNDL THEN
           RedrawWindow CBHNDL, BYVAL 0, BYVAL 0, %RDW_INVALIDATE OR %RDW_UPDATENOW
        END IF
 
  END SELECT
END FUNCTION
