'
' Progressbar include file, PGBAR3D.INC, version 2, for PB/DLL
'
' Public Domain, by Borje Hagsten, September 2001
' (first released in March 2001 - this is version 2)
' Feel free to use and enhance, but as always - use at own risk..
' NOTE: save this file as PGBAR3D.INC in your PBWIN70\WINAPI folder. (or PBDLL6..)
'       See sample program, PGBAR3D.BAS, for tips on how to use it.
'
' LOG:
' Jan 14, 2003: Changed to DWORD for handles in some places and
'               now use GetWindowLong(hParent, %GWL_HINSTANCE)
'               to get proper instance handle at creation.
'
' NEW IN VERSION 2
' Now control looks good in 256 color mode too, thanks to own palette.
' New message, PGB_SETBARCOL replaces previous PGB_SETBARCOLMID and
' PGB_SETBARCOLEDGE. Makes it easier to set bar colors via color table,
' see messages below. New way to create control. No need to initialize
' control, just use CreatePGBar3D message directly. See sample on how
' to use it. Otherwise, trimmed code and improved some DC handling. 
'
' COMMENTS:
' PGBAR3D is pretty advanced. Can also be used as label, with possibility to
' set separate text on bar/background for nice "fade in/out" effects.
' If you have been using an older version of this control, I'm sorry if new
' the barcol message and way to create breaks old code. Should be quite easy
' to make changes according to the news in this version though.
'

' wParam colors for %PGB_SETBARCOL message
%PGB_SILVER = 0
%PGB_RED    = 1
%PGB_GREEN  = 2
%PGB_BLUE   = 3
%PGB_CYAN   = 4 'blue-green
%PGB_VIOLET = 5 'red-blue
%PGB_GOLD   = 6 'yellow
%PGB_BRONZE = 7 'brown

'custom control messages
%PGB_SETMAX         = %WM_USER + 100 'wParam sets max number of steps
%PGB_STEPUP         = %WM_USER + 103 'increases step while < max - wParam and lParam shall be 0
%PGB_STEPDN         = %WM_USER + 104 'decreases step while > 0   - wParam and lParam shall be 0
%PGB_SETVALUE       = %WM_USER + 105 'wParam sets progessbar value, lParam controls redraw
%PGB_BUILDBARS      = %WM_USER + 109 'build/rebuild the scrollbars, lParam controls redraw
%PGB_REFRESH        = %WM_USER + 110 'redraw the control - wParam and lParam shall be 0

%PGB_GETMAX         = %WM_USER + 120 'returns max number of steps
%PGB_GETVALUE       = %WM_USER + 121 'returns step value
%PGB_GETTXTON       = %WM_USER + 122 'returns txtOnOff value
%PGB_GETTXTPOS      = %WM_USER + 123 'returns text position in control
%PGB_GETTXTCOLBAR   = %WM_USER + 124 'returns bar text color
%PGB_GETTXTCOLBKG   = %WM_USER + 125 'returns background text color
%PGB_GETCOLBKG      = %WM_USER + 126 'returns background color
%PGB_GETBARCOL      = %WM_USER + 127 'returns bar color scheme
%PGB_GETBARDIR      = %WM_USER + 128 'returns bar direction, 0:left/right 1:upside down 2:bottom/top 3:top/bottom
%PGB_GETGRADIENTDIR = %WM_USER + 129 'returns gradient direction - 0:horizontal, 1:vertical
%PGB_GETTXTANGLE    = %WM_USER + 130 'returns rotated font

%PGB_SETTXTON       = %WM_USER + 150 'lParam sets: 0 = no text, 1 = auto text (%), 2 = custom text
%PGB_SETTXTBAR      = %WM_USER + 151 'wParam points to text text for bar, lParam controls redraw
%PGB_SETTXTBKG      = %WM_USER + 152 'wParam points to text text for background, lParam controls redraw
%PGB_SETTXTPOS      = %WM_USER + 153 'wParam sets text position in control
%PGB_SETTXTCOLBAR   = %WM_USER + 154 'wParam sets bar text color

%PGB_SETTXTCOLBKG   = %WM_USER + 155 'wParam sets background text color
%PGB_SETCOLBKG      = %WM_USER + 156 'wParam sets background color, lParam controls rebuild of control
%PGB_SETBARCOL      = %WM_USER + 157 'wParam sets bar color scheme, lParam controls rebuild of control
%PGB_SETBARDIR      = %WM_USER + 159 'wParam sets bar direction, 0:left/right 1:upside down 2:bottom/top 3:top/bottom, lParam controls rebuild of control
%PGB_SETGRADIENTDIR = %WM_USER + 160 'wParam sets gradient direction - 0:horizontal, 1:vertical, lParam controls rebuild of control
%PGB_SETTXTANGLE    = %WM_USER + 161 'wParam sets set rotated font, lParam controls rebuild of control

TYPE PGB3DDATA             'for storing control specific data in memory block
  pStep       AS LONG         'for tracking what step we are on
  pMax        AS LONG         'for storing max number of steps, usually 100 (%)
  hbBack      AS DWORD        'handle for background brush
  barDC       AS DWORD        'memCD for Progressbar
  barBit      AS DWORD        'handle to Progressbar bitmap
  barDC2      AS DWORD        'memCD for Progressbar buffer
  barBit2     AS DWORD        'handle to Progressbar buffer bitmap
  memDc       AS DWORD        'memCD for main buffer
  hBit        AS DWORD        'handle to main buffer bitmap
  hRotateFont AS DWORD        'handle to rotated font style
  hImageBar   AS DWORD        'bar image handle
  hImageBkg   AS DWORD        'background image handle
  direction   AS LONG         'bar direction - left to right, or right to left?
  gradientDir AS LONG         'gradient direction - left to right, or right to left?
  txtAngle    AS LONG         'store given text angle
  bkgColor    AS LONG         'background color
  barCol      AS LONG         'bar color scheme
  txtColBar   AS LONG         'custom text color in bar
  txtColBkg   AS LONG         'custom text color on background
  txtOnOff    AS LONG         '0 = no text, 1 = auto text (%), 2 = custom text
  txtPos      AS LONG         'text position in control, see DrawText API..
  txtBkg      AS ASCIIZ * 255 'text to be painted on background, increase/decrease size to suit your needs
  txtBar      AS ASCIIZ * 255 'text to be painted on bar, increase/decrease size to suit your needs
  PalClr(192) AS LONG         'array for color sceme used by the control
END TYPE

DECLARE FUNCTION CreateGradientBars(BYVAL hWnd AS DWORD) AS LONG
DECLARE FUNCTION CreatePGBar3D(BYVAL hParent AS DWORD, BYVAL id AS LONG, BYVAL txt AS STRING, _
                               BYVAL vLeft AS LONG, BYVAL vTop AS LONG, _
                               BYVAL vWidth AS LONG, BYVAL vHeight AS LONG, _
                               BYVAL wStyle AS LONG, BYVAL wStyleEx AS LONG, _
                               BYVAL DDTstyle AS LONG) AS DWORD

DECLARE FUNCTION PgbWndProc (BYVAL hWnd AS DWORD, BYVAL wMsg AS DWORD, _
                             BYVAL wParam AS LONG, BYVAL lParam AS LONG) AS LONG

'
' Create PGBAR3D control
'
FUNCTION CreatePGBar3D(BYVAL hParent AS DWORD, BYVAL id AS LONG, BYVAL txt AS STRING, _
                       BYVAL vLeft AS LONG, BYVAL vTop AS LONG, _
                       BYVAL vWidth AS LONG, BYVAL vHeight AS LONG, _
                       BYVAL wStyle AS LONG, BYVAL wStyleEx AS LONG, _
                       BYVAL DDTstyle AS LONG) AS DWORD

  LOCAL hBar AS DWORD, wc AS WNDCLASSEX, szClassName AS ASCIIZ * 10
  
  szClassName      = "PGBAR3D"
  IF GetClassInfoEx(GetModuleHandle(BYVAL %NULL), szClassName, wc) = 0 THEN
     wc.cbSize        = SIZEOF(wc)
     wc.lpfnWndProc   = CODEPTR(PgbWndProc)
     wc.cbWndExtra    = 4  'for pointer to user defined TYPE with control-specific data
     wc.hInstance     = GetWindowLong(hParent, %GWL_HINSTANCE)
     wc.hCursor       = LoadCursor(%NULL, BYVAL %IDC_ARROW )
     wc.lpszClassName = VARPTR(szClassName)

     CALL RegisterClassEx(wc)          'register PGBAR3D Class
     IF ERR THEN EXIT FUNCTION         'something went wrong, so bail out
  END IF

  IF DDTstyle THEN 'create control using dialog units measurements (DDT)
     CONTROL ADD "PGBAR3D", hParent, id, "", vLeft, vTop, vWidth, vHeight, wStyle, wStyleEx
     CONTROL HANDLE hParent, id TO hBar

  ELSE             'create control using pixels measurements (SDK/API..)
     hBar = CreateWindowEx(wStyleEx, "PGBAR3D", BYVAL 0, wStyle, _
                             vLeft, vTop, vWidth, vHeight, _
                             hParent, id, GetWindowLong(hParent, %GWL_HINSTANCE), BYVAL 0)
  END IF

  IF hBar AND LEN(txt) THEN SetWindowText hBar, BYVAL STRPTR(txt)

  FUNCTION = hBar 'return handle

END FUNCTION

'
' Progressbar procedure
'
FUNCTION PgbWndProc (BYVAL hWnd AS DWORD, BYVAL wMsg AS DWORD, _
                     BYVAL wParam AS LONG, BYVAL lParam AS LONG) AS LONG
  LOCAL pgb AS PGB3DDATA PTR
  IF wMsg <> %WM_CREATE THEN pgb = GetWindowLong(hWnd, 0) 'Get control specific data

  SELECT CASE wMsg
     CASE %WM_CREATE  'store control specific data, PGB3DDATA structure, in memory
        pgb = HeapAlloc(GetProcessHeap(), %HEAP_ZERO_MEMORY, SIZEOF(@pgb))
        IF pgb THEN
           SetWindowLong hWnd, 0, pgb     'Store the pointer for later use
        ELSE
           FUNCTION = -1 : EXIT FUNCTION  'failed to allocate memory, so return -1 to break the action
        END IF

        LOCAL hDC AS DWORD, xPos AS LONG, yPos AS LONG, _
              hFontOld AS DWORD, rc AS RECT, rcTxt AS RECT, _
              ps AS PAINTSTRUCT, lpSize AS SIZEL, tp AS ASCIIZ PTR

        @pgb.txtOnOff   = 0  'some initial values - can be changed via custom messages
        @pgb.txtPos     = %DT_SINGLELINE OR %DT_CENTER OR %DT_VCENTER OR %DT_NOCLIP OR %DT_NOPREFIX
        @pgb.txtColBar  = RGB(0, 0, 0)
        @pgb.txtColBkg  = RGB(255, 255, 0)
        @pgb.bkgColor   = RGB(128, 128, 128)              'Background color
        @pgb.barCol     = 0
        @pgb.hbBack     = CreateSolidBrush(@pgb.bkgColor) 'Background brush
        EXIT FUNCTION

'CUSTOM CONTROL MESSAGES
     CASE %PGB_STEPUP
        IF @pgb.pStep < @pgb.pMax THEN                    'step up while < max
           INCR @pgb.pStep
           SendMessage hWnd, %PGB_REFRESH, 0, 0           'repaint window (bar)
        END IF

     CASE %PGB_STEPDN
        IF @pgb.pStep > 0 THEN                              'step down while above 0
           DECR @pgb.pStep
           SendMessage hWnd, %PGB_REFRESH, 0, 0             'repaint window (bar)
        END IF

     CASE %PGB_SETVALUE
        @pgb.pStep = MIN&(@pgb.pMax, wParam)
        IF lParam THEN SendMessage hWnd, %PGB_REFRESH, 0, 0 'refresh if lParam says so

     CASE %PGB_BUILDBARS
        CALL CreateGradientBars(hWnd)                       'build the scrollbars
        IF lParam THEN SendMessage hWnd, %PGB_REFRESH, 0, 0 'refresh if lParam says so

     CASE %PGB_REFRESH                                      'redraw control
        InvalidateRect hWnd, BYVAL %NULL, 0 : UpdateWindow hWnd

'BAR SETTINGS
     CASE %PGB_SETMAX
        @pgb.pMax = wParam                                'set max number of steps

     CASE %PGB_GETMAX
        FUNCTION = @pgb.pMax : EXIT FUNCTION              'Get max number of steps

     CASE %PGB_GETVALUE
        FUNCTION = @pgb.pStep : EXIT FUNCTION             'return current step value

     CASE %PGB_SETCOLBKG
        @pgb.bkgColor = wParam                            'Set background color via wParam
        IF @pgb.hbBack THEN DeleteObject @pgb.hbBack      'delete old brush, if any
        @pgb.hbBack = CreateSolidBrush(@pgb.bkgColor)     'create background color brush
        IF lParam THEN SendMessage hWnd, %PGB_BUILDBARS, 1, 0 'refresh if lParam says so

     CASE %PGB_SETBARCOL
        @pgb.barCol = wParam * 24 + 1                       'Set bar color
        IF lParam THEN SendMessage hWnd, %PGB_BUILDBARS, 0, 1 'rebuild and refresh if lParam says so

     CASE %PGB_GETBARCOL
        FUNCTION = @pgb.barCol / 24 : EXIT FUNCTION         'return bar color scheme
        
     CASE %PGB_SETBARDIR
        @pgb.direction = wParam                             'left to right = 0, default
        IF lParam THEN SendMessage hWnd, %PGB_BUILDBARS, 0, 1 'rebuild and refresh if lParam says so

     CASE %PGB_GETBARDIR
        FUNCTION = @pgb.direction : EXIT FUNCTION           'return bar direction

     CASE %PGB_SETGRADIENTDIR
        @pgb.gradientDir = wParam                           'horizontal = 0, default
        IF lParam THEN SendMessage hWnd, %PGB_BUILDBARS, 0, 1 'rebuild and refresh if lParam says so

     CASE %PGB_GETGRADIENTDIR
        FUNCTION = @pgb.gradientDir : EXIT FUNCTION         'return gradient direction

'TEXT MESSAGES
     CASE %PGB_SETTXTON
        @pgb.txtOnOff = lParam                            'set text on/off

     CASE %PGB_GETTXTON
        FUNCTION = @pgb.txtOnOff : EXIT FUNCTION          'return txtOnOff setting

     CASE %PGB_SETTXTPOS
        @pgb.txtPos = wParam                              'set text position in control

     CASE %PGB_GETTXTPOS
        FUNCTION = @pgb.txtPos : EXIT FUNCTION            'return txtPos setting

     CASE %PGB_GETTXTCOLBAR
        FUNCTION = @pgb.txtColBar : EXIT FUNCTION         'return bar text color

     CASE %PGB_GETTXTCOLBKG
        FUNCTION = @pgb.txtColBkg : EXIT FUNCTION         'return background text color

     CASE %PGB_GETCOLBKG
        FUNCTION = @pgb.bkgColor : EXIT FUNCTION            'return background color

     CASE %PGB_SETTXTBAR
        tp = wParam
        @pgb.txtBar = @tp
        IF lParam THEN SendMessage hWnd, %PGB_REFRESH, 0, 0 'refresh if lParam says so

     CASE %PGB_SETTXTBKG
        tp = wParam
        @pgb.txtBkg = @tp
        IF lParam THEN SendMessage hWnd, %PGB_REFRESH, 0, 0 'refresh if lParam says so

     CASE %PGB_SETTXTCOLBAR
        @pgb.txtColBar = wParam                           'set bar's text color

     CASE %PGB_SETTXTCOLBKG
        @pgb.txtColBkg = wParam                           'set background's text color

     CASE %PGB_SETTXTANGLE
        LOCAL logF AS LOGFONT, tFont AS DWORD
        @pgb.txtAngle = wParam
        tFont = SendMessage(hWnd, %WM_GETFONT, 0, 0)
        IF tFont = %NULL THEN tFont = GetStockObject(%ANSI_VAR_FONT) 'null if system font..
        CALL GetObject(tFont, SIZEOF(logF), BYVAL VARPTR(logF) )

        logF.lfescapement  = wParam * 10   'angle is given in tenths of degrees
        logF.lforientation = wParam * 10   'both should be same
        logF.lfWeight = %FW_BOLD           'whatever, this one looks something like system font..
        logF.lfFaceName = "Arial"          'must be True Type font for rotation purposes
        @pgb.hRotateFont = CreateFontIndirect(logF) 'create the font and store its handle

        IF lParam THEN SendMessage hWnd, %PGB_BUILDBARS, 0, 1 'rebuild and refresh if lParam says so

     CASE %PGB_GETTXTANGLE
        FUNCTION = @pgb.txtAngle : EXIT FUNCTION          'return eventual text angle

'STANDARD CONTROL MESSAGES
     CASE %WM_ERASEBKGND: FUNCTION = 1: EXIT FUNCTION     'we handle background redraw ourselves

     CASE %WM_PAINT                                       'time to paint bar
        GetClientRect hWnd, rc                            'get size of control
        FillRect @pgb.memDC, rc, @pgb.hbBack              'clear background
        xPos = @pgb.pStep * rc.nright / @pgb.pMax         'pre-calculate, since often used
        yPos = @pgb.pStep * rc.nBottom / @pgb.pMax        'pre-calculate, since often used

        IF @pgb.txtOnOff THEN                             'WITH TEXT
           IF @pgb.txtOnOff = 1 THEN
              @pgb.txtBar = FORMAT$(@pgb.pStep) + "%"     'auto text to paint on bar
              @pgb.txtBkg = @pgb.txtBar                   'auto text to paint on background
           END IF
           rcTxt = rc                                          'copy rect for drawtext

           IF @pgb.hRotateFont THEN
              hFontOld = SelectObject(@pgb.memDC, @pgb.hRotateFont)  'store original font for later use
              hFontOld = SelectObject(@pgb.barDC2, @pgb.hRotateFont) 'is same in both DC's

              IF @pgb.direction = 1 THEN     'upside down
                 @pgb.txtPos = %DT_SINGLELINE OR %DT_CENTER OR %DT_VCENTER OR %DT_NOCLIP OR %DT_NOPREFIX
                 CALL GetTextExtentPoint32(@pgb.memDC, @pgb.txtBar, LEN(@pgb.txtBar), lpSize)
                 rcTxt.nBottom = rcTxt.nBottom + lpSize.cy * 2
                 rcTxt.nRight  = rcTxt.nRight + lpSize.cx * 2

              ELSEIF @pgb.direction = 2 THEN 'bottom to top
                 @pgb.txtPos = %DT_SINGLELINE OR %DT_LEFT OR %DT_VCENTER OR %DT_NOCLIP OR %DT_NOPREFIX
                 CALL GetTextExtentPoint32(@pgb.memDC, @pgb.txtBar, LEN(@pgb.txtBar), lpSize)
                 rcTxt.nLeft    = (rcTxt.nRight - lpSize.cy) / 2
                 rcTxt.nBottom = rcTxt.nBottom + lpSize.cx * 1.25

              ELSEIF @pgb.direction = 3 THEN 'top to bottom
                 @pgb.txtPos = %DT_SINGLELINE OR %DT_LEFT OR %DT_VCENTER OR %DT_NOCLIP OR %DT_NOPREFIX
                 CALL GetTextExtentPoint32(@pgb.memDC, @pgb.txtBar, LEN(@pgb.txtBar), lpSize)
                 rcTxt.nLeft = (rcTxt.nRight + lpSize.cy) / 2
                 rcTxt.nTop = rcTxt.nTop - lpSize.cx / 1.35
              END IF

           END IF

           BitBlt @pgb.barDC2, 0, 0, rc.nright, rc.nbottom, _
                  @pgb.barDC, 0, 0, %SRCCOPY                   'paint original bar to buffer

           SetTextColor @pgb.barDC2, @pgb.txtColBar                  'set color on bar
           DrawText @pgb.barDC2, @pgb.txtBar, -1, rcTxt, @pgb.txtPos 'draw text on bar

           SetTextColor @pgb.memDC, @pgb.txtColBkg                   'set color on background
           DrawText @pgb.memDC, @pgb.txtBkg, -1, rcTxt, @pgb.txtPos  'draw text on background

           IF @pgb.direction = 0 THEN 'LEFT TO RIGHT - WITH TEXT
              BitBlt @pgb.memDC, 0, 0, xPos, rc.nbottom, _
                     @pgb.barDC2, 0, 0, %SRCCOPY               'paint proper part of gradiant bar

           ELSEIF @pgb.direction = 1 THEN  'RIGHT TO LEFT - WITH TEXT
              BitBlt @pgb.memDC, rc.nright - xPos, 0, xPos, rc.nbottom, _
                     @pgb.barDC2, rc.nright - xPos, 0, %SRCCOPY

           ELSEIF @pgb.direction = 2 THEN  'BOTTOM TO TOP - WITH TEXT
              BitBlt @pgb.memDC, 0, rc.nbottom - yPos, rc.nright, rc.nbottom, _
                     @pgb.barDC2, 0, rc.nbottom - yPos, %SRCCOPY

           ELSEIF @pgb.direction = 3 THEN  'TOP TO BOTTOM - WITH TEXT
              BitBlt @pgb.memDC, 0, 0, rc.nright, yPos, _
                     @pgb.barDC2, 0, 0, %SRCCOPY

           END IF

        ELSE                                               'WITHOUT TEXT
           IF @pgb.direction = 0 THEN      'LEFT TO RIGHT - NO TEXT
              BitBlt @pgb.memDC, 0, 0, xPos, rc.nbottom, _
                     @pgb.barDC, 0, 0, %SRCCOPY                'paint proper part of gradiant bar

           ELSEIF @pgb.direction = 1 THEN  'RIGHT TO LEFT - NO TEXT
              BitBlt @pgb.memDC, rc.nright - xPos, 0, xPos, rc.nbottom, _
                     @pgb.barDC, rc.nright - xPos, 0, %SRCCOPY

           ELSEIF @pgb.direction = 2 THEN  'BOTTOM TO TOP - NO TEXT
              BitBlt @pgb.memDC, 0, rc.nbottom - yPos, rc.nright, rc.nbottom, _
                     @pgb.barDC, 0, rc.nbottom - yPos, %SRCCOPY

           ELSEIF @pgb.direction = 3 THEN  'TOP TO BOTTOM - NO TEXT
              BitBlt @pgb.memDC, 0, 0, rc.nright, yPos, _
                     @pgb.barDC, 0, 0, %SRCCOPY

           END IF

        END IF

        BeginPaint hWnd, ps                               'begin screen painting
        IF @pgb.PalClr(0) THEN                            'if we have palette (256 color mode)
           SelectPalette ps.hDC, @pgb.PalClr(0), 0        'then use it in DC..
           RealizePalette ps.hDC
        END IF

        BitBlt ps.hDC, 0, 0, rc.nright, rc.nbottom, _
               @pgb.memDC, 0, 0, %SRCCOPY                 'paint it all to screen

        IF hFontOld THEN
            CALL SelectObject(@pgb.memDC, hFontOld)       'select the original font back
            CALL SelectObject(@pgb.barDC2, hFontOld)      'was the same in both DC's
        END IF

        EndPaint hWnd, ps                                 'finish up
        FUNCTION = 0 : EXIT FUNCTION

     CASE %WM_DESTROY                                     'clean up, to avoid nasty memory leaks
        IF @pgb.hRotateFont THEN DeleteObject @pgb.hRotateFont 'may be a stockobject, but doesn't matter
        IF @pgb.hbBack      THEN DeleteObject @pgb.hbBack          'delete brush
        IF @pgb.hbit        THEN DeleteObject SelectObject(@pgb.memDC, @pgb.hbit)
        IF @pgb.memDC       THEN DeleteDC @pgb.memDC               'and memory DC's + bitmaps
        IF @pgb.barBit      THEN DeleteObject SelectObject(@pgb.barDC, @pgb.barBit)
        IF @pgb.barDC       THEN DeleteDC @pgb.barDC
        IF @pgb.barBit2     THEN DeleteObject SelectObject(@pgb.barDC2, @pgb.barBit2)
        IF @pgb.barDC2      THEN DeleteDC @pgb.barDC2
        IF @pgb.PalClr(0)   THEN DeleteObject @pgb.PalClr(0)
        CALL HeapFree(GetProcessHeap(), 0, BYVAL pgb)          'free memory
        FUNCTION = 0 : EXIT FUNCTION

  END SELECT

  FUNCTION = DefWindowProc(hWnd, wMsg, wParam, lParam)
END FUNCTION

'
' Create actual ProgressBar, based on previously made settings
' Note: one could also load a couple of bitmaps here instead,
' for some terrific effects.. :-)
'
FUNCTION CreateGradientBars(BYVAL hWnd AS DWORD) AS LONG
  LOCAL hDC AS DWORD, ic AS LONG, jj AS LONG, hPen AS DWORD, _
        kk AS SINGLE, L AS SINGLE, rc AS RECT, pgb AS PGB3DDATA PTR
  pgb = GetWindowLong(hWnd, 0)                        'Get control specific data

  IF @pgb.hbit    THEN DeleteObject SelectObject(@pgb.memDC, @pgb.hbit)
  IF @pgb.memDC   THEN DeleteDC @pgb.memDC            'delete old memDC's and bitmaps, if any
  IF @pgb.barBit  THEN DeleteObject SelectObject(@pgb.barDC, @pgb.barBit)
  IF @pgb.barDC   THEN DeleteDC @pgb.barDC
  IF @pgb.barBit2 THEN DeleteObject SelectObject(@pgb.barDC2, @pgb.barBit2)
  IF @pgb.barDC2  THEN DeleteDC @pgb.barDC2

  GetClientRect hWnd, rc                               'get control height and width

  hDC = GetDc(hWnd)
  IF hDC THEN                                          'create 3 compatible memory DC's based on
     @pgb.memDC   = CreateCompatibleDC(hDC)            'control's DC, for faster action in WM_PAINT
     @pgb.hbit    = CreateCompatibleBitmap(hDC, rc.nRight, rc.nBottom)
     @pgb.hbit    = SelectObject(@pgb.memDC, @pgb.hbit)
     @pgb.barDC   = CreateCompatibleDC(hDC)
     @pgb.barBit  = CreateCompatibleBitmap(hDC, rc.nRight, rc.nBottom)
     @pgb.barBit  = SelectObject(@pgb.barDC, @pgb.barBit)
     @pgb.barDC2  = CreateCompatibleDC(hDC)
     @pgb.barBit2 = CreateCompatibleBitmap(hDC, rc.nRight, rc.nBottom)
     @pgb.barBit2 = SelectObject(@pgb.barDC2, @pgb.barBit2)
     SetBkMode @pgb.memDC, %TRANSPARENT                  'set text background modes
     SetBkMode @pgb.barDC2, %TRANSPARENT

'------------------------------------------------------------------------------
' 'need own palette if in 256 color mode
'------------------------------------------------------------------------------
     jj = 1
     FOR ic = 117 TO 255 STEP 6         '0, gray table 1-24
        @pgb.PalClr(jj) = RGB(ic, ic, ic) : INCR jj
     NEXT
     FOR ic = 117 TO 255 STEP 6         '1, red table 25-48
        @pgb.PalClr(jj) = RGB(ic, ic - 117, ic - 117) : INCR jj
     NEXT
     FOR ic = 117 TO 255 STEP 6         '2, green table 49-72
        @pgb.PalClr(jj) = RGB(ic - 117, ic, ic - 117) : INCR jj
     NEXT
     FOR ic = 117 TO 255 STEP 6         '3, blue table 73-96
        @pgb.PalClr(jj) = RGB(ic - 117, ic - 117, ic) : INCR jj
     NEXT
     FOR ic = 117 TO 255 STEP 6         '4, blue-green table 97-120
        @pgb.PalClr(jj) = RGB(ic - 117, ic, ic) : INCR jj
     NEXT
     FOR ic = 117 TO 255 STEP 6         '5, violet table 121-144
        @pgb.PalClr(jj) = RGB(ic, ic - 117, ic) : INCR jj
     NEXT
     FOR ic = 117 TO 255 STEP 6         '6, gold table 145-168
        @pgb.PalClr(jj) = RGB(MIN&(ic + 64, 255), ic, ic - 117) : INCR jj
     NEXT
     FOR ic = 117 TO 255 STEP 6         '7, brown table 169-192
        @pgb.PalClr(jj) = RGB(MIN&(ic + 16, 255), ic - 48, ic - 117) : INCR jj
     NEXT
     DECR jj

     IF GetDeviceCaps(hDC, %NUMCOLORS) > -1 AND _ 'if needed, create own palette
     (GetDeviceCaps(hDC, %RASTERCAPS) AND %RC_PALETTE) = %RC_PALETTE THEN
        IF @pgb.PalClr(0) THEN DeleteObject @pgb.PalClr(0)
        @pgb.PalClr(0) = MAKLNG(&H0300, jj)
        @pgb.PalClr(0) = CreatePalette (BYVAL VARPTR(@pgb.PalClr(0)))
        FOR ic = 1 TO jj
           @pgb.PalClr(ic) = @pgb.PalClr(ic) + &H02000000
        NEXT
     END IF
     ReleaseDc hWnd, hDC                                   'release the temporary DC

     IF @pgb.PalClr(0) THEN 'if we have palette (256 color mode), then use it in memDCs..
        SelectPalette @pgb.barDC, @pgb.PalClr(0), 0
        RealizePalette @pgb.barDC
        SelectPalette @pgb.barDC2, @pgb.PalClr(0), 0
        RealizePalette @pgb.barDC2
     END IF

'------------------------------------------------------------------------------
     IF @pgb.gradientDir = 0 THEN 'HORIZONTAL BAR
        jj = rc.nBottom - 1
     ELSE                         'VERTICAL BAR
        jj = rc.nRight - 1
     END IF
     kk = @pgb.barCol
     L = 1 / ((jj / 2) / 24)       'calculate steps for color

     FOR ic = 0 TO jj                                      'draw the whole gradient bar
        hPen = CreatePen(%PS_SOLID, 1, @pgb.PalClr(INT(kk))) 'create pen
        hPen = SelectObject(@pgb.barDC, hPen)             'select pen into DC, store original pen
        IF @pgb.gradientDir = 0 THEN                      'HORIZONTAL BAR
           MoveTo @pgb.barDC, 0, ic                       'move into position
           LineTo @pgb.barDC, rc.nRight, ic               'and draw a line from left to right
        ELSE                                              'VERTICAL BAR
           MoveTo @pgb.barDC, ic, 0                       'move into position
           LineTo @pgb.barDC, ic, rc.nBottom              'and draw a line from top to bottom
        END IF
        DeleteObject SelectObject(@pgb.barDC, hPen)       'delete pen to avoid memory leaks

        IF ic < jj / 2 -1 THEN
           kk = MIN(@pgb.barCol + 23, kk + L)
        ELSE
           kk = MAX(@pgb.barCol, kk - L)
        END IF
     NEXT

     FUNCTION = %TRUE                                      'return true on success
  END IF

END FUNCTION
