const database = [
  {"id":"true","group":"system macro","action":"insert -1","use":"universal value for boolean true","related":"false, not__bits, not__conditional","example":"int a=true"},
  {"id":"false","group":"system macro","action":"insert 0","use":"universal value for boolean false","related":"true, not__bits, not__conditional","example":"int a=false"},
  {"id":"#view","group":"directives","action":"creates a window for compiler listings.","use":"Allows the programmer to see a selected part of the compiled code","related":"#show","example":"sys a,b,c"},
  {"id":"version","group":"info","action":"returns current version number and DateTimeStamp.","use":"identification of version","related":"o2version","example":"print version"},
  {"id":"o2version","group":"info","action":"returns current version number.","use":"version matching","related":"version","example":"$ rtlversion \"0.2.1\""},
  {"id":"lobyte","group":"system macro","action":"return the lower 8 bits of an integer expression","use":"","related":"hibyte, loword, hiword","example":"wl=lobyte(wParam)"},
  {"id":"loword","group":"system macro","action":"return the lower 16 bits of an integer expression","use":"","related":"hiword, hibyte, lobyte","example":"wl=loword(wParam)"},
  {"id":"hibyte","group":"system macro","action":"return bits 8..15 of an integer expression","use":"","related":"lobyte, loword, hiword","example":"wh=hibyte(wParam)"},
  {"id":"hiword","group":"system macro","action":"return bits 16..31 of an integer expression","use":"","related":"loword, lobyte, hibyte","example":"wh=hiword(wParam)"},
  {"id":"redim","group":"system macro","action":"create or resize a dynamic array, preserving contents within range","use":"extend or reduce an array size at run-time","related":"dim, new, indexbase","example":"redim string s(n)"},
  {"id":"new","group":"system macro","action":"create a dynamic object and call its constructor method.","use":"to create and initialise objects","related":"Classes, del, dim","example":""},
  {"id":"del","group":"system macro","action":"Call a dynamic object's destructor method and disallocate its memory block.","use":"to delete objects","related":"Classes, new, redim","example":"del cuboid"},
  {"id":"terminate","group":"system macro","action":"Deallocate all Strings, static variables and free DLL libraries (at end of program).","use":"explicit termination of program","related":"freestrings, freelibs","example":"terminate"},
  {"id":"freestrings","group":"system macro","action":"deallocate all remaining static strings only (at end of program)","use":"allow the program to terminate without freeing libraries","related":"terminate, freelibs","example":"freestrings"},
  {"id":"freelibs","group":"system macro","action":"free all loaded DLL libraries only (at end of program)","use":"allow the program to terminate but all static strings are retained","related":"terminate, freestrings","example":"freelibs"},
  {"id":"right","group":"system macro","action":"returns right part of a string by length","use":"string=right(sourcestring, length)","related":"left, mid, ltrim, rtrim","example":"s=right(\"abcdef\",3)"},
  {"id":"reindex","group":"system macro","action":"create an index for a data array","use":"filter and index a set of data, with user-defined criteria","related":"","example":""},
  {"id":"getmemory","group":"low level oxygen functions","action":"allocate block of memory and return its base address","use":"address=getmemory bytes","related":"freememory, news, frees","example":"m=getmemory 8000"},
  {"id":"freememory","group":"low level oxygen functions","action":"free previously allocated memory block","use":"freememory address","related":"getmemory, news, frees","example":"freememory m"},
  {"id":"loadlibrary","group":"low level oxygen functions","action":"load a library (if not already loaded) and return its handle","use":"handle=loadlibrary \"library filename\"","related":"freelibrary, library, getprocaddress","example":"h=loadlibrary \"kernel32.dll\""},
  {"id":"freelibrary","group":"low level oxygen functions","action":"free library","use":"freelibrary handle","related":"loadlibrary, library, getprocaddress","example":"freelibrary h"},
  {"id":"getprocaddress","group":"low level oxygen functions","action":"get procedure address","use":"getprocaddress libraryHandle \"proc name\"","related":"loadlibrary, freelibrary, library","example":"a=getprocaddress h, \"AllocConsole\""},
  {"id":"copy","group":"low level oxygen functions","action":"copy null terminated string to another location","use":"copy DestinationAddress, SourceAddress","related":"copy00, copy","example":"copy0 &a,&b"},
  {"id":"copy","group":"low level oxygen functions","action":"copy null terminated string of wide (2 byte) characters to another location","use":"copy DestinationAddress, SourceAddress","related":"copy0, copy, copyn","example":"copy00 &v,&w"},
  {"id":"copyn","group":"low level oxygen functions","action":"string to another location by a specified number of bytes","use":"copy DestinationAddress, SourceAddress, NumberOfBytes","related":"copy0, copy00","example":"copy &dest,&src,n"},
  {"id":"mbox","group":"low level oxygen functions","action":"display message null-terminated ascii string","use":"mbox String-expression","related":"print, str","example":"mbox \"Value \" v"},
  {"id":"comparestr","group":"low level oxygen functions","action":"compare first string with second string","use":"comparestr bstr1, bstr2 : jg ifgreater : jl ifless : jz ifequal","related":"string, char, str","example":"comparestr bs1,bs2"},
  {"id":"exit","group":"common x86 assembly instructions","action":"return length of variable element (in bytes)","use":"nbytes=sizeof variable","related":"offsetof, spanof, typeof typecodeof","example":"n=sizeof a"},
  {"id":"offsetof","group":"variable and type attributes","action":"return offset of variable from index register","use":"nbytes=offsetof variable","related":"sizeof, spanof, typeof, typecodeof, recordof","example":"n=offsetof a"},
  {"id":"spanof","group":"variable and type attributes","action":"return span of array variable dimension","use":"nbytes=spanof variable dimension","related":"sizeof, bytesof,offsetof, typeof, typecodeof, recordof","example":"dim as long v(10) : n=spanof v"},
  {"id":"bytesof","group":"variable and type attributes","action":"return space used by an array variable","use":"nbytes=spanof variable dimensionion","related":"sizeof, spanof, offsetof, typeof, typecodeof, recordof","example":"dim as long v(10) : n=bytesof v"},
  {"id":"typeof","group":"variable and type attributes","action":"return name of the variable type","use":"name=typeof variable","related":"typecodeof sizeof, offsetof, spanof, recordof","example":"dim as long v : s=typeof v"},
  {"id":"structureof","group":"variable and type attributes","action":"return data structure of compund (UDT) or variabe","use":"obtain data for diagnostics or reflective programming","related":"prototypeof sizeof, offsetof, spanof, typeof, typecodeof, recordof, #recordof","example":"type vt long v,double d"},
  {"id":"encodingof","group":"variable and type attributes","action":"return the operand encoding of a variable or macro","use":"obtain data for diagnostics or reflective programming","related":"prototypeof, sizeof, offsetof, spanof, typeof, typecodeof, recordof, #recordof","example":"sys v"},
  {"id":"prototypeof","group":"variable and type attributes","action":"return prototype(s) of functions, subs and high level macros","use":"obtain data for diagnostics or reflective programming","related":"recordof, sizeof, offsetof, spanof, typeof, typecoedof, #recordof","example":""},
  {"id":"typecodeof","group":"variable and type attributes","action":"return type code number of variables and literals.","use":"obtain data for diagnostics or reflective programming","related":"typeof recordof, sizeof, offsetof, spanof, prototypeof, #recordof","example":""},
  {"id":"recordof","group":"variable and type attributes","action":"return record of compound (UDT) variable","use":"obtain data for diagnostics or reflective programming","related":"#recordof prototypeof, sizeof, offsetof, spanof, typeof, typecodeof, #recordof","example":"type vt long v,double d"},
  {"id":"strptr","group":"variable and type attributes","action":"return a string pointer","use":"obtain base address of string contents","related":"typecodeof, addr","example":"string s=\"Hello\""},
  {"id":"lpartof","group":"variable and type attributes","action":"return left part of dotted name","use":"exract main part from dotted name","related":"rpartof, vtypeof","example":"lpartof(a.b.c).x 'returns a.x"},
  {"id":"rpartof","group":"variable and type attributes","action":"return mid part of dotted name","use":"exract part from dotted name, for use","related":"lpartof, vtypeof","example":"rpartof(a.b.c) 'returns b.c"},
  {"id":"vtypeof","group":"variable and type attributes","action":"return typename of variable","use":"refer to variable type , for use","related":"lpartof, rpartof, sizeof","example":"double a"},
  {"id":"incl","group":"Oxygen keywords","action":"expand macro non recursively without parameter substitutions","use":"incl aMacro","related":"def","example":"def helo \"hello \" %1"},
  {"id":"#semicolon","group":"Oxygen keywords","action":"switch use of semicolon as comment marker or separator","use":"so semicolons can be recognised as separators when using C syntax","related":"#case, indexbase","example":"#semicolon separator"},
  {"id":"retn","group":"Oxygen keywords","action":"macro ret n. Releases correct number of bytes at end of procedure (in stdcall convention)","use":"internal","related":"ret, return, function","example":""},
  {"id":"with","group":"Oxygen keywords","action":"specify a variable name prefix for assignments","use":"Allows long names to be shortened when assigning values","related":"","example":"dim as vector4 vectorI"},
  {"id":"o","group":"Oxygen keywords","action":"start a block of o2 machine code notation","use":"inserting inline machine code and other binary data.","related":"Blocks","example":"o2 b8 00 01 00 00 'machine code for mov eax,256"},
  {"id":"bind","group":"Oxygen keywords","action":"bind a list of procedures from a Dynamic Link Library (DLL)","use":"for low level (without protoype) calls to DLL functions.","related":"loadlibrary, freelibrary, getprocaddress, declare, library","example":""},
  {"id":"enum","group":"Oxygen keywords","action":"create an enumeration","use":"assign a numeric identity to a name","related":"typedef, enum, #define, (%)","example":""},
  {"id":"def","group":"Oxygen keywords","action":"define a low level macro","use":"","related":"macro, #define, deff","example":""},
  {"id":"type","group":"Oxygen keywords","action":"define a compound variable type","use":"","related":"typedef, struct, class","example":""},
  {"id":"struct","group":"Oxygen keywords","action":"define a compound variable type (C Syntax)","use":"","related":"type, typedef, class","example":""},
  {"id":"class","group":"Oxygen keywords","action":"define a class (strucure and methods for objects)","use":"","related":"Classes, type, new, del","example":""},
  {"id":"var","group":"Oxygen keywords","action":"define a set of variables","use":"low-level dimensioning of variables","related":"dim","example":"var string s,t,u(64),v"},
  {"id":"include","group":"Oxygen keywords","action":"include source code from another file","use":"used for including header files and other files of source code","related":"uses, includepath, embedfile","example":"#include \"rtl32.inc\""},
  {"id":"use","group":"Oxygen keywords","action":"include source code from another file","use":"for including header files and other files of source code","related":"include, includepath, embedfile","example":"uses RTL32 'include once \"RTL32.inc\""},
  {"id":"packed","group":"Oxygen keywords","action":"prevent padding between members of a type or typedef","use":"allow programmer to have full control over padding to align the members","related":"type, typedef, struct","example":""},
  {"id":"_def","group":"Oxygen keywords","action":"define a low level system macro","use":"","related":"","example":""},
  {"id":"includepath","group":"Oxygen keywords","action":"define a filepath for source files specified by include.","use":"","related":"include, librarypath","example":""},
  {"id":"librarypath","group":"Oxygen keywords","action":"define a filepath for DLL files","use":"tells the computer where to find Dynamic Link Libraries","related":"library, extern, includepath","example":""},
  {"id":"#file","group":"Oxygen keywords","action":"specifiy a filename for compiled code ( .EXE or .DLL )","use":"creates an executable .EXE or  Dynamic Link Library .DLL file","related":"","example":"#file FileName independent 64 bit"},
  {"id":"embedfile","group":"Oxygen keywords","action":"specifiy a file to be embedded in the data section","use":"store data file in a program, and get a pointer to it.","related":"include, strptr, getfile","example":"sys dat : embedfile \"data.txt\",dat"},
  {"id":"quote","group":"Oxygen keywords","action":"specify tagname for superquotes","use":"supports almost unlimited nesting of quotes. Can be used for containing","related":"\"    `","example":"quote !!! this quote contains other quotes \"containing \"other quotes\"   \" !!!"},
  {"id":"typedef","group":"Oxygen keywords","action":"define a set of types (C syntax)","use":"create type definitions for creating other types","related":"type, struct, class, union, enum","example":""},
  {"id":"union","group":"Oxygen keywords","action":"define a union (C syntax)","use":"allows different variables to occupy the same space.","related":"typedef, type, struct, class, enum","example":""},
  {"id":"#case","group":"directives","action":"specify mode of case sensitivity.","use":"case can be sensitive, insensitive, or capital","related":"#semicolon, indexbase","example":""},
  {"id":"#lookahead","group":"directives","action":"internally creates header declarations for all procedures.","use":"allows procedure calls to forward reference","related":"scope","example":""},
  {"id":"#autodim","group":"directives","action":"enable variables to be created without a Dim statement","use":"for mall, informal programs.","related":"","example":"#autodim on"},
  {"id":"#alert","group":"directives","action":"generates a compiler message (like an error)","use":"used to alert programmer about an area of code","related":"#error, #print","example":"#alert (please implement methods for this interface)"},
  {"id":"#error","group":"directives","action":"generates a compiler error message","use":"used to alert programmer about inconsistencies","related":"#alert, #print","example":"#error (please implement methods for this interface)"},
  {"id":"#pragma","group":"directives","action":"ignored (C style compiler directives)","use":"compilers use it for platform or compiler-specific mode changes","related":"","example":"#pragma warning(push)"},
  {"id":"#unique","group":"directives","action":"flags an error if a a symbol definition is not unique (in the same nesting level)","use":"prevent symbols from being redefined","related":"","example":"#unique enabled"},
  {"id":"#console","group":"directives","action":"programs compiled to EXE/DLL will run in an existing console (MS Subsystem 3)","use":"prevents new console from being created. Inputs and outputs are with the existing console.","related":"","example":"#console"},
  {"id":"#show","group":"directives","action":"displays the translated code of a statement during compilation","use":"Allows the programmer to see a selected part of the compiled code","related":"#view","example":"sys a,b,c"},
  {"id":"@","group":"operators","action":"return the address of a variable","use":"reading writing data of variables and arrays of variables, by reference","related":"*, ?, strptr, addr","example":"int a=42"},
  {"id":"*","group":"operators","action":"return the integer value located by the address contained in the variable","use":"reading writing data, using pointers","related":"@, ?, strptr, addr","example":"int a=42"},
  {"id":"?","group":"operators","action":"return the integer value contained in the variable","use":"casting variables as integers","related":"cast, *, @, strptr, addr","example":"float f=100"},
  {"id":"addr","group":"directives","action":"resolve address of a variable (assembler)","use":"load address of a variable to a register","related":"@, *, ?, strptr","example":"sys a"},
  {"id":"cast","group":"operators","action":"change or specify the type of a variable temporarily, in an expression","use":"","related":"convert, ?, union","example":"float f=100"},
  {"id":"convert","group":"operators","action":"explicitly convert the type of an expression.","use":"pass values, in the required type, to an unprototyped function","related":"cast","example":"float f=2.5"},
  {"id":"#compact","group":"directives","action":"remove unused code","use":"minimise size of compiled binaries","related":"#file","example":""},
  {"id":"let","group":"Oxygen Basic structures","action":"defines a variable or object","use":"create a new variable or indirect object","related":"dim, var","example":"let s=\"this is a string\""},
  {"id":"const","group":"Oxygen Basic keywords","action":"create read-only variables","use":"constants","related":"dim, #unique","example":""},
  {"id":"dim","group":"Oxygen Basic keywords","action":"define a set of variables","use":"create variables and arrays of variables with optional initial values","related":"local, static, redim, let, var, const","example":""},
  {"id":"local","group":"Oxygen Basic keywords","action":"define a local set of variables","use":"","related":"dim, static","example":""},
  {"id":"static","group":"Oxygen Basic keywords","action":"define a static set of variables, (persistant but invisible outsid the block)","use":"","related":"dim, local","example":""},
  {"id":"!","group":"Oxygen Basic keywords","action":"declare a procedure with its prototype (may be external or declared in advance)","use":"","related":"declare, library, lib, alias, dim","example":""},
  {"id":"declare","group":"Oxygen Basic keywords","action":"declare a procedure with its prototype (may be external or declared in advance)","use":"","related":"!, library, lib, alias, dim","example":""},
  {"id":"function","group":"Oxygen Basic keywords: procedures","action":"define a function","use":"","related":"Procedures, sub, method","example":""},
  {"id":"sub","group":"Oxygen Basic keywords: procedures","action":"define a procedure. (like a function but not returning a value)","use":"","related":"Procedures, function, method","example":""},
  {"id":"method","group":"Oxygen Basic keywords: procedures","action":"","use":"define a procedure for objects.","related":"Procedures, function, sub, methods","example":""},
  {"id":"operator","group":"keywords: operators","action":"define a customised operator","use":"for operations between objects and other user defined types","related":"type, class, macro","example":""},
  {"id":"if","group":"Oxygen Basic: control structures","action":"start a conditional block with a test","use":"conditional execution","related":"Conditionals, then, else, elseif, endif, while","example":""},
  {"id":"then","group":"Oxygen Basic: control structures","action":"starts the conditional block where the prior test is met.","use":"conditional execution","related":"Conditionals, if, elseif, endif","example":""},
  {"id":"else","group":"Oxygen Basic: control structures","action":"starts the alternative block where none of the prior conditions are met","use":"conditional execution","related":"Conditionals, if, elseif, endif","example":""},
  {"id":"elseif","group":"Oxygen Basic: control structures","action":"make an alternative test if the previous condition was not met.","use":"conditional execution","related":"Conditionals, if, else, endif select, case","example":""},
  {"id":"endif","group":"Oxygen Basic: control structures","action":"end the conditional block","use":"conditional execution","related":"Conditionals, if, then, elseif, else, end if","example":""},
  {"id":"endselect","group":"Oxygen Basic: control structures","action":"end the select block","use":"","related":"Selection, select, switch, case","example":""},
  {"id":"do","group":"Oxygen Basic: control structures","action":"start a block for repetition (looping)","use":"","related":"Loops, while, continue, exit, enddo, loop","example":""},
  {"id":"while","group":"Oxygen Basic: control structures","action":"start a block for conditional repetition","use":"","related":"Loops, do, continue, exit, wend, enddo","example":""},
  {"id":"loop","group":"Oxygen Basic: control structures","action":"end a do repeating block","use":"","related":"Loops, do, continue, exit","example":""},
  {"id":"repeat","group":"Oxygen Basic: control structures","action":"goto the beginning of a do/while block","use":"","related":"Loops, do, continue, exit","example":""},
  {"id":"enddo","group":"Oxygen Basic: control structures","action":"end a do  repeating block","use":"","related":"Loops, while, do, loop, continue, exit","example":""},
  {"id":"endwhile","group":"Oxygen Basic: control structures","action":"end a while block","use":"","related":"Loops, do, while, continue, exit","example":""},
  {"id":"exit","group":"Oxygen Basic: control structures","action":"exit a do  while for  (...) block immediately","use":"leave a loop, usually after a condition has been met","related":"Loops, do, while, continue, repeat","example":""},
  {"id":"continue","group":"Oxygen Basic: control structures","action":"go back to the beginning of a do, while or for block","use":"to \"short circuit\" a loop","related":"Loops, do, while, for, break, exit, wend, enddo, repeat","example":""},
  {"id":"break","group":"","action":"exit a switch block or do/while block","use":"","related":"case, switch, while, do, continue","example":""},
  {"id":"switch","group":"Oxygen Basic: control structures","action":"Start a Case block (C style)","use":"","related":"Selection, case, endselect, end","example":""},
  {"id":"case","group":"Oxygen Basic: control structures","action":"specify a case to match followed by actions to perform","use":"","related":"Selection, select, endselect, end","example":""},
  {"id":"for","group":"Oxygen Basic: control structures","action":"start an iteration block","use":"","related":"Iteration, to, step, next","example":""},
  {"id":"to","group":"Oxygen Basic: control structures","action":"specify limit of an iteration","use":"","related":"Iteration, for, step, next","example":""},
  {"id":"step","group":"Oxygen Basic: control structures","action":"specify increment of an iteration","use":"for iterator = start to end step step increment","related":"Iteration, for, to, next","example":"for i=1 to 10 step 2 : ... : next"},
  {"id":"next","group":"Oxygen Basic: control structures","action":"end iteration block","use":"","related":"Iteration, for, to, step","example":""},
  {"id":"goto","group":"Oxygen Basic: control structures","action":"jump to a specified label in the code","use":"","related":"jmp, gosub","example":""},
  {"id":"gosub","group":"Oxygen Basic: procedures","action":"call a labelled subroutine","use":"invoke subroutines inside a procedure","related":"Procedures, subroutine, call, goto","example":""},
  {"id":"subroutine","group":"Oxygen Basic: procedures","action":"define a subroutine","use":"formally define subroutines inside a procedure","related":"Procedures ,gosub, call, goto","example":""},
  {"id":"methods","group":"procedures block","action":"start a methods block for a class of objects.","use":"","related":"method, class","example":""},
  {"id":"return","group":"Oxygen Basic: procedures","action":"exit from a procedure returning a value (in a function or method)","use":"","related":"Procedures, ret","example":"float product(float a,b) { return a*b }"},
  {"id":"%","group":"Oxygen Basic: macros","action":"define an equate","use":"as a single-line macro","related":"Equates, Macros, #define. #def. def,deff","example":""},
  {"id":"intern","group":"Oxygen Basic: code structures","action":"define a block to go inside a class methods block","use":"provide a block for class private functions etc","related":"Blocks, class, methods, scope","example":""},
  {"id":"scope","group":"Oxygen Basic: code structures","action":"start a scope","use":"create a block where variables and functions may be locally defined","related":"Blocks, namespace","example":":"},
  {"id":"module","group":"Oxygen Basic: code structures","action":"define a module block","use":"create a block of deployable code","related":"interface, inner, namespace","example":""},
  {"id":"interface","group":"Oxygen Basic: code structures","action":"mark the start of shared code","use":"define shareable code in a module","related":"module, inner, namespace","example":""},
  {"id":"namespace","group":"Oxygen Basic: code structures","action":"start a namspace","use":"create a region where symbols are locally defined","related":"module, inner","example":"'"},
  {"id":"indexbase","group":"Oxygen Basic: directives","action":"define the index base for an array","use":"most software assumes an indexbase of 0 or 1","related":"dim, #case, #semicolon","example":"indexbase 0"},
  {"id":"#majorminor","group":"Oxygen Basic: directives","action":"sets storage order for arrays","use":"row-major array compatibility","related":"#minormajor, indexbase, dim","example":""},
  {"id":"#minormajor","group":"Oxygen Basic: directives","action":"sets storage order for arrays","use":"column-major array compatibility","related":"#majorminor, indexbase, dim","example":""},
  {"id":"lib","group":"Oxygen Basic: directives","action":"specify the name of a DLL library to associate","use":"","related":"declare","example":"lib \"kernel32.dll\""},
  {"id":"extern","group":"Oxygen Basic: linkage","action":"associate declared procedures with a calling convention and/or dll name","use":"","related":"lib, library, calling_conventions","example":""},
  {"id":"that","group":"Objects","action":"suppress automatic \"this\" prefix inside OOP methods","use":"resolving name conflict between an object member and another variable","related":"method, this","example":"this.voice=that voice"},
  {"id":"this","group":"Objects","action":"explicitly refer to an object's own members","use":"distinguish a member from a local variable, param or function of the same name","related":"method, class, that","example":"this.len=len(s)"},
  {"id":"#noprec","group":"Oxygen Basic: directives","action":"directive to evaluate an expression from left to right, ignoring standard operator precedence rules.","use":"","related":"#noinit, indexbase, #byref, #byval, #assign","example":""},
  {"id":"#noinit","group":"Oxygen Basic: directives","action":"prevent variables from being automatically initialised to nul within a procedure","use":"","related":"#noprec, #byref, #byval, #assign, indexbase","example":""},
  {"id":"#byval","group":"Oxygen Basic: directives","action":"pass parameter by value (not by its address)","use":"","related":"#byref, #noinit, #noprec, #assign, indexbase","example":""},
  {"id":"#byref","group":"Oxygen Basic: directives","action":"pass parameter using its address instead of its value","use":"","related":"#byval, #noinit, #noprec, #assign, indexbase","example":""},
  {"id":"#assign","group":"Oxygen Basic: directives","action":"'=' always to be an assignment operator in conditional statements","use":"emulate the C convention for the '=' operator","related":"#byref, #byval, #noinit, #noprec, indexbase","example":"#assign on"},
  {"id":"deff","group":"macros","action":"create an assembly code macro for the FPU  (metatype -17)","use":"to create floating point maths functions","related":"Macros, def, #define, macro, sin, cos","example":"deff sine fsin"},
  {"id":"#if","group":"meta control","action":"include block of code if conditions are met","use":"","related":"#else, #elseif, #endif","example":""},
  {"id":"#else","group":"meta control","action":"alternative block of code to include if prior conditions are not met.","use":"","related":"#if, #elseif, #endif","example":""},
  {"id":"#endif","group":"meta control","action":"end of conditional code inclusion block","use":"","related":"#if, #elseif","example":""},
  {"id":"#elseif","group":"meta control","action":"include block of code if these alternative conditions are met","use":"","related":"#if, #else, #endif, #fi","example":""},
  {"id":"#define","group":"macro","action":"define a macro (C syntax)","use":"C preprocessor statements","related":"Macros, macro, def, #ifdef, #ifndef","example":"#define X 32"},
  {"id":"#ifdef","group":"meta control","action":"include code if symbol already defined","use":"to allow blocks of code to be included or omitted at compile time","related":"#if, #elseif, #endif","example":"#ifdef MSWIN"},
  {"id":"undef","group":"macro","action":"remove a previously defined symbol","use":"remove access to private symbols in a module.","related":"scope #define, def, deff, dim","example":""},
  {"id":"macro","group":"Oxygen Basic macro","action":"define a high level macro","use":"many uses. Often a pseudo function for producing","related":"macros, #define, #def, def, deff","example":""},
  {"id":"#print","group":"compile-time diagnostics","action":"display a constant expression during compilation","use":"Compile time diagnostics.","related":"#recordof, #if, #alert, #error","example":"#print \"not implemented\""},
  {"id":"#blockdepth","group":"compile-time diagnostics","action":"return block nesting depth.","use":"to checking block depth at compile time.","related":"scope, #recordof","example":"#blockdepth node x 'use any descriptive label on the line"},
  {"id":"#recordof","group":"compile-time diagnostics","action":"return internal record of a declared entity.","use":"to check status at compile time.","related":"#blockdepth","example":"#recordof MyStructure"},
  {"id":"void","group":"primitive types","action":"","use":"specify a null type","related":"sys, any, types","example":"'Variables:"},
  {"id":"sbyte","group":"primitive types","action":"","use":"specify a signed byte type (8 bits wide)","related":"types","example":"sbyte x=-10"},
  {"id":"byte","group":"primitive types","action":"","use":"specify a byte type (8 bits wide)","related":"types","example":"byte colon=58"},
  {"id":"ubyte","group":"primitive types","action":"","use":"specify a byte type (8 bits wide)","related":"types","example":"ubyte semicolon=59"},
  {"id":"string","group":"primitive types","action":"","use":"specify a string type with 8-bit characters","related":"wstring, types","example":"string s=\"name: \""},
  {"id":"wstring","group":"primitive types","action":"","use":"specify a string type with 16-bit characters, supporting unicode","related":"unic, types","example":"wstring sw"},
  {"id":"bstring","group":"primitive types","action":"","use":"specify a bstring type with 8-bit characters","related":"wbstring, types","example":"bstring s=\"name: \""},
  {"id":"bstr","group":"primitive types","action":"","use":"specify a bstring type with 8-bit characters","related":"wbstring, types","example":"bstr s=\"name: \""},
  {"id":"wbstring","group":"primitive types","action":"","use":"specify a bstring type with 16-bit characters, supporting unicode","related":"bstring, types","example":"wbstring sw"},
  {"id":"char","group":"primitive types","action":"","use":"specify a string of ascii characters (8 bits wide)","related":"wchar, types","example":"char w=\"world\""},
  {"id":"wchar","group":"primitive types","action":"","use":"specify a string of wide characters (16 bits wide)","related":"char, types","example":"wchar w=\"world\""},
  {"id":"asciiz","group":"primitive types","action":"","use":"specify a string of ascii characters (8 bits wide)","related":"wchar, types","example":"asciiz w=\"world\""},
  {"id":"zstring","group":"primitive types","action":"","use":"specify a string of ascii characters (8 bits wide)","related":"wchar, types","example":"zstring w=\"world\""},
  {"id":"wzstring","group":"primitive types","action":"","use":"specify a string of wide characters (16 bits wide)","related":"char, types","example":"wzstring w=\"world\""},
  {"id":"short","group":"primitive types","action":"","use":"specify a short integer (16 bits wide). Also used in conjunction","related":"long, types","example":"short a"},
  {"id":"wide","group":"primitive types","action":"","use":"specify a wide character string (16 bits wide). Also used in conjunction","related":"short, types","example":"wide s"},
  {"id":"long","group":"primitive types","action":"","use":"specify a long integer (32 bits wide). Also used in conjunction","related":"short, types","example":"long i"},
  {"id":"int","group":"primitive types","action":"","use":"specify a long signed integer (32 bits wide)","related":"dword, types","example":"int i=0x7fffffff"},
  {"id":"integer","group":"primitive types","action":"","use":"specify a long signed integer (32 bits wide)","related":"dword, types","example":"integer i=0x7fffffff"},
  {"id":"float","group":"primitive types","action":"","use":"specify a floating point variable (32 bits wide)","related":"single, double, extended, types","example":"float f=1/100"},
  {"id":"single","group":"primitive types","action":"","use":"specify a floating point variable (32 bits wide)","related":"float, double, extended, types","example":"single f=1/100"},
  {"id":"double","group":"primitive types","action":"","use":"specify a double precision floating point variable (64 bits wide)","related":"single, float, extended, types","example":"double f=1/3"},
  {"id":"extended","group":"primitive types","action":"","use":"specify an extended precision floating point variable (80 bits wide)","related":"single, float, double, types","example":"extended e=1/3"},
  {"id":"quad","group":"primitive types","action":"","use":"specify a double precision signed integer (64 bits wide)","related":"qword, int, short, sbyte types","example":"quad q"},
  {"id":"word","group":"primitive types","action":"","use":"specify a short unsigned integer (16 bits wide)","related":"short, int, dword, types","example":"word w=0xA000"},
  {"id":"dword","group":"primitive types","action":"","use":"specify a long unsigned integer (32 bits wide)","related":"word, long, int, quad, types","example":"dword ui=0xA0000000"},
  {"id":"ulong","group":"primitive types","action":"","use":"specify a long unsigned integer (32 bits wide)","related":"uint, word, types","example":"ulong u=0xA0000000"},
  {"id":"uint","group":"primitive types","action":"","use":"specify a long unsigned integer (32 bits wide)","related":"dword, word, byte, types","example":"uint u=0xA0000000"},
  {"id":"qword","group":"primitive types","action":"","use":"specify a 64 bit operand in assembly code","related":"integer, quad, types","example":"fld qword d"},
  {"id":"any","group":"primitive types","action":"","use":"specify a parameter of uncertain type, nominally a signed integer of system width (32/64 bits wide)","related":"sys, types","example":"function f(any*a) {...}"},
  {"id":"sys","group":"primitive types","action":"","use":"specify a signed integer of system width (32/64 bits wide)","related":"any, int, quad, types","example":"sys i=42"},
  {"id":"bool","group":"primitive types","action":"","use":"specify a variable to hold Boolean true/false states","related":"any, types","example":"bool t=true"},
  {"id":"boolean","group":"primitive types","action":"","use":"specify a variable to hold Boolean true/false states","related":"bool, byte, int, any, types","example":"boolean t=true"},
  {"id":"signed","group":"primitive types","action":"specifies the type to be of signed integer","use":"signed type variable","related":"unsigned, int, long, types","example":"signed int v"},
  {"id":"unsigned","group":"primitive types","action":"specifies the type to be of positive numbers only","use":"unsigned type variable","related":"signed, long, word, dword, types","example":"unsigned long v"},
  {"id":"void","group":"primitive types","action":"","use":"to specify the types of variables and create them","related":"","example":"int x"},
  {"id":"news","group":"memory functions","action":"allocates a bstring of null characters given the length in bytes","use":"bstring=news length","related":"frees, nuls, space, bstring, getmemory","example":"b=news 1000"},
  {"id":"frees","group":"memory functions","action":"deallocates a bstring","use":"frees bstring freememory","related":"news nuls, freememory, getmemory","example":"b=news 1000"},
  {"id":"error","group":"string functions","action":"returns a string containing the most recent compile or runtime errors (cleared at start of compiling)","use":"to trap runtime errors","related":"#error, #alert","example":"string e=error"},
  {"id":"nuls","group":"string functions","action":"returns the address of a string of null characters given the length.","use":"string=nuls length","related":"space, string, news, frees, getmemory","example":"s=nuls 1000"},
  {"id":"val","group":"string, functions","action":"returns numeric value of string","use":"value=val string","related":"str hex asc","example":"v=val \"2.5\""},
  {"id":"ltrim","group":"string functions","action":"returns string with white space on the left trimmed off","use":"string=rtrim(string)","related":"rtrim, space, str, lcase, ucase","example":"s=ltrim \"   abc\""},
  {"id":"rtrim","group":"string functions","action":"returns string with white space on the right trimmed off","use":"string=rtrim(string)","related":"ltrim, space, str, lcase, ucase","example":"s=rtrim \"abc   \""},
  {"id":"lcase","group":"string functions","action":"returns lowercase of string","use":"string=lcase(string)","related":"ucase, ltrim, rtrim, asc","example":"s=lcase \"ABCDEF\""},
  {"id":"ucase","group":"string functions","action":"returns uppercase of string","use":"string=ucase(string)","related":"lcase, ltrim, rtrim, asc","example":"s=ucase \"abcdef\""},
  {"id":"string","group":"string functions","action":"returns a string of characters","use":"string=string(length,character)","related":"space, nuls, asc","example":"string=string(4,\"a\")"},
  {"id":"space","group":"string functions","action":"returns a string of spaces","use":"string=space length","related":"nuls, string, ltrim, rtrim","example":"s=space 10"},
  {"id":"left","group":"string functions","action":"returns left part of a string by length","use":"string=left string1,length","related":"right, mid, ltrim, rtrim","example":"s=left \"abcdef\",3"},
  {"id":"mid__function","group":"string functions","action":"returns part of string1 at position with length","use":"string=mid string1, position, length 'if length is omitted then the rest of string1 is returned","related":"left, ltrim, rtrim, instr, mid__command","example":"s=mid \"abcdef\",3 : t=mid \"abcdef\",3,2"},
  {"id":"mid__command","group":"string command","action":"patches string2 into string1 as position","use":"mid(string1,position)=string2 : mid string1,position,string2","related":"mid__function, left, ltrim, rtrim","example":"s=\"abcdef\" : mid s,2,\"BC\""},
  {"id":"instr","group":"string functions","action":"returns position of String2 within string1 searching from start position","use":"location=instr(string1,string2) : location=instr(start,string1,string2)","related":"replace, mid","example":"p=instr(\"abcdef abcdef\",\"def\") : q=instr(8,\"abcdef abcdef\",\"def\")"},
  {"id":"getfile","group":"string functions","action":"copies file content to a string","use":"String=getfile FileName : getfile FileName,String","related":"putfile, print","example":"string s : getfile \"t.txt\",s"},
  {"id":"putfile","group":"string functions","action":"saves a string to a file","use":"putfile FileName, String","related":"getfile, print","example":"putfile \"t.txt\",\"Hello\""},
  {"id":"print","group":"string functions","action":"Displays strings and numbers","use":"print String : print Number","related":"val, str, hex, putfile, getfile","example":"print \"ABC\" : print 123 : print \"ABC: \" 123 \" DEF: \" 456"},
  {"id":"asc","group":"string functions","action":"returns ascii encoding of a character in a string","use":"AsciiCode=asc(String,CharacterPosition)","related":"unic, chr, mid, val, len, str","example":""},
  {"id":"unic","group":"string functions","action":"returns encoding of a character in a wide string","use":"uni=unic(String,CharacterPosition)","related":"asc, wchr, chr, val, mid, len, str","example":""},
  {"id":"len","group":"string functions","action":"returns length of string in charaters","use":"length=len(string)","related":"string, space, mid, sizeof","example":"v=len(\"Hello\")"},
  {"id":"chr","group":"string functions","action":"returns string of 1 character of ascii encoding (0..255)","use":"string=chr(AsciiValue)","related":"wchr, asc, unic, mid string","example":""},
  {"id":"wchr","group":"string functions","action":"returns wide string of a 2 byte character (encoding 0..65535 / 0xffff)","use":"widestring=wchr(WideCharValue)","related":"unic, asc, mid, string","example":"wstring ws=wchr(65)"},
  {"id":"str","group":"string functions","action":"returns string representation of number","use":"String=str(value)","related":"hex, val","example":"s=str(-1.23456)   ' result: -1.23456"},
  {"id":"hex","group":"string functions","action":"returns hexadecimal string representation of integer part of number","use":"hexString=hex(value)","related":"str, val","example":"print hex(14.4)      'result 'E'"},
  {"id":"guidval","group":"string functions","action":"converts guid string to guidval","use":"COM interfaces","related":"guidtxt, com","example":"guid clsid"},
  {"id":"guidtxt","group":"string functions","action":"converts guidval to guidstring","use":"COM interfaces","related":"guidval, com","example":"print guidtxt(clsid)"},
  {"id":"numberformat","group":"intrinsic procedure","action":"control how numbers are converted to strings","use":"change the format of numbers","related":"print, frac, float","example":"numberformat 3,0,0,0 : print 3.14159"},
  {"id":"abs","group":"floating point functions","action":"returns the absolute value of a number (removes negative sign)","use":"AbsoluteValue=abs(value)","related":"round, frac, trunc, floor, ceil","example":"a=abs(-2.5)"},
  {"id":"acos","group":"floating point functions","action":"returns angle in radians given the ratio x/radius","use":"angle=acos(YRRatio)","related":"cos, asin, atn, atan","example":"a=acos(0.5)"},
  {"id":"asin","group":"floating point functions","action":"returns angle in radians given the ratio y/radius","use":"angle=asin(YRRatio)","related":"sin, acos, atn, atan","example":"a=asin(0.5)"},
  {"id":"atan","group":"floating point functions","action":"returns angle in radians given the values of y and x","use":"angle=atan(y,x)","related":"atn, asin, acos, tan","example":"a=atan(0.5,sqr(0.75))"},
  {"id":"atn","group":"floating point functions","action":"returns angle in radians given ratio y/x","use":"angle=atn(YXRatio)","related":"atan, asin, acos, tan","example":"a=atn(1)*4"},
  {"id":"cos","group":"floating point functions","action":"returns cosine value (ratio of x/r)  given angle in radians","use":"Cosine=cos(radians)","related":"sin, tan","example":"c=cos(pi/3)"},
  {"id":"deg","group":"floating point functions","action":"returns degrees from value given in radians","use":"degrees=deg(radians)","related":"rad, atan","example":"d=deg(pi)"},
  {"id":"frac","group":"floating point functions","action":"returns the fractional part of a value","use":"FractionValue=frac(value)","related":"round, abs","example":"n=frac(123.456)"},
  {"id":"hypot","group":"floating point functions","action":"returns the hypotenuse (longest side) of a right angle triangle given the other 2 sides.","use":"hypotenuse=hypot(side1,side2)","related":"sqr, pow","example":"h=hypot(3,4)"},
  {"id":"lin","group":"floating point functions","action":"returns the logarthm of the first value to base e (2.71828182845904523536.)","use":"LogValue=log(Value)","related":"lin2, log10, logn, pow","example":"a=log(10)"},
  {"id":"log","group":"floating point functions","action":"returns the logarthm of the first value to base 2","use":"LogValue=log2(Value)","related":"log, log10, logn, pow","example":"a=log2(32)"},
  {"id":"log","group":"floating point functions","action":"returns the logarthm of the first value to base 10","use":"LogValue=log10(Value)","related":"log, log2, logn, pow","example":"a=log10(100)"},
  {"id":"logn","group":"floating point functions","action":"returns the logarthm of the first value to the base of the second value.","use":"value=logn(value1,value2)","related":"log, log2, log10, pow","example":"u=logn 1000,10) : v=logn(pow(10,1.5),10)"},
  {"id":"mod","group":"floating point functions","action":"returns the remainder of first value divided by the second value","use":"modulus=mod(value1,value2)","related":"round, trunc, floor, ceil, frac, abs","example":"m=mod(83.5, 10)"},
  {"id":"pi","group":"floating point functions","action":"returns pi, the ratio of the circumference of a circle to its diameter","use":"p=pi ' or pi()","related":"tan, atan","example":"p=pi*2"},
  {"id":"exp","group":"floating point functions","action":"returns exponent of a value","use":"a=exp(value)","related":"pow,log, logn","example":"a=exp(1)"},
  {"id":"pow","group":"floating point functions","action":"returns the value of the first value to the power of the second value","use":"a=pow(value,exponent)","related":"log, logn","example":"a=pow(2,3)"},
  {"id":"rad","group":"floating point functions","action":"returns value in radians, given degrees","use":"radians=rad(degrees)","related":"deg, pi","example":"v=rad(180)"},
  {"id":"recip","group":"floating point functions","action":"returns reciprocal of value: a=1/v","use":"reciprocal=recip(value)","related":"sqr, mod, round, pow, log","example":"a=recip(5/4)"},
  {"id":"round","group":"floating point functions","action":"returns a value rounded to the nearest whole number (rounded up or down)","use":"WholeNumber=round(number)","related":"frac, trunc, floor, ceil, mod, abs","example":"m=round(1.49) : n=round(1.5)"},
  {"id":"sgn","group":"floating point functions","action":"returns -1 for negative values, 0 for zero and 1 for positive values","use":"extract the sign of a number","related":"abs, frac, round, mod","example":"a=sgn(-42)"},
  {"id":"sin","group":"floating point functions","action":"returns the sine of a value given in radians","use":"Sine=sin(Radians)","related":"asin, cos, tan","example":"v=sin(pi/6)"},
  {"id":"sqr","group":"floating point functions","action":"returns the square root of a value","use":"SquareRoot=sqr(value)","related":"pow, log, hypot","example":"v=sqr(9)"},
  {"id":"tan","group":"floating point functions","action":"returns the tangent of a value given in radians","use":"tangent=tan(radians)","related":"atan, atn, sin, cos","example":"t=tan(a)"},
  {"id":"floor","group":"floating point functions","action":"round down the value to the most negative integer","use":"IntegerValue=floor(FloatValue)","related":"ceil, round, trunc, frac","example":"i=floor(-123.456)"},
  {"id":"ceil","group":"floating point functions","action":"round up the value to the most positive integer","use":"IntegerValue=ceil(FloatValue)","related":"floor, round, trunc, frac","example":"i=ceil(123.456)"},
  {"id":"trunc","group":"floating point functions","action":"truncate the fractional part of a value and return it","use":"IntegerValue=trunc(FloatValue)","related":"round, floor, ceil, frac","example":"i=trunc(123.456)"},
  {"id":"null","group":"","action":"force pointer value to be 0","use":"passing 0 as a string or structure pointer","related":"byval","example":"ofn.lpstrFileTitle = null"},
  {"id":"byval","group":"","action":"pass a parameter by value","use":"In function prototypes and calls","related":"byref, null, #byval, #byref","example":"'In prototypes: receiving a value directly"},
  {"id":"byref","group":"","action":"pass a parameter by reference (address)","use":"In function prototypes and calls","related":"byval, null, #byref, #byval","example":"'In prototypes: receiving a value indirectly"},
  {"id":"not__conditional","group":"conditional modifier","action":"invert conditional logic","use":"inversion of condition","related":"true, false, not__bits","example":"'if not a>42 then' ...  'if a<=42 then'"},
  {"id":"not__bits","group":"operators","action":"inverts bits","use":"invert bits of variable or expression","related":"not__conditional, true, false","example":"int b=0x55 : a=not(b) 'bitwise inversion a=0xaa"},
  {"id":"extends","group":"secondary keyword","action":"","use":"","related":"has, class, classes","example":""},
  {"id":"has","group":"secondary keyword","action":"","use":"","related":"of, from, extends, class, classes","example":""},
  {"id":"lib","group":"secondary keyword","action":"","use":"","related":"library, declare, extern, alias, link, at","example":""},
  {"id":"export","group":"secondary keyword","action":"","use":"","related":"external, function, sub, extern","example":""},
  {"id":"external","group":"secondary keyword","action":"","use":"","related":"extern, com, export, callback, com, virtual, function, sub, method","example":""},
  {"id":"com","group":"secondary keyword","action":"","use":"","related":"virtual external export class of inherits","example":""},
  {"id":"virtual","group":"secondary keyword","action":"","use":"","related":"com external export class","example":""},
  {"id":"public","group":"","action":"","use":"determines the scope of a class member","related":"protected, private","example":""},
  {"id":"protected","group":"","action":"","use":"determines the scope of a class member","related":"public, private","example":""},
  {"id":"private","group":"","action":"","use":"determines the scope of a class member","related":"protected, public","example":""},
  {"id":"dim","group":"creating variables","action":"","use":"","related":"global, local, static","example":""},
  {"id":"type","group":"inherited structures","action":"","use":"specify compund structure for a variable","related":"struct, typedef","example":""},
  {"id":"end","group":"Oxygen Basic keywords","action":"marks the end of a code block","use":"terminating various block structures","related":"scope, if, do, while, select, function, sub, method, class, macro, def","example":"if a>b then"},
  {"id":"once","group":"secondary keyword","action":"ensures that a file is included in the source code one only.","use":"","related":"include, #include, includepath","example":"#include once \"../../MinWin.inc\""},
  {"id":"$","group":"equates","action":"","use":"","related":"def, #def, macro, #define","example":""},
  {"id":"arrays","group":"creating arrays","action":"","use":"","related":"dim","example":""},
  {"id":"scope","group":"blocks","action":"","use":"","related":"procedures, macros","example":""},
  {"id":"macro","group":"macros","action":"","use":"","related":"macro__functions, macro__operators, procedures","example":""},
  {"id":"init","group":"macro operators","action":"supports operation on compund types","use":"formulating expressions, in conjunction with higher operands","related":"macros, macro__functions, operators","example":""},
  {"id":"macro__functions","group":"","action":"","use":"invoke multi-line macros within expressions","related":"macros, macro__operators","example":""},
  {"id":"function","group":"procedural blocks","action":"","use":"","related":"macro","example":""},
  {"id":"if","group":"conditional blocks","action":"","use":"","related":"selection, loops","example":""},
  {"id":"do","group":"loop blocks","action":"","use":"","related":"iteration, conditionals","example":""},
  {"id":"for","group":"iteration blocks","action":"","use":"","related":"loops","example":""},
  {"id":"select","group":"case selection","action":"","use":"","related":"conditionals","example":""},
  {"id":"declare","group":"declaring procedures","action":"","use":"","related":"procedures, types","example":""},
  {"id":"type","group":"compound structures","action":"define a compound structure for variables","use":"User defined types (UDT)","related":"structures, classes, class","example":""},
  {"id":"objects","group":"object oriented programming","action":"comment till end of line","use":"","related":"structures, class, type, has, of, from, virtual, pure, com, new, del","example":"'this is a comment"},
  {"id":";","group":"Oxygen keywords","action":"comment till end of line","use":"","related":"'   /*   */   //","example":"'this is a comment"},
  {"id":"//","group":"Oxygen keywords","action":"comment till end of line","use":"","related":"'   ;   /*   */","example":"// this is a comment"},
  {"id":"/*","group":"Oxygen keywords","action":"comment till end of block","use":"","related":"skip '   ;   */   //","example":"/* this is a comment */"},
  {"id":"*/","group":"Oxygen keywords","action":"terminate comment block","use":"","related":"/*   //   ;","example":"/* this is a comment */"},
  {"id":"and","group":"Oxygen keywords","action":"","use":"","related":"and, or, xor, operators","example":""},
  {"id":"or","group":"Oxygen keywords","action":"","use":"","related":"and, or=, xor, operators","example":""},
  {"id":"xor","group":"Oxygen keywords","action":"","use":"","related":"and, or, xor=, operators","example":""},
  {"id":"and=","group":"Oxygen keywords","action":"","use":"","related":"and, or, xor, operators","example":""},
  {"id":"or=","group":"Oxygen keywords","action":"","use":"","related":"and, or, xor, operators","example":""},
  {"id":"xor=","group":"Oxygen keywords","action":"","use":"","related":"and, or, xor, operators","example":""},
  {"id":"&&","group":"Oxygen keywords","action":"","use":"","related":"&&, ||, ^^ operators","example":""},
  {"id":"||","group":"Oxygen keywords","action":"","use":"","related":"&&, ||, ^^ operators","example":""},
  {"id":"^^","group":"Oxygen keywords","action":"","use":"","related":"&&, ||, ^^ operators","example":""},
  {"id":"&&=","group":"Oxygen keywords","action":"","use":"","related":"&&, ||, ^^ operators","example":""},
  {"id":"||=","group":"Oxygen keywords","action":"","use":"","related":"&&, ||, ^^ operators","example":""},
  {"id":"^^=","group":"Oxygen keywords","action":"","use":"","related":"&&, ||, ^^ operators","example":""},
  {"id":"and","group":"operators and comparators","action":"changes the state of an accumulator","use":"formulating expressions, in conjunction with operands","related":"types","example":"a*b+c/4"},
  {"id":"stdcall","group":"calling conventions","action":"determines how parameters are passed on the stack","use":"declaring external functions","related":"calling_conventions, cdecl, ms64, pascal","example":"! Sleep lib \"kernel32.dll\" stdcall (int msec)"},
  {"id":"pascal","group":"calling conventions","action":"determines how parameters are passed on the stack","use":"declaring external functions","related":"calling_conventions, stdcall, cdecl, ms64","example":"! Sleep lib \"kernel32.dll\" stdcall (int msec)"},
  {"id":"cdecl","group":"calling conventions","action":"determines how parameters are passed on the stack","use":"declaring external functions, and variadic functions","related":"calling_conventions, cdecl, ms64, pascal, callback","example":""},
  {"id":"ms","group":"calling conventions","action":"determines how parameters are passed on the stack","use":"declaring external functions, and variadic functions","related":"calling_conventions, stdcall, cdecl, pascal","example":""},
  {"id":"stdcall","group":"calling conventions","action":"determines how parameters are passed on the stack, when making a call","use":"","related":"extern","example":""},
  {"id":"defined","group":"meta control","action":"","use":"","related":"#if, #elseif, #else, #endif, typeof, typecodeof, def, macro","example":""},
  {"id":"defined","group":"meta control","action":"test whether a symbol exists","use":"to allow blocks of code to be included or omitted at compile time","related":"undefined, #ifdef, #ifndef, #if, #elseif, #else, #endif, def, macro","example":""},
  {"id":"undefined","group":"meta control","action":"test whether a symbol exists","use":"to allow blocks of code to be included or omitted at compile time","related":"defined, #ifdef, #ifndef, #if, #elseif, #else, #endif, def, macro","example":""},
  {"id":"match","group":"meta control","action":"match testing of symbol names","use":"to allow blocks of code to be included or omitted at compile time","related":"leftmatch, rightmatch, anymatch, #if, #elseif, #else, #endif, typeof, typecodeof, def, macro","example":""},
  {"id":"leftmatch","group":"meta control","action":"match testing of symbol names","use":"to allow blocks of code to be included or omitted at compile time","related":"match, rightmatch, anymatch, #if, #elseif, #else, #endif, typeof, typecodeof, def, macro","example":""},
  {"id":"rightmatch","group":"meta control","action":"match testing of symbol names","use":"to allow blocks of code to be included or omitted at compile time","related":"match, leftmatch, anymatch, #if, #elseif, #else, #endif, typeof, typecodeof, def, macro","example":""},
  {"id":"anymatch","group":"meta control","action":"match testing of symbol names","use":"to allow blocks of code to be included or omitted at compile time","related":"match, leftmatch, rightmatch, #if, #elseif, #else, #endif, typeof, typecodeof, def, macro","example":""},
  {"id":"al","group":"X86 CPU registers","action":"","use":"access CPU registers directly using Assembly code","related":"","example":"mov eax,42"}
];